/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.failsafe.Request;
import org.spf4j.failsafe.Response;
import org.spf4j.failsafe.Server;

public final class ServerCall
implements Callable<Response> {
    private static final Logger LOG = LoggerFactory.getLogger(ServerCall.class);
    private final Server server;
    private final Request request;

    public ServerCall(Server server, Request request) {
        this.server = server;
        this.request = request;
    }

    @Override
    public Response call() throws Exception {
        LOG.debug("Invoking {}", (Object)this.request);
        try {
            Response response = this.server.execute(this.request);
            LOG.debug("Finished {}, returning {}", (Object)this.request, (Object)response);
            return response;
        }
        catch (Exception ex) {
            LOG.debug("Errored {}", (Object)this.request, (Object)ex);
            throw ex;
        }
    }

    public Server getServer() {
        return this.server;
    }

    public Request getRequest() {
        return this.request;
    }

    public String toString() {
        return "ServerCall{request=" + this.request + '}';
    }
}

