/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io.csv;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.junit.Assert;
import org.junit.Test;
import org.spf4j.io.csv.CharSeparatedValues;
import org.spf4j.io.csv.CsvParseException;
import org.spf4j.io.csv.CsvReader;
import org.spf4j.io.csv.CsvWriter;

public class CharSeparatedValuesTest {
    @Test
    public void testCsvReaderEmpty() throws IOException, CsvParseException {
        CharSeparatedValues csv = new CharSeparatedValues(' ');
        CsvReader reader = csv.reader((Reader)new StringReader(""));
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.END_ROW, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.END_DOCUMENT, (Object)reader.next());
    }

    @Test
    public void testCsvReaderEmpty2() throws IOException, CsvParseException {
        CharSeparatedValues csv = new CharSeparatedValues(' ');
        CsvReader reader = csv.reader((Reader)new StringReader("\r"));
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.END_ROW, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.END_DOCUMENT, (Object)reader.next());
    }

    @Test
    public void testCsvReader() throws IOException, CsvParseException {
        CharSeparatedValues csv = new CharSeparatedValues(' ');
        CsvReader reader = csv.reader((Reader)new StringReader("a b c\nd e"));
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"a", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"b", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"c", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.END_ROW, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.END_ROW, (Object)reader.current());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.current());
        Assert.assertEquals((Object)"d", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"e", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.END_ROW, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.END_DOCUMENT, (Object)reader.next());
    }

    @Test
    public void testCsvReaderX() throws IOException, CsvParseException {
        CharSeparatedValues csv = new CharSeparatedValues(' ');
        CsvReader reader = csv.reader((Reader)new StringReader("a b c\nd e\n"));
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"a", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"b", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"c", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.END_ROW, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.END_ROW, (Object)reader.current());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.current());
        Assert.assertEquals((Object)"d", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"e", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.END_ROW, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.END_DOCUMENT, (Object)reader.next());
    }

    @Test
    public void testCsvReaderXX() throws IOException, CsvParseException {
        CharSeparatedValues csv = new CharSeparatedValues(' ');
        CsvReader reader = csv.readerILEL((Reader)new StringReader("a b c\r\nd e\r\n"));
        Assert.assertEquals((Object)CsvReader.TokenType.START_DOCUMENT, (Object)reader.current());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"a", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"b", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"c", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.END_ROW, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.END_ROW, (Object)reader.current());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.current());
        Assert.assertEquals((Object)"d", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"e", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.END_ROW, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.END_DOCUMENT, (Object)reader.next());
    }

    @Test
    public void testCsvReaderXXX() throws IOException, CsvParseException {
        CharSeparatedValues csv = new CharSeparatedValues(' ');
        CsvReader reader = csv.readerILEL((Reader)new StringReader("a b c\n\rd e\n\r"));
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"a", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"b", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"c", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.END_ROW, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.END_ROW, (Object)reader.current());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.current());
        Assert.assertEquals((Object)"d", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"e", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.END_ROW, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.END_DOCUMENT, (Object)reader.next());
    }

    @Test
    public void testCsvReader2() throws IOException, CsvParseException {
        CharSeparatedValues csv = new CharSeparatedValues(' ');
        CsvReader reader = csv.reader((Reader)new StringReader(""));
        Assert.assertEquals((Object)CsvReader.TokenType.START_DOCUMENT, (Object)reader.current());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.END_ROW, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.END_DOCUMENT, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.END_DOCUMENT, (Object)reader.current());
    }

    @Test
    public void testCsvReader3() throws IOException, CsvParseException {
        CharSeparatedValues csv = new CharSeparatedValues(' ');
        CsvReader reader = csv.reader((Reader)new StringReader("a b c\nd e"));
        int nrElems = reader.skipRow();
        Assert.assertEquals((long)3L, (long)nrElems);
        nrElems = reader.skipRow();
        Assert.assertEquals((long)2L, (long)nrElems);
    }

    @Test
    public void testCsvWriter() throws IOException, CsvParseException {
        CharSeparatedValues csv = new CharSeparatedValues(' ');
        StringWriter writer = new StringWriter();
        CsvWriter csvW = csv.writer((Writer)writer);
        csvW.writeElement((CharSequence)"a");
        csvW.writeElement((CharSequence)"b");
        csvW.writeElement((CharSequence)"c");
        csvW.writeEol();
        csvW.writeElement((CharSequence)"d");
        csvW.writeElement((CharSequence)"e");
        Assert.assertEquals((Object)"a b c\nd e", (Object)writer.toString());
    }

    @Test
    public void testCsvWriter2() throws IOException, CsvParseException {
        CharSeparatedValues csv = new CharSeparatedValues(' ');
        StringWriter writer = new StringWriter();
        CsvWriter csvW = csv.writer((Writer)writer);
        csvW.writeElement((CharSequence)"");
        Assert.assertEquals((Object)"", (Object)writer.toString());
    }

    @Test
    public void testCsvWriter3() throws IOException, CsvParseException {
        CharSeparatedValues csv = new CharSeparatedValues(' ');
        StringWriter writer = new StringWriter();
        CsvWriter csvW = csv.writer((Writer)writer);
        csvW.writeElement((CharSequence)"");
        csvW.writeElement((CharSequence)"b ");
        Assert.assertEquals((Object)" \"b \"", (Object)writer.toString());
    }
}

