/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.log;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;
import org.spf4j.base.ExecutionContext;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.log.ExecContextLogger;
import org.spf4j.log.Level;
import org.spf4j.log.LogAttribute;
import org.spf4j.log.Slf4jLogRecord;
import org.spf4j.test.log.LogAssert;
import org.spf4j.test.log.TestLoggers;
import org.spf4j.test.log.annotations.ExpectLog;
import org.spf4j.test.matchers.LogMatchers;

@SuppressFBWarnings(value={"LO_SUSPECT_LOG_CLASS"})
public class ExecContextLoggerTest {
    @Test
    @ExpectLog(level=Level.TRACE, messageRegexp="msg1")
    public void testTrace() {
        ExecContextLogger log = new ExecContextLogger(LoggerFactory.getLogger((String)"test"));
        log.trace("msg1");
        ArrayList logs = new ArrayList(2);
        ExecutionContexts.current().streamLogs(logs::add);
        Assert.assertEquals((Object)"msg1", (Object)((Slf4jLogRecord)logs.get(0)).getMessageFormat());
    }

    @Test
    public void testTrace2() {
        ExecContextLogger log = new ExecContextLogger(LoggerFactory.getLogger((String)"test"));
        LogAssert expect = TestLoggers.sys().expect("test", Level.DEBUG, new Matcher[]{Matchers.allOf((Matcher)LogMatchers.hasExtraArgument((Object)LogAttribute.origLevel((Level)Level.TRACE)), (Matcher)LogMatchers.hasMessage((String)"msg1"))});
        ExecutionContext current = ExecutionContexts.current();
        current.setBackendMinLogLevel("test", Level.TRACE);
        log.trace("msg1");
        expect.assertObservation();
        ArrayList logs = new ArrayList(2);
        current.streamLogs(logs::add);
        Assert.assertEquals((Object)"msg1", (Object)((Slf4jLogRecord)logs.get(0)).getMessageFormat());
    }
}

