/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl;

import java.io.IOException;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.spf4j.jmx.Client;
import org.spf4j.perf.CloseableMeasurementRecorder;
import org.spf4j.perf.CloseableMeasurementRecorderSource;
import org.spf4j.perf.MeasurementRecorder;
import org.spf4j.perf.impl.RecorderFactory;

public class RecorderFactoryTest {
    @Test
    public void testRecorderFactory() throws InterruptedException, IOException, InstanceNotFoundException, MBeanException, AttributeNotFoundException, ReflectionException {
        CloseableMeasurementRecorder rec = RecorderFactory.createScalableQuantizedRecorder2(RecorderFactoryTest.class, (String)"ms", (int)100000000, (int)10, (int)0, (int)6, (int)10);
        rec.record(1L);
        int sum = 1;
        for (int i = 0; i < 10; ++i) {
            rec.record((long)i);
            sum += i;
        }
        String ret3 = (String)Client.getAttribute((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"org.spf4j.perf.recorders", (String)("class_" + RecorderFactoryTest.class.getName()), (String)"measurementsAsString");
        Assert.assertThat((Object)ret3, (Matcher)Matchers.containsString((String)(sum + "," + 11)));
        rec.close();
    }

    @Test
    public void testRecorderFactory2() throws InterruptedException, IOException, InstanceNotFoundException, MBeanException, AttributeNotFoundException, ReflectionException {
        CloseableMeasurementRecorder rec = RecorderFactory.createScalableQuantizedRecorder2(RecorderFactoryTest.class, (String)"ms", (int)100000000, (int)10, (int)0, (int)6, (int)10);
        CompositeData ret3 = (CompositeData)Client.getAttribute((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"org.spf4j.perf.recorders", (String)("class_" + RecorderFactoryTest.class.getName()), (String)"measurements");
        Assert.assertNull((Object)ret3);
        rec.close();
    }

    @Test
    public void testRecorderFactoryDyna() throws InterruptedException, IOException, InstanceNotFoundException, MBeanException, AttributeNotFoundException, ReflectionException {
        CloseableMeasurementRecorderSource rec = RecorderFactory.createScalableQuantizedRecorderSource2(RsTest.class, (String)"ms", (int)100000000, (int)10, (int)0, (int)6, (int)10);
        MeasurementRecorder recorder = rec.getRecorder((Object)"test");
        recorder.record(1L);
        int sum = 1;
        for (int i = 0; i < 10; ++i) {
            recorder.record((long)i);
            sum += i;
        }
        String ret3 = (String)Client.getAttribute((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"org.spf4j.perf.recorders", (String)("class_" + RecorderFactoryTest.class.getName() + "_RsTest"), (String)"measurementsAsString");
        Assert.assertThat((Object)ret3, (Matcher)Matchers.containsString((String)("test," + sum + "," + 11)));
        rec.close();
    }

    private static final class RsTest {
        private RsTest() {
        }
    }
}

