/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl.acc;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Arrays;
import org.spf4j.perf.impl.acc.QuantizedAccumulator;

public final class QuantizedRecorderTest {
    private static final Logger LOG = LoggerFactory.getLogger(QuantizedRecorderTest.class);

    @Test
    public void testMagnitudes2() {
        long[] createMagnitudeLimits = QuantizedAccumulator.createMagnitudeLimits2((int)10, (int)-2, (int)3);
        Assert.assertArrayEquals((long[])new long[]{-100L, -10L, 0L, 10L, 100L, 1000L}, (long[])createMagnitudeLimits);
        createMagnitudeLimits = QuantizedAccumulator.createMagnitudeLimits2((int)3, (int)-2, (int)3);
        Assert.assertArrayEquals((long[])new long[]{-9L, -3L, 0L, 3L, 9L, 27L}, (long[])createMagnitudeLimits);
        createMagnitudeLimits = QuantizedAccumulator.createMagnitudeLimits2((int)10, (int)2, (int)3);
        Assert.assertArrayEquals((long[])new long[]{100L, 1000L}, (long[])createMagnitudeLimits);
        createMagnitudeLimits = QuantizedAccumulator.createMagnitudeLimits2((int)10, (int)-3, (int)-1);
        Assert.assertArrayEquals((long[])new long[]{-1000L, -100L, -10L}, (long[])createMagnitudeLimits);
    }

    @Test
    public void testFindBucket() {
        long[] bucketLimits = new long[]{-100L, -80L, -60L, -40L, -10L, -8L, -6L, -4L, -2L, 0L, 2L, 4L, 6L, 8L, 10L, 40L, 60L, 80L, 100L};
        Assert.assertEquals((long)0L, (long)QuantizedAccumulator.findBucket((long[])bucketLimits, (long)-1000L));
        Assert.assertEquals((long)1L, (long)QuantizedAccumulator.findBucket((long[])bucketLimits, (long)-100L));
        Assert.assertEquals((long)1L, (long)QuantizedAccumulator.findBucket((long[])bucketLimits, (long)-90L));
        Assert.assertEquals((long)4L, (long)QuantizedAccumulator.findBucket((long[])bucketLimits, (long)-40L));
        Assert.assertEquals((long)4L, (long)QuantizedAccumulator.findBucket((long[])bucketLimits, (long)-35L));
        Assert.assertEquals((long)10L, (long)QuantizedAccumulator.findBucket((long[])bucketLimits, (long)0L));
        Assert.assertEquals((long)12L, (long)QuantizedAccumulator.findBucket((long[])bucketLimits, (long)5L));
        Assert.assertEquals((long)19L, (long)QuantizedAccumulator.findBucket((long[])bucketLimits, (long)100L));
        Assert.assertEquals((long)19L, (long)QuantizedAccumulator.findBucket((long[])bucketLimits, (long)101L));
    }

    @Test
    public void testRecord1() {
        QuantizedAccumulator instance = new QuantizedAccumulator((Object)"test", "", "ms", 10, 0, 3, 10);
        instance.record(-1L);
        instance.record(0L);
        instance.record(0L);
        instance.record(1L);
        instance.record(1L);
        instance.record(1L);
        instance.record(2L);
        instance.record(2L);
        instance.record(2L);
        instance.record(2L);
        instance.record(10L);
        instance.record(11L);
        instance.record(250L);
        instance.record(250L);
        instance.record(15000L);
        instance.record(15000L);
        LOG.debug("Quantized Acc = {}", (Object)instance);
        Assert.assertEquals((long)15000L, (long)instance.getMaxMeasurement());
        Assert.assertEquals((long)-1L, (long)instance.getMinMeasurement());
        long[] vals = instance.get();
        Assert.assertEquals((long)instance.getInfo().getNumberOfMeasurements(), (long)vals.length);
        Object[] measurementNames = instance.getInfo().getMeasurementNames();
        int niIdx = Arrays.indexOf((Object[])measurementNames, (Object)"QNI_0");
        Assert.assertEquals((long)1L, (long)vals[niIdx]);
        int q23Idx = Arrays.indexOf((Object[])measurementNames, (Object)"Q2_3");
        Assert.assertEquals((long)4L, (long)vals[q23Idx]);
        int qPIIdx = Arrays.indexOf((Object[])measurementNames, (Object)"Q1000_PI");
        Assert.assertEquals((long)2L, (long)vals[qPIIdx]);
        int q2300Idx = Arrays.indexOf((Object[])measurementNames, (Object)"Q200_300");
        Assert.assertEquals((long)2L, (long)vals[q2300Idx]);
    }

    @Test
    public void testRecord2() {
        QuantizedAccumulator instance = new QuantizedAccumulator((Object)"test", "", "ms", 10, -3, 3, 10);
        instance.record(-15000L);
        instance.record(-15000L);
        instance.record(-15000L);
        instance.record(-300L);
        instance.record(-300L);
        instance.record(-1L);
        instance.record(0L);
        instance.record(0L);
        instance.record(1L);
        instance.record(1L);
        instance.record(1L);
        instance.record(2L);
        instance.record(2L);
        instance.record(2L);
        instance.record(2L);
        instance.record(10L);
        instance.record(11L);
        instance.record(250L);
        instance.record(250L);
        instance.record(15000L);
        LOG.debug("Quantized Acc = {}", (Object)instance);
        Assert.assertEquals((long)15000L, (long)instance.getMaxMeasurement());
        Assert.assertEquals((long)-15000L, (long)instance.getMinMeasurement());
        long[] vals = instance.get();
        Assert.assertEquals((long)instance.getInfo().getNumberOfMeasurements(), (long)vals.length);
        Object[] measurementNames = instance.getInfo().getMeasurementNames();
        int niIdx = Arrays.indexOf((Object[])measurementNames, (Object)"QNI_-1000");
        Assert.assertEquals((long)3L, (long)vals[niIdx]);
        int q23Idx = Arrays.indexOf((Object[])measurementNames, (Object)"Q2_3");
        Assert.assertEquals((long)4L, (long)vals[q23Idx]);
        int n10Idx = Arrays.indexOf((Object[])measurementNames, (Object)"Q-1_0");
        Assert.assertEquals((long)1L, (long)vals[n10Idx]);
        int qPIIdx = Arrays.indexOf((Object[])measurementNames, (Object)"Q1000_PI");
        long[] get = vals;
        Assert.assertEquals((long)1L, (long)get[qPIIdx]);
        int q2300Idx = Arrays.indexOf((Object[])measurementNames, (Object)"Q200_300");
        Assert.assertEquals((long)2L, (long)vals[q2300Idx]);
        int nq2300Idx = Arrays.indexOf((Object[])measurementNames, (Object)"Q-300_-200");
        Assert.assertEquals((long)2L, (long)vals[nq2300Idx]);
    }

    @Test
    public void testRecord2P() {
        QuantizedAccumulator instance = new QuantizedAccumulator((Object)"test", "", "ms", 10, -3, 3, 5);
        instance.record(-15000L);
        instance.record(-15000L);
        instance.record(-15000L);
        instance.record(-300L);
        instance.record(-300L);
        instance.record(-400L);
        instance.record(-350L);
        instance.record(-101L);
        instance.record(-100L);
        instance.record(-1L);
        instance.record(0L);
        instance.record(0L);
        instance.record(1L);
        instance.record(1L);
        instance.record(1L);
        instance.record(2L);
        instance.record(2L);
        instance.record(2L);
        instance.record(2L);
        instance.record(10L);
        instance.record(11L);
        instance.record(250L);
        instance.record(250L);
        instance.record(100L);
        instance.record(399L);
        instance.record(200L);
        instance.record(400L);
        instance.record(600L);
        instance.record(15000L);
        LOG.debug("Quantized Acc = {}", (Object)instance);
        Assert.assertEquals((long)15000L, (long)instance.getMaxMeasurement());
        Assert.assertEquals((long)-15000L, (long)instance.getMinMeasurement());
        long[] vals = instance.get();
        Assert.assertEquals((long)instance.getInfo().getNumberOfMeasurements(), (long)vals.length);
        Object[] measurementNames = instance.getInfo().getMeasurementNames();
        int niIdx = Arrays.indexOf((Object[])measurementNames, (Object)"QNI_-1000");
        Assert.assertEquals((long)3L, (long)vals[niIdx]);
        int niIdx2 = Arrays.indexOf((Object[])measurementNames, (Object)"Q100_400");
        Assert.assertEquals((long)5L, (long)vals[niIdx2]);
        int niIdx3 = Arrays.indexOf((Object[])measurementNames, (Object)"Q400_600");
        Assert.assertEquals((long)1L, (long)vals[niIdx3]);
        int niIdx4 = Arrays.indexOf((Object[])measurementNames, (Object)"Q-400_-100");
        Assert.assertEquals((long)5L, (long)vals[niIdx4]);
        int niIdx5 = Arrays.indexOf((Object[])measurementNames, (Object)"Q600_800");
        Assert.assertEquals((long)1L, (long)vals[niIdx5]);
    }

    @Test
    public void testRecord3() {
        long[] vals;
        QuantizedAccumulator instance = new QuantizedAccumulator((Object)"test", "", "ms", 10, 0, 1, 10);
        instance.record(-1L);
        instance.record(0L);
        instance.record(1L);
        instance.record(2L);
        instance.record(2L);
        instance.record(10L);
        instance.record(11L);
        instance.record(250L);
        instance.record(15000L);
        LOG.debug("Quantized Acc = {}", (Object)instance);
        long[] result = vals = instance.get();
        LOG.debug("Values = {}", (Object)result);
        Object[] measurementNames = instance.getInfo().getMeasurementNames();
        int niIdx = Arrays.indexOf((Object[])measurementNames, (Object)"QNI_0");
        Assert.assertEquals((long)1L, (long)vals[niIdx]);
        int niIdx2 = Arrays.indexOf((Object[])measurementNames, (Object)"Q10_PI");
        Assert.assertEquals((long)4L, (long)vals[niIdx2]);
        int niIdx3 = Arrays.indexOf((Object[])measurementNames, (Object)"Q2_3");
        Assert.assertEquals((long)2L, (long)vals[niIdx3]);
    }

    @Test
    public void testRecord4() {
        long[] vals;
        QuantizedAccumulator instance = new QuantizedAccumulator((Object)"test", "", "ms", 10, -1, 1, 10);
        instance.record(0L);
        instance.record(1L);
        instance.record(2L);
        instance.record(10L);
        instance.record(11L);
        instance.record(250L);
        instance.record(15000L);
        instance.record(-15000L);
        instance.record(-10L);
        instance.record(-10L);
        LOG.debug("Quantized Acc = {}", (Object)instance);
        long[] result = vals = instance.get();
        LOG.debug("Metrics = {}", (Object)result);
        Object[] measurementNames = instance.getInfo().getMeasurementNames();
        int niIdx = Arrays.indexOf((Object[])measurementNames, (Object)"QNI_-10");
        Assert.assertEquals((long)1L, (long)vals[niIdx]);
        int niIdx2 = Arrays.indexOf((Object[])measurementNames, (Object)"Q10_PI");
        Assert.assertEquals((long)4L, (long)vals[niIdx2]);
        int niIdx3 = Arrays.indexOf((Object[])measurementNames, (Object)"Q2_3");
        Assert.assertEquals((long)1L, (long)vals[niIdx3]);
    }
}

