/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl.ms.tsdb;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.Files;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.avro.Schema;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Runtime;
import org.spf4j.base.avro.AvroCloseableIterable;
import org.spf4j.perf.MeasurementStoreQuery;
import org.spf4j.perf.MeasurementsInfo;
import org.spf4j.perf.TimeSeriesRecord;
import org.spf4j.perf.impl.MeasurementsInfoImpl;
import org.spf4j.perf.impl.ms.tsdb.AvroMeasurementStore;
import org.spf4j.tsdb2.avro.Aggregation;
import org.spf4j.tsdb2.avro.MeasurementType;

public class AvroMeasurementStoreTest {
    private static final Logger LOG = LoggerFactory.getLogger(AvroMeasurementStoreTest.class);

    @Test
    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public void testStore() throws IOException {
        AvroMeasurementStore store = new AvroMeasurementStore(Runtime.TMP_FOLDER_PATH, "testMetrics", false);
        long mid = store.alocateMeasurements((MeasurementsInfo)new MeasurementsInfoImpl((Object)"test", "test", new String[]{"v1", "v2"}, new String[]{"t1", "t2"}, new Aggregation[]{Aggregation.SUM, Aggregation.LAST}, MeasurementType.GAUGE), 1000);
        store.saveMeasurements(mid, 0L, new long[]{1L, 2L});
        store.saveMeasurements(mid, 1000L, new long[]{3L, 4L});
        store.saveMeasurements(mid, 2000L, new long[]{5L, 6L});
        store.saveMeasurements(mid, 2000L, new long[]{7L, 8L});
        store.saveMeasurements(mid, 3000L, new long[]{9L, 10L});
        store.saveMeasurements(mid, 4000L, new long[]{11L, 12L});
        store.flush();
        MeasurementStoreQuery query = store.query();
        Collection measurements = query.getMeasurements(x -> true);
        Schema metric = (Schema)measurements.iterator().next();
        Assert.assertEquals((Object)"test", (Object)metric.getName());
        List<TimeSeriesRecord> results = AvroMeasurementStoreTest.getMetrics(query, metric, Instant.EPOCH, Instant.now());
        Assert.assertEquals((long)6L, (long)results.size());
        TimeSeriesRecord rec = results.get(0);
        Assert.assertEquals((Object)Instant.ofEpochMilli(0L), (Object)rec.getTimeStamp());
        Assert.assertEquals((long)1L, (long)rec.getLongValue("v1"));
        Assert.assertEquals((long)2L, (long)rec.getLongValue("v2"));
        rec = results.get(5);
        Assert.assertEquals((Object)Instant.ofEpochMilli(4000L), (Object)rec.getTimeStamp());
        Assert.assertEquals((long)11L, (long)rec.getLongValue("v1"));
        Assert.assertEquals((long)12L, (long)rec.getLongValue("v2"));
        results = AvroMeasurementStoreTest.getMetrics(query, metric, Instant.ofEpochMilli(2000L), Instant.ofEpochMilli(2000L));
        Assert.assertEquals((long)2L, (long)results.size());
        rec = results.get(0);
        Assert.assertEquals((Object)Instant.ofEpochMilli(2000L), (Object)rec.getTimeStamp());
        Assert.assertEquals((long)5L, (long)rec.getLongValue("v1"));
        Assert.assertEquals((long)6L, (long)rec.getLongValue("v2"));
        rec = results.get(1);
        Assert.assertEquals((Object)Instant.ofEpochMilli(2000L), (Object)rec.getTimeStamp());
        Assert.assertEquals((long)7L, (long)rec.getLongValue("v1"));
        Assert.assertEquals((long)8L, (long)rec.getLongValue("v2"));
        List<TimeSeriesRecord> aggr = AvroMeasurementStoreTest.getMetrics(query, metric, Instant.EPOCH, Instant.now(), 1000);
        Assert.assertEquals((long)5L, (long)aggr.size());
        rec = aggr.get(0);
        Assert.assertEquals((Object)Instant.ofEpochMilli(0L), (Object)rec.getTimeStamp());
        Assert.assertEquals((long)1L, (long)rec.getLongValue("v1"));
        Assert.assertEquals((long)2L, (long)rec.getLongValue("v2"));
        rec = aggr.get(2);
        Assert.assertEquals((Object)Instant.ofEpochMilli(2000L), (Object)rec.getTimeStamp());
        Assert.assertEquals((long)12L, (long)rec.getLongValue("v1"));
        Assert.assertEquals((long)8L, (long)rec.getLongValue("v2"));
        aggr = AvroMeasurementStoreTest.getMetrics(query, metric, Instant.EPOCH, Instant.now(), 1500);
        Assert.assertEquals((long)5L, (long)aggr.size());
        aggr = AvroMeasurementStoreTest.getMetrics(query, metric, Instant.EPOCH, Instant.now(), 0);
        Assert.assertEquals((long)6L, (long)aggr.size());
        store.close();
        Files.delete(store.getInfoFile());
        Files.delete(store.getDataFile());
    }

    public static List<TimeSeriesRecord> getMetrics(MeasurementStoreQuery query, Schema metric, Instant from, Instant to) throws IOException {
        ArrayList<TimeSeriesRecord> results = new ArrayList<TimeSeriesRecord>();
        try (AvroCloseableIterable data = query.getMeasurementData(metric, from, to);){
            for (TimeSeriesRecord rec : data) {
                LOG.debug("data", (Object)rec);
                results.add(rec);
            }
        }
        return results;
    }

    public static List<TimeSeriesRecord> getMetrics(MeasurementStoreQuery query, Schema metric, Instant from, Instant to, int aggMillis) throws IOException {
        ArrayList<TimeSeriesRecord> results = new ArrayList<TimeSeriesRecord>();
        try (AvroCloseableIterable data = query.getAggregatedMeasurementData(metric, from, to, aggMillis, TimeUnit.MILLISECONDS);){
            for (TimeSeriesRecord rec : data) {
                LOG.debug("agg", (Object)rec);
                results.add(rec);
            }
        }
        return results;
    }
}

