/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.memory;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.map.TObjectLongMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.perf.memory.GCUsageSampler;

public final class GCUsageSamplerTest {
    private static final Logger LOG = LoggerFactory.getLogger(GCUsageSamplerTest.class);

    @Test
    public void testSomeMethod() throws InterruptedException {
        this.assertSamplerBehavior();
        this.assertSamplerBehavior();
    }

    @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
    private void assertSamplerBehavior() throws InterruptedException {
        GCUsageSampler.start((int)100);
        String str = "";
        for (int i = 0; i < 100000; ++i) {
            str = Integer.toString(i);
        }
        LOG.debug("lastNr = {}", (Object)str);
        Thread.sleep(1000L);
        GCUsageSampler.stop();
        Assert.assertFalse((boolean)GCUsageSampler.isStarted());
    }

    @Test
    public void testSampling() {
        List beans = GCUsageSampler.getMBEANS();
        long gcTimeDiff = GCUsageSampler.getGCTimeDiff((Iterable)beans, (TObjectLongMap)new TObjectLongHashMap());
        Assert.assertTrue((gcTimeDiff >= 0L ? 1 : 0) != 0);
    }
}

