/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.reflect;

import com.google.common.net.HostAndPort;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.spf4j.reflect.GraphTypeMap;
import org.spf4j.tsdb2.avro.ColumnDef;

public class GraphTypeMapTest {
    @Test
    public void testSomeMethod() {
        GraphTypeMap registry = new GraphTypeMap();
        registry.safePut(List.class, (Object)"LIST");
        registry.safePut(Object.class, (Object)"OBJECT");
        Assert.assertEquals((Object)"LIST", (Object)registry.get(ArrayList.class));
        Assert.assertEquals((Object)"OBJECT", (Object)registry.get(Map.class));
        Assert.assertEquals((Object)"OBJECT", (Object)registry.get(Object.class));
    }

    @Test
    public void testBehavior() {
        GraphTypeMap registry = new GraphTypeMap();
        registry.safePut(Object.class, (Object)"OBJECT");
        registry.safePut(GraphTypeMapTest.class, (Object)"TEST");
        registry.safePut(CharSequence.class, (Object)"CHARSEQUENCE");
        registry.safePut(Serializable.class, (Object)"SERIALIZABLE");
        registry.safePut(Deque.class, (Object)"DEQUE");
        registry.safePut(Collection.class, (Object)"COLLECTION");
        Assert.assertEquals((Object)"TEST", (Object)registry.get(GraphTypeMapTest.class));
        Assert.assertEquals((Object)"OBJECT", (Object)registry.get(Object.class));
        try {
            registry.get(String.class);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertThat((Object)registry.getAll(String.class), (Matcher)Matchers.hasItems((Object[])new String[]{"SERIALIZABLE", "CHARSEQUENCE"}));
        Assert.assertEquals((Object)"SERIALIZABLE", (Object)registry.get(HostAndPort.class));
        Assert.assertEquals((Object)"SERIALIZABLE", (Object)registry.get(ColumnDef.class));
        Assert.assertThat((Object)registry.getAll(ArrayDeque.class), (Matcher)Matchers.hasItems((Object[])new String[]{"SERIALIZABLE", "DEQUE"}));
    }
}

