/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.avro.Method;
import org.spf4j.stackmonitor.MethodMap;

public class MethodMapTest {
    private static final Logger LOG = LoggerFactory.getLogger(MethodMapTest.class);

    @Test
    public void test() {
        MethodMap map = new MethodMap(0);
        Assert.assertEquals((long)0L, (long)map.size());
        Method m = new Method("org.apache.avro.Schema", "toString");
        Assert.assertNull((Object)map.get((Object)m));
        Assert.assertNull((Object)map.get(null));
        map.forEachEntry((a, b) -> true);
        map.forEachKey(a -> true);
        map.forEachValue(a -> true);
        Assert.assertTrue((boolean)map.entrySet().isEmpty());
        Assert.assertTrue((boolean)map.values().isEmpty());
        Assert.assertTrue((boolean)map.keySet().isEmpty());
        Method m2 = new Method("org.apache.avro.Schema", "toString2");
        map.put((Object)m2, (Object)Integer.MIN_VALUE);
        map.put((Object)m, (Object)Integer.MAX_VALUE);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)Integer.MIN_VALUE, (Object)map.get((Object)m2));
        Assert.assertEquals((Object)Integer.MAX_VALUE, (Object)map.get((Object)m));
    }

    @Test
    public void test2() {
        MethodMap map = new MethodMap(0);
        Assert.assertEquals((long)0L, (long)map.capacity());
        Method m1 = new Method("x", "m1");
        map.put((Object)m1, (Object)0);
        Assert.assertEquals((long)3L, (long)map.capacity());
        Assert.assertEquals((long)1L, (long)map._size);
        map.put((Object)m1, (Object)1);
        Assert.assertEquals((long)3L, (long)map.capacity());
        Assert.assertEquals((long)1L, (long)map._size);
        Assert.assertEquals((long)2L, (long)map._maxSize);
        Method m2 = new Method("x", "m2");
        map.put((Object)m2, (Object)2);
        Assert.assertEquals((long)3L, (long)map.capacity());
        Assert.assertEquals((long)2L, (long)map._size);
        Assert.assertEquals((long)2L, (long)map._maxSize);
        Method m3 = new Method("x", "m3");
        map.put((Object)m3, (Object)3);
        Assert.assertEquals((long)7L, (long)map.capacity());
        Assert.assertEquals((long)3L, (long)map._size);
        Assert.assertEquals((long)4L, (long)map._maxSize);
        Assert.assertEquals((Object)1, (Object)map.get((Object)m1));
        Assert.assertEquals((Object)2, (Object)map.get((Object)m2));
        Assert.assertEquals((Object)3, (Object)map.get((Object)m3));
        Method ym3 = new Method("y", "m3");
        Assert.assertNull((Object)map.get((Object)ym3));
        map.put((Object)ym3, (Object)13);
        Assert.assertEquals((Object)13, (Object)map.get((Object)ym3));
        ArrayList values = new ArrayList();
        map.forEachEntry((k, v) -> {
            values.add(v);
            return true;
        });
        Assert.assertEquals((long)4L, (long)values.size());
    }
}

