/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Runtime;
import org.spf4j.log.Level;
import org.spf4j.stackmonitor.Sampler;
import org.spf4j.test.log.LogAssert;
import org.spf4j.test.log.TestLoggers;
import org.spf4j.test.matchers.LogMatchers;

public class SamplerTest {
    private static final Logger LOG = LoggerFactory.getLogger(SamplerTest.class);

    @Test
    public void testSampler() throws InterruptedException {
        Sampler sampler = Sampler.getSampler((int)5, (int)2000, (File)new File(Runtime.TMP_FOLDER), (String)"test");
        LogAssert expect = TestLoggers.sys().expect(Sampler.class.getName(), Level.INFO, 5000L, TimeUnit.MILLISECONDS, new Matcher[]{LogMatchers.hasMessageWithPattern((String)"Stack samples written to.*")});
        sampler.start();
        LOG.debug("started sampling");
        expect.assertObservation();
        sampler.stop();
    }

    @Test
    public void testSampler2() throws InterruptedException, IOException {
        Sampler sampler = Sampler.getSampler((int)5, (int)2000, (File)new File(Runtime.TMP_FOLDER), (String)"test");
        sampler.start();
        File dumpToFile = sampler.dumpToFile("id");
        LOG.debug("saved to file {}", (Object)dumpToFile);
        Assert.assertThat((Object)dumpToFile.getAbsolutePath(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)":")));
        sampler.stop();
    }

    @Test
    @SuppressFBWarnings(value={"MDM_THREAD_YIELD", "PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public void testSampler3() throws InterruptedException, IOException {
        Sampler sampler = Sampler.getSampler((int)1, (int)3600000, (File)new File(Runtime.TMP_FOLDER), (String)"test");
        sampler.dumpToFile();
        sampler.start();
        Thread.sleep(5L);
        sampler.dumpToFile();
        sampler.dumpToFile();
        Assert.assertEquals((long)3600000L, (long)sampler.getDumpTimeMillis());
        sampler.stop();
    }
}

