/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.spf4j.base.Runtime;
import org.spf4j.base.SysExits;
import org.spf4j.base.Throwables;
import org.spf4j.base.UncheckedExecutionException;

@SuppressFBWarnings(value={"ACEM_ABSTRACT_CLASS_EMPTY_METHODS"})
public abstract class AbstractRunnable
implements Runnable {
    @Deprecated
    public static final int ERROR_EXIT_CODE = SysExits.EX_SOFTWARE.exitCode();
    public static final Runnable NOP = () -> {};
    private final boolean lenient;
    private final String threadName;

    public AbstractRunnable(boolean lenient, @Nullable String threadName) {
        this.lenient = lenient;
        this.threadName = threadName;
    }

    public AbstractRunnable(boolean lenient) {
        this(lenient, null);
    }

    public AbstractRunnable() {
        this(false, null);
    }

    public AbstractRunnable(String threadName) {
        this(false, threadName);
    }

    @Override
    public final void run() {
        block12: {
            Thread thread = null;
            String origName = null;
            if (this.threadName != null) {
                thread = Thread.currentThread();
                origName = thread.getName();
                thread.setName(this.threadName);
            }
            try {
                this.doRun();
            }
            catch (Exception ex) {
                if (Throwables.containsNonRecoverable(ex)) {
                    Runtime.goDownWithError((Throwable)ex, SysExits.EX_SOFTWARE);
                }
                if (this.lenient) {
                    Logger.getLogger(AbstractRunnable.class.getName()).log(Level.SEVERE, "Exception in runnable: ", ex);
                    break block12;
                }
                throw new UncheckedExecutionException(ex);
            }
            catch (Throwable ex) {
                if (Throwables.containsNonRecoverable(ex)) {
                    Runtime.goDownWithError(ex, SysExits.EX_SOFTWARE);
                }
                throw ex;
            }
            finally {
                if (thread != null) {
                    thread.setName(origName);
                }
            }
        }
    }

    public abstract void doRun() throws Exception;
}

