/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.CharBuffer;
import javax.annotation.Nonnull;

public final class AppendableUtils {
    private static final ThreadLocal<char[]> BUFF = new ThreadLocal<char[]>(){

        @Override
        @SuppressFBWarnings(value={"SUA_SUSPICIOUS_UNINITIALIZED_ARRAY"})
        protected char[] initialValue() {
            return new char[64];
        }
    };
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    private AppendableUtils() {
    }

    public static void escapeJsonString(@Nonnull CharSequence toEscape, StringBuilder jsonString) {
        int len = toEscape.length();
        for (int i = 0; i < len; ++i) {
            char c = toEscape.charAt(i);
            AppendableUtils.appendJsonStringEscapedChar(c, jsonString);
        }
    }

    public static void escapeJsonString(@Nonnull CharSequence toEscape, Appendable jsonString) throws IOException {
        int len = toEscape.length();
        for (int i = 0; i < len; ++i) {
            char c = toEscape.charAt(i);
            AppendableUtils.appendJsonStringEscapedChar(c, jsonString);
        }
    }

    public static void appendJsonStringEscapedChar(char c, StringBuilder jsonString) {
        switch (c) {
            case '\"': 
            case '\\': {
                jsonString.append('\\');
                jsonString.append(c);
                break;
            }
            case '\b': {
                jsonString.append("\\b");
                break;
            }
            case '\t': {
                jsonString.append("\\t");
                break;
            }
            case '\n': {
                jsonString.append("\\n");
                break;
            }
            case '\f': {
                jsonString.append("\\f");
                break;
            }
            case '\r': {
                jsonString.append("\\r");
                break;
            }
            default: {
                if (c < ' ') {
                    jsonString.append("\\u");
                    AppendableUtils.appendUnsignedStringPadded(jsonString, (int)c, 4, 4);
                    break;
                }
                jsonString.append(c);
            }
        }
    }

    public static void appendJsonStringEscapedChar(char c, Appendable jsonString) throws IOException {
        switch (c) {
            case '\"': 
            case '\\': {
                jsonString.append('\\');
                jsonString.append(c);
                break;
            }
            case '\b': {
                jsonString.append("\\b");
                break;
            }
            case '\t': {
                jsonString.append("\\t");
                break;
            }
            case '\n': {
                jsonString.append("\\n");
                break;
            }
            case '\f': {
                jsonString.append("\\f");
                break;
            }
            case '\r': {
                jsonString.append("\\r");
                break;
            }
            default: {
                if (c < ' ') {
                    jsonString.append("\\u");
                    AppendableUtils.appendUnsignedStringPadded(jsonString, (int)c, 4, 4);
                    break;
                }
                jsonString.append(c);
            }
        }
    }

    public static void appendUnsignedStringPadded(StringBuilder sb, int nr, int shift, int padTo) {
        long i = nr;
        char[] buf = BUFF.get();
        int charPos = 32;
        int radix = 1 << shift;
        long mask = radix - 1;
        do {
            buf[--charPos] = DIGITS[(int)(i & mask)];
        } while ((i >>>= shift) != 0L);
        int nrChars = 32 - charPos;
        if (nrChars > padTo) {
            throw new IllegalArgumentException("Your pad to value " + padTo + " is to small, must be at least " + nrChars);
        }
        int n = padTo - nrChars;
        for (int j = 0; j < n; ++j) {
            sb.append('0');
        }
        sb.append(buf, charPos, nrChars);
    }

    public static void appendUnsignedStringPadded(Appendable sb, int nr, int shift, int padTo) throws IOException {
        long i = nr;
        char[] buf = BUFF.get();
        int charPos = 32;
        int radix = 1 << shift;
        long mask = radix - 1;
        do {
            buf[--charPos] = DIGITS[(int)(i & mask)];
        } while ((i >>>= shift) != 0L);
        int nrChars = 32 - charPos;
        if (nrChars > padTo) {
            throw new IllegalArgumentException("Your pad to value " + padTo + " is to small, must be at least " + nrChars);
        }
        int n = padTo - nrChars;
        for (int j = 0; j < n; ++j) {
            sb.append('0');
        }
        sb.append(CharBuffer.wrap(buf), charPos, charPos + nrChars);
    }

    public static void appendUnsignedString(StringBuilder sb, long nr, int shift) {
        long i = nr;
        char[] buf = BUFF.get();
        int charPos = 64;
        int radix = 1 << shift;
        long mask = radix - 1;
        do {
            buf[--charPos] = DIGITS[(int)(i & mask)];
        } while ((i >>>= shift) != 0L);
        sb.append(buf, charPos, 64 - charPos);
    }

    public static void appendUnsignedString(StringBuilder sb, int nr, int shift) {
        long i = nr;
        char[] buf = BUFF.get();
        int charPos = 32;
        int radix = 1 << shift;
        long mask = radix - 1;
        do {
            buf[--charPos] = DIGITS[(int)(i & mask)];
        } while ((i >>>= shift) != 0L);
        sb.append(buf, charPos, 32 - charPos);
    }

    public static void appendSpaces(Appendable to, int nrSpaces) throws IOException {
        for (int i = 0; i < nrSpaces; ++i) {
            to.append(' ');
        }
    }

    public static void appendSpaces(StringBuilder to, int nrSpaces) {
        for (int i = 0; i < nrSpaces; ++i) {
            to.append(' ');
        }
    }
}

