/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.base.AppendableUtils;
import org.spf4j.base.ContextValue;
import org.spf4j.base.ExecutionContext;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.base.Json;
import org.spf4j.base.StackSamples;
import org.spf4j.base.ThreadLocalContextAttacher;
import org.spf4j.base.Throwables;
import org.spf4j.base.Timing;
import org.spf4j.io.AppendableWriter;
import org.spf4j.log.Level;
import org.spf4j.log.LogUtils;
import org.spf4j.log.Slf4jLogRecord;

@ParametersAreNonnullByDefault
@ThreadSafe
public class BasicExecutionContext
implements ExecutionContext {
    private static final int MX_NR_LOGS_PER_CTXT = Integer.getInteger("spf4j.execContext.maxNrLogsPerContext", 100);
    private static final Level MIN_LOG_LEVEL = Level.valueOf(System.getProperty("spf4j.execContext.minLogLevel", "TRACE"));
    private final String name;
    private final CharSequence id;
    private final ExecutionContext source;
    private final ExecutionContext.Relation relation;
    private final long startTimeNanos;
    private final long deadlineNanos;
    private ArrayDeque<Slf4jLogRecord> logs;
    private List<AutoCloseable> closeables;
    private Map<ExecutionContext.Tag, Object> baggage;
    private long childCount;
    private boolean isClosed = false;
    private Level minBackendLogLevel;
    private ThreadLocalContextAttacher.Attached attached;

    @SuppressFBWarnings(value={"STT_TOSTRING_STORED_IN_FIELD"})
    public BasicExecutionContext(String name, @Nullable CharSequence id, @Nullable ExecutionContext source, ExecutionContext.Relation relation, long startTimeNanos, long deadlineNanos) {
        this.relation = relation;
        this.name = name;
        this.startTimeNanos = startTimeNanos;
        if (source != null) {
            long parentDeadline = source.getDeadlineNanos();
            this.deadlineNanos = parentDeadline < deadlineNanos ? parentDeadline : deadlineNanos;
            if (id == null) {
                CharSequence pId = source.getId();
                StringBuilder sb = new StringBuilder(pId.length() + 2).append(pId).append('/');
                AppendableUtils.appendUnsignedString(sb, source.nextChildId(), 5);
                this.id = sb;
            } else {
                this.id = id;
            }
            this.minBackendLogLevel = source.getBackendMinLogLevel();
        } else {
            this.deadlineNanos = deadlineNanos;
            this.id = id == null ? ExecutionContexts.genId() : id;
            this.minBackendLogLevel = null;
        }
        this.source = source;
        this.baggage = Collections.EMPTY_MAP;
        this.logs = null;
        this.closeables = Collections.EMPTY_LIST;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final long getDeadlineNanos() {
        return this.deadlineNanos;
    }

    @Override
    public final long getStartTimeNanos() {
        return this.startTimeNanos;
    }

    @Override
    @Nullable
    @Beta
    public final synchronized <T> T put(@Nonnull ExecutionContext.Tag<T, ?> key, @Nonnull T data) {
        if (this.baggage == Collections.EMPTY_MAP) {
            this.baggage = new HashMap<ExecutionContext.Tag, Object>(4);
        }
        return (T)this.baggage.put(key, data);
    }

    @Override
    @Nullable
    @Beta
    public final synchronized <T> T get(@Nonnull ExecutionContext.Tag<T, ?> key) {
        Object res = this.baggage.get(key);
        if (res == null && this.source != null && key.isInherited(this.relation)) {
            ExecutionContext.Relation rel;
            ExecutionContext src = this.source;
            do {
                res = src.getLocal(key);
                rel = src.getRelationToSource();
                src = src.getSource();
            } while (res == null && src != null && key.isInherited(rel));
        }
        return (T)res;
    }

    @Override
    public final synchronized <T> ContextValue<T> getContextAndValue(ExecutionContext.Tag<T, ?> key) {
        Object res = this.baggage.get(key);
        ExecutionContext ctx = this;
        if (res == null && this.source != null && key.isInherited(this.relation)) {
            ExecutionContext.Relation rel;
            ExecutionContext src = this.source;
            do {
                res = src.getLocal(key);
                rel = src.getRelationToSource();
                ctx = src;
                src = src.getSource();
            } while (res == null && src != null && key.isInherited(rel));
        }
        return res == null ? null : new ContextValue<Object>(ctx, res);
    }

    @Override
    @Nullable
    @Beta
    public final synchronized <T> T getLocal(@Nonnull ExecutionContext.Tag<T, ?> key) {
        return (T)this.baggage.get(key);
    }

    @Override
    @Nullable
    public final synchronized <V, A> V compute(@Nonnull ExecutionContext.Tag<V, A> key, BiFunction<ExecutionContext.Tag<V, A>, V, V> compute) {
        if (this.baggage == Collections.EMPTY_MAP) {
            this.baggage = new HashMap<ExecutionContext.Tag, Object>(4);
        }
        return (V)this.baggage.compute(key, compute);
    }

    @Override
    public final ExecutionContext getSource() {
        return this.source;
    }

    @Override
    public synchronized void close() {
        if (!this.isClosed) {
            if (this.attached != null) {
                this.detach();
            }
            Exception ex = null;
            for (int i = this.closeables.size() - 1; i >= 0; --i) {
                try {
                    this.closeables.get(i).close();
                    continue;
                }
                catch (Exception e) {
                    if (ex != null) {
                        Throwables.suppressLimited(e, ex);
                    }
                    ex = e;
                }
            }
            ExecutionContext parent = this.getNotClosedParent();
            if (parent != null) {
                if (this.logs != null) {
                    parent.addLogs(this.logs);
                }
                for (Map.Entry<ExecutionContext.Tag, Object> be : this.baggage.entrySet()) {
                    ExecutionContext.Tag key = be.getKey();
                    if (!key.pushOnClose()) continue;
                    parent.accumulate(key, be.getValue());
                }
            } else if (this.source != null) {
                if (this.relation == ExecutionContext.Relation.CHILD_OF) {
                    StackTraceElement[] stackTrace = null;
                    Logger orphaned = Logger.getLogger("ORPHAN_CTX_ENTITIES");
                    if (this.logs != null) {
                        for (Slf4jLogRecord slf4jLogRecord : this.logs) {
                            if (stackTrace == null) {
                                stackTrace = Thread.currentThread().getStackTrace();
                            }
                            LogUtils.logUpgrade(orphaned, Level.INFO, "Orphaned log", slf4jLogRecord.toLogRecord("", ""), stackTrace);
                        }
                    }
                    for (Map.Entry entry : this.baggage.entrySet()) {
                        ExecutionContext.Tag key = (ExecutionContext.Tag)entry.getKey();
                        if (!key.pushOnClose()) continue;
                        if (stackTrace == null) {
                            stackTrace = Thread.currentThread().getStackTrace();
                        }
                        LogUtils.logUpgrade(orphaned, Level.INFO, "Orphaned baggage", ((ExecutionContext.Tag)entry.getKey()).toString(), entry.getValue(), stackTrace);
                    }
                }
            }
            this.isClosed = true;
            if (ex != null) {
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public final synchronized void detach() {
        this.attached.detach();
        this.attached = null;
    }

    @Override
    public final synchronized boolean isAttached() {
        return this.attached != null;
    }

    @Override
    public final synchronized void attach() {
        if (this.attached != null) {
            throw new IllegalStateException("Context already attached, can only be attached to one thread at a time: " + this.attached);
        }
        this.attached = ExecutionContexts.threadLocalAttacher().attach(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        this.writeTo(sb);
        return sb.toString();
    }

    @Override
    public synchronized void writeJsonTo(Appendable appendable) throws IOException {
        JsonGenerator gen = Json.FACTORY.createGenerator((Writer)new AppendableWriter(appendable));
        gen.setCodec((ObjectCodec)Json.MAPPER);
        gen.writeStartObject();
        gen.writeFieldName("name");
        gen.writeString(this.name);
        gen.writeFieldName("startTs");
        Timing currentTiming = Timing.getCurrentTiming();
        gen.writeString(currentTiming.fromNanoTimeToInstant(this.startTimeNanos).toString());
        gen.writeFieldName("deadlineTs");
        gen.writeString(currentTiming.fromNanoTimeToInstant(this.deadlineNanos).toString());
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public final synchronized void addLog(Slf4jLogRecord log) {
        if (this.isClosed) {
            if (this.source == null) {
                return;
            }
            this.source.addLog(log);
            return;
        }
        if (this.logs == null) {
            this.logs = new ArrayDeque(4);
        }
        if (this.logs.size() >= MX_NR_LOGS_PER_CTXT) {
            this.logs.removeFirst();
        }
        this.logs.addLast(log);
    }

    @Override
    @Beta
    public final synchronized void addCloseable(AutoCloseable closeable) {
        if (this.closeables.isEmpty()) {
            this.closeables = new ArrayList<AutoCloseable>(4);
        }
        this.closeables.add(closeable);
    }

    @Override
    public final synchronized void addLogs(Collection<Slf4jLogRecord> pLogs) {
        if (this.isClosed) {
            if (this.source == null) {
                return;
            }
            this.source.addLogs(pLogs);
            return;
        }
        if (this.logs == null) {
            this.logs = new ArrayDeque<Slf4jLogRecord>(pLogs);
            return;
        }
        int xNrLogs = this.logs.size();
        int toRemove = xNrLogs + pLogs.size() - MX_NR_LOGS_PER_CTXT;
        if (toRemove >= xNrLogs) {
            this.logs.clear();
        } else {
            for (int i = 0; i < toRemove; ++i) {
                this.logs.removeFirst();
            }
        }
        this.logs.addAll(pLogs);
    }

    @Override
    public final synchronized void streamLogs(Consumer<Slf4jLogRecord> to) {
        if (this.logs != null) {
            for (Slf4jLogRecord log : this.logs) {
                to.accept(log);
            }
        }
    }

    @Override
    public Level getContextMinLogLevel(String loggerName) {
        return MIN_LOG_LEVEL;
    }

    @Override
    public synchronized Level getBackendMinLogLevel(String loggerName) {
        return this.minBackendLogLevel;
    }

    @Override
    public synchronized Level setBackendMinLogLevel(String loggerName, Level level) {
        Level result = this.minBackendLogLevel;
        this.minBackendLogLevel = level;
        return result;
    }

    @Override
    public final CharSequence getId() {
        return this.id;
    }

    @Override
    public final synchronized long nextChildId() {
        return this.childCount++;
    }

    @Override
    public void add(StackTraceElement[] sample) {
    }

    @Override
    @Nullable
    public StackSamples getAndClearStackSamples() {
        return null;
    }

    @Override
    @Nullable
    public StackSamples getStackSamples() {
        return null;
    }

    @Override
    public final synchronized boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public final ExecutionContext.Relation getRelationToSource() {
        return this.relation;
    }

    @Override
    public void add(StackSamples samples) {
    }
}

