/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.IntMath;
import org.spf4j.base.MemorizedCallable;
import org.spf4j.base.Throwables;
import org.spf4j.base.UncheckedExecutionException;

@ParametersAreNonnullByDefault
public final class Callables {
    @Deprecated
    public static final SimpleRetryPredicate<?> RETRY_FOR_NULL_RESULT = new SimpleRetryPredicate<Object>(){

        @Override
        public SimpleAction apply(Object input) {
            return input != null ? SimpleAction.ABORT : SimpleAction.RETRY;
        }
    };
    @Deprecated
    public static final AdvancedRetryPredicate<Exception> DEFAULT_EXCEPTION_RETRY = new DefaultAdvancedRetryPredicateImpl();
    @Deprecated
    public static final Predicate<Exception> DEFAULT_EXCEPTION_RETRY_PREDICATE = new Predicate<Exception>(){

        @Override
        @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
        public boolean test(Exception t) {
            return DEFAULT_EXCEPTION_RETRY.apply(t) != AdvancedAction.ABORT;
        }
    };

    private Callables() {
    }

    @Deprecated
    @Nullable
    public static <T, EX extends Exception> T executeWithRetry(TimeoutCallable<T, EX> what, int nrImmediateRetries, int maxRetryWaitMillis, Class<EX> exceptionClass) throws InterruptedException, EX, TimeoutException {
        return Callables.executeWithRetry(what, nrImmediateRetries, maxRetryWaitMillis, TimeoutRetryPredicate.NORETRY_FOR_RESULT, DEFAULT_EXCEPTION_RETRY, exceptionClass);
    }

    @Deprecated
    @Nullable
    public static <T> T executeWithRetry(TimeoutCallable<T, RuntimeException> what, int nrImmediateRetries, int maxRetryWaitMillis) throws InterruptedException, TimeoutException {
        return Callables.executeWithRetry(what, nrImmediateRetries, maxRetryWaitMillis, TimeoutRetryPredicate.NORETRY_FOR_RESULT, DEFAULT_EXCEPTION_RETRY, RuntimeException.class);
    }

    @Deprecated
    @Nullable
    public static <T, EX extends Exception> T executeWithRetry(TimeoutCallable<T, EX> what, int nrImmediateRetries, int maxRetryWaitMillis, AdvancedRetryPredicate<Exception> retryOnException, Class<EX> exceptionClass) throws InterruptedException, EX, TimeoutException {
        return Callables.executeWithRetry(what, nrImmediateRetries, maxRetryWaitMillis, TimeoutRetryPredicate.NORETRY_FOR_RESULT, retryOnException, exceptionClass);
    }

    @Deprecated
    @Nullable
    public static <T> T executeWithRetry(TimeoutCallable<T, RuntimeException> what, int nrImmediateRetries, int maxRetryWaitMillis, AdvancedRetryPredicate<Exception> retryOnException) throws InterruptedException, TimeoutException {
        return Callables.executeWithRetry(what, nrImmediateRetries, maxRetryWaitMillis, TimeoutRetryPredicate.NORETRY_FOR_RESULT, retryOnException, RuntimeException.class);
    }

    @Deprecated
    @Nullable
    public static <T, EX extends Exception> T executeWithRetry(TimeoutCallable<T, EX> what, int nrImmediateRetries, int maxWaitMillis, TimeoutRetryPredicate<? super T, T> retryOnReturnVal, AdvancedRetryPredicate<Exception> retryOnException, Class<EX> exceptionClass) throws InterruptedException, EX, TimeoutException {
        long deadline = what.getDeadline();
        return Callables.executeWithRetry(what, new TimeoutRetryPredicate2RetryPredicate<T, T>(deadline, retryOnReturnVal), new FibonacciBackoffRetryPredicate(retryOnException, nrImmediateRetries, maxWaitMillis / 100, maxWaitMillis, Callables::rootClass, deadline, () -> System.currentTimeMillis(), TimeUnit.MILLISECONDS), exceptionClass);
    }

    @Deprecated
    public static Class rootClass(Exception f) {
        return com.google.common.base.Throwables.getRootCause((Throwable)f).getClass();
    }

    @Deprecated
    @Nullable
    public static <T, EX extends Exception> T executeWithRetry(TimeoutCallable<T, EX> what, TimeoutRetryPredicate<? super T, T> retryOnReturnVal, TimeoutRetryPredicate<Exception, T> retryOnException, Class<EX> exceptionClass) throws InterruptedException, EX, TimeoutException {
        long deadline = what.getDeadline();
        return Callables.executeWithRetry(what, new TimeoutRetryPredicate2RetryPredicate<T, T>(deadline, retryOnReturnVal), new TimeoutRetryPredicate2RetryPredicate<Exception, T>(deadline, retryOnException), exceptionClass);
    }

    @Deprecated
    @Nullable
    public static <T, EX extends Exception> T executeWithRetry(TimeoutCallable<T, EX> what, TimeoutRetryPredicate<Exception, T> retryOnException, Class<EX> exceptionClass) throws InterruptedException, EX, TimeoutException {
        return Callables.executeWithRetry(what, TimeoutRetryPredicate.NORETRY_FOR_RESULT, retryOnException, exceptionClass);
    }

    @Deprecated
    @Nullable
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE", "MDM_THREAD_YIELD"})
    public static <T, EX extends Exception> T executeWithRetry(CheckedCallable<T, EX> pwhat, RetryPredicate<? super T, T> retryOnReturnVal, RetryPredicate<Exception, T> retryOnException, Class<EX> exceptionClass) throws InterruptedException, TimeoutException, EX {
        Exception ex;
        Callable what = pwhat;
        Object result = null;
        Exception lastEx = null;
        try {
            result = what.call();
        }
        catch (InterruptedException ex1) {
            throw ex1;
        }
        catch (Exception e) {
            lastEx = e;
        }
        Exception lastExChain = lastEx;
        RetryDecision<T> decision = null;
        while (lastEx != null && (decision = retryOnException.getDecision(lastEx, what)).getDecisionType() == RetryDecision.Type.Retry || lastEx == null && (decision = retryOnReturnVal.getDecision(result, what)).getDecisionType() == RetryDecision.Type.Retry) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            long delayMillis = decision.getDelayMillis();
            if (delayMillis > 0L) {
                Thread.sleep(delayMillis);
            }
            what = decision.getNewCallable();
            result = null;
            lastEx = null;
            try {
                result = what.call();
            }
            catch (InterruptedException ex1) {
                throw ex1;
            }
            catch (Exception e) {
                lastEx = e;
                if (lastExChain != null) {
                    Throwables.suppressLimited(lastEx, lastExChain);
                }
                lastExChain = lastEx;
            }
        }
        if (decision == null) {
            throw new IllegalStateException("Decission should have ben initialized " + lastEx + ", " + result);
        }
        if (decision.getDecisionType() == RetryDecision.Type.Abort && (ex = decision.getException()) != null) {
            lastEx = ex;
            if (lastExChain != null) {
                Throwables.suppressLimited(lastEx, lastExChain);
            }
            lastExChain = lastEx;
        }
        if (lastEx != null) {
            if (lastExChain instanceof RuntimeException) {
                throw (RuntimeException)lastExChain;
            }
            if (lastExChain instanceof TimeoutException) {
                throw (TimeoutException)lastExChain;
            }
            if (lastExChain == null) {
                return null;
            }
            if (exceptionClass.isAssignableFrom(lastExChain.getClass())) {
                throw lastExChain;
            }
            throw new UncheckedExecutionException(lastExChain);
        }
        return result;
    }

    public static <T> Callable<T> synchronize(final Callable<T> callable) {
        return new Callable<T>(){

            @Override
            public synchronized T call() throws Exception {
                return callable.call();
            }
        };
    }

    public static <T> Callable<T> withName(final Callable<T> callable, final String name) {
        return new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws Exception {
                Thread currentThread = Thread.currentThread();
                String origName = currentThread.getName();
                try {
                    currentThread.setName(origName + '[' + name + ']');
                    Object v = callable.call();
                    return v;
                }
                finally {
                    currentThread.setName(origName);
                }
            }

            public String toString() {
                return name;
            }
        };
    }

    static long overflowSafeAdd(long currentTime, long timeout) {
        if (currentTime < 0L) {
            throw new IllegalArgumentException("Time must be positive, not " + currentTime);
        }
        if (timeout < 0L) {
            return currentTime;
        }
        long result = currentTime + timeout;
        if ((currentTime ^ timeout) < 0L || (currentTime ^ result) >= 0L) {
            return result;
        }
        return Long.MAX_VALUE;
    }

    public static <V> MemorizedCallable<V> memorized(Callable<V> source) {
        return new MemorizedCallable<V>(source);
    }

    public static <V> Callable<V> constant(V value) {
        return new ConstCallable<V>(value);
    }

    public static Callable<Void> from(Runnable value) {
        return () -> {
            value.run();
            return null;
        };
    }

    @Deprecated
    private static final class DefaultAdvancedRetryPredicateImpl
    implements AdvancedRetryPredicate<Exception> {
        private DefaultAdvancedRetryPredicateImpl() {
        }

        @Override
        public AdvancedAction apply(@Nonnull Exception input) {
            if (Throwables.isRetryable(input)) {
                Logger.getLogger(DefaultAdvancedRetryPredicateImpl.class.getName()).log(Level.FINE, "Exception encountered, retrying...", input);
                return AdvancedAction.RETRY;
            }
            return AdvancedAction.ABORT;
        }
    }

    private static final class ConstCallable<V>
    implements Callable<V> {
        private final V value;

        ConstCallable(V value) {
            this.value = value;
        }

        @Override
        public V call() {
            return this.value;
        }

        public String toString() {
            return "ConstCallable{" + this.value + '}';
        }
    }

    @Deprecated
    public static interface SimpleRetryPredicate<T> {
        public SimpleAction apply(T var1) throws TimeoutException, InterruptedException;
    }

    @Deprecated
    public static enum SimpleAction {
        RETRY,
        ABORT;

    }

    public static interface CheckedCallable<T, EX extends Exception>
    extends Callable<T> {
        @Override
        public T call() throws EX, InterruptedException, TimeoutException;
    }

    @Deprecated
    static final class TimeoutRetryPredicate2RetryPredicate<T, R>
    implements RetryPredicate<T, R> {
        private final long deadline;
        private final TimeoutRetryPredicate<T, R> predicate;

        TimeoutRetryPredicate2RetryPredicate(long deadline, TimeoutRetryPredicate<T, R> predicate) {
            this.deadline = deadline;
            this.predicate = predicate;
        }

        @Override
        public RetryDecision<R> getDecision(T value, Callable<R> callable) {
            return this.predicate.getDecision(value, this.deadline, callable);
        }
    }

    @Deprecated
    public static interface TimeoutRetryPredicate<T, R> {
        public static final TimeoutRetryPredicate NORETRY_FOR_RESULT = new TimeoutRetryPredicate<Object, Object>(){

            @Override
            public RetryDecision<Object> getDecision(Object value, long deadline, Callable<Object> what) {
                return RetryDecision.abort();
            }
        };

        public RetryDecision<R> getDecision(T var1, long var2, Callable<R> var4);
    }

    @Deprecated
    public static interface RetryPredicate<T, R> {
        public static final RetryPredicate<Object, Object> NORETRY_DELAY_PREDICATE = new RetryPredicate<Object, Object>(){

            @Override
            public RetryDecision getDecision(Object value, Callable callable) {
                return RetryDecision.abort();
            }
        };

        @Nonnull
        public RetryDecision<R> getDecision(T var1, @Nonnull Callable<R> var2);
    }

    @Deprecated
    public static final class RetryDecision<R> {
        private static final RetryDecision ABORT = new RetryDecision(Type.Abort, -1L, null, null);
        private final Type decisionType;
        private final long delayMillis;
        private final Exception exception;
        private final Callable<R> newCallable;

        private RetryDecision(Type decisionType, long delayMillis, Exception exception, Callable<R> newCallable) {
            this.decisionType = decisionType;
            this.delayMillis = delayMillis;
            this.exception = exception;
            this.newCallable = newCallable;
        }

        public static RetryDecision abort(Exception exception) {
            return new RetryDecision(Type.Abort, -1L, exception, null);
        }

        public static <R> RetryDecision<R> retry(long retryMillis, @Nonnull Callable<R> callable) {
            return new RetryDecision<R>(Type.Retry, retryMillis, null, callable);
        }

        public static RetryDecision abort() {
            return ABORT;
        }

        public Type getDecisionType() {
            return this.decisionType;
        }

        public long getDelayMillis() {
            return this.delayMillis;
        }

        public Exception getException() {
            return this.exception;
        }

        @Nonnull
        public Callable<R> getNewCallable() {
            return this.newCallable;
        }

        public static enum Type {
            Abort,
            Retry;

        }
    }

    @Deprecated
    public static interface AdvancedRetryPredicate<T> {
        public static final AdvancedRetryPredicate<?> NO_RETRY = new AdvancedRetryPredicate<Object>(){

            @Override
            public AdvancedAction apply(Object value) {
                return AdvancedAction.ABORT;
            }
        };

        default public AdvancedAction apply(T value, long deadline) {
            return this.apply(value);
        }

        public AdvancedAction apply(T var1);
    }

    @Deprecated
    public static enum AdvancedAction {
        RETRY,
        RETRY_IMMEDIATE,
        RETRY_DELAYED,
        ABORT;

    }

    @Deprecated
    public static abstract class TimeoutCallable<T, EX extends Exception>
    implements CheckedCallable<T, EX> {
        private final long mdeadline;

        public TimeoutCallable(int timeoutMillis) {
            this.mdeadline = Callables.overflowSafeAdd(System.currentTimeMillis(), timeoutMillis);
        }

        public TimeoutCallable(long deadline) {
            this.mdeadline = deadline;
        }

        @Override
        public final T call() throws EX, InterruptedException, TimeoutException {
            return this.call(this.mdeadline);
        }

        public abstract T call(long var1) throws EX, InterruptedException, TimeoutException;

        public final long getDeadline() {
            return this.mdeadline;
        }
    }

    @Deprecated
    public static final class FibonacciBackoffRetryPredicate<T, R>
    implements RetryPredicate<T, R> {
        private final IntMath.XorShift32 random;
        private final AdvancedRetryPredicate<T> arp;
        private final int nrImmediateRetries;
        private final long maxWaitUnits;
        private final long minWaitUnits;
        private Map<Object, RetryData> retryRegistry;
        private final Function<T, ?> mapper;
        private final long deadline;
        private final LongSupplier currTimeSuplier;
        private final TimeUnit tu;

        public FibonacciBackoffRetryPredicate(AdvancedRetryPredicate<T> arp, int nrImmediateRetries, long minWaitUnits, long maxWaitUnits, Function<T, ?> mapper, long deadline, LongSupplier currTimeSuplier, TimeUnit tu) {
            this.arp = arp;
            this.nrImmediateRetries = nrImmediateRetries;
            this.maxWaitUnits = maxWaitUnits;
            this.minWaitUnits = minWaitUnits;
            this.retryRegistry = null;
            this.mapper = mapper;
            this.random = new IntMath.XorShift32();
            this.deadline = deadline;
            this.currTimeSuplier = currTimeSuplier;
            this.tu = tu;
        }

        private RetryData getRetryData(T value, AdvancedAction action) {
            Object rootCauseClass = this.mapper.apply(value);
            RetryData data = this.retryRegistry.get(rootCauseClass);
            if (data == null) {
                data = this.createRetryData(action);
                this.retryRegistry.put(rootCauseClass, data);
            }
            return data;
        }

        private RetryData createRetryData(AdvancedAction action) {
            if (action == AdvancedAction.RETRY_DELAYED) {
                return new RetryData(0, this.minWaitUnits, this.maxWaitUnits);
            }
            return new RetryData(this.nrImmediateRetries, this.minWaitUnits, this.maxWaitUnits);
        }

        @Override
        public RetryDecision<R> getDecision(T value, Callable<R> callable) {
            long currentTime = this.currTimeSuplier.getAsLong();
            if (currentTime > this.deadline) {
                return RetryDecision.abort(new TimeoutException("Deadline " + Instant.ofEpochMilli(this.deadline) + " passed, current time is " + Instant.ofEpochMilli(currentTime)));
            }
            if (this.retryRegistry == null) {
                this.retryRegistry = new HashMap<Object, RetryData>();
            }
            AdvancedAction action = this.arp.apply(value, this.deadline);
            switch (action) {
                case ABORT: {
                    return RetryDecision.abort();
                }
                case RETRY_IMMEDIATE: {
                    return RetryDecision.retry(0L, callable);
                }
                case RETRY_DELAYED: 
                case RETRY: {
                    RetryData retryData = this.getRetryData(value, action);
                    long nextDelay = retryData.nextDelay();
                    long delay = Math.min(nextDelay, this.deadline - currentTime);
                    if (delay > 0L) {
                        delay = (long)Math.abs(this.random.nextInt()) % delay;
                    }
                    if (currentTime + delay > this.deadline) {
                        return RetryDecision.abort(new TimeoutException("No time left for retry " + Instant.ofEpochMilli(this.deadline) + ' ' + (Object)((Object)this.tu) + " passed, current time is " + Instant.ofEpochMilli(currentTime) + ' ' + (Object)((Object)this.tu)));
                    }
                    return RetryDecision.retry(this.tu.toMillis(delay), callable);
                }
            }
            throw new UnsupportedOperationException("Unsupperted Retry Action " + (Object)((Object)action));
        }
    }

    @Deprecated
    private static final class RetryData {
        private int immediateLeft;
        private long p1;
        private long p2;
        private final long maxDelay;

        RetryData(int immediateLeft, long p1, long maxDelay) {
            this.immediateLeft = immediateLeft;
            if (p1 < 1L) {
                this.p1 = 0L;
                this.p2 = 1L;
            } else {
                this.p1 = p1;
                this.p2 = p1;
            }
            this.maxDelay = maxDelay;
        }

        private long nextDelay() {
            if (this.immediateLeft > 0) {
                --this.immediateLeft;
                return 0L;
            }
            if (this.p2 > this.maxDelay) {
                return this.maxDelay;
            }
            long result = this.p2;
            this.p2 = this.p1 + this.p2;
            this.p1 = result;
            return result;
        }
    }
}

