/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.io.CharSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.function.IntPredicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.Arrays;
import org.spf4j.base.IntAppender;

@ParametersAreNonnullByDefault
@GwtCompatible
public final class CharSequences {
    private CharSequences() {
    }

    @SuppressFBWarnings(value={"CLI_CONSTANT_LIST_INDEX"})
    public static int distance(CharSequence s1, CharSequence s2) {
        int l1 = s1.length();
        int l2 = s2.length();
        if (l1 == 0) {
            return l2;
        }
        if (l2 == 0) {
            return l1;
        }
        int[] prev = new int[l2];
        char c1 = s1.charAt(0);
        char cs20 = s2.charAt(0);
        prev[0] = CharSequences.distance(c1, cs20);
        for (int j = 1; j < l2; ++j) {
            int pd = prev[j - 1];
            prev[j] = pd == j ? pd + CharSequences.distance(c1, s2.charAt(j)) : pd + 1;
        }
        int[] dist = new int[l2];
        for (int i = 1; i < l1; ++i) {
            c1 = s1.charAt(i);
            int pd = prev[0];
            dist[0] = pd == i ? pd + CharSequences.distance(c1, cs20) : pd + 1;
            for (int j = 1; j < l2; ++j) {
                dist[j] = Math.min(prev[j - 1] + CharSequences.distance(c1, s2.charAt(j)), Math.min(prev[j] + 1, dist[j - 1] + 1));
            }
            int[] tmp = prev;
            prev = dist;
            dist = tmp;
        }
        return prev[l2 - 1];
    }

    public static int distance(char c1, char c2) {
        return c1 == c2 ? 0 : 1;
    }

    @Deprecated
    public static int compareTo(CharSequence s, CharSequence t) {
        return CharSequences.compare(s, t);
    }

    public static int compare(CharSequence s, CharSequence t) {
        return CharSequences.compare(s, 0, s.length(), t, 0, t.length());
    }

    public static int compare(CharSequence s, int sLength, CharSequence t, int tLength) {
        return CharSequences.compare(s, 0, sLength, t, 0, tLength);
    }

    public static int compare(CharSequence s, int sFrom, int sLength, CharSequence t, int tFrom, int tLength) {
        int lim = Math.min(sLength, tLength);
        int i = sFrom;
        int j = tFrom;
        int sTo = sFrom + lim;
        while (i < sTo) {
            char c2;
            char c1 = s.charAt(i);
            if (c1 != (c2 = t.charAt(j))) {
                return c1 - c2;
            }
            ++i;
            ++j;
        }
        return sLength - tLength;
    }

    public static boolean equalsNullables(CharSequence s, CharSequence t) {
        if (s == null) {
            return null == t;
        }
        if (t == null) {
            return true;
        }
        return CharSequences.equals(s, t);
    }

    public static boolean equals(CharSequence s, CharSequence t) {
        int tl;
        int sl = s.length();
        if (sl != (tl = t.length())) {
            return false;
        }
        for (int i = 0; i < sl; ++i) {
            if (s.charAt(i) == t.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static int hashcode(CharSequence cs) {
        if (cs instanceof String) {
            return ((String)cs).hashCode();
        }
        int h = 0;
        int len = cs.length();
        if (len > 0) {
            int off = 0;
            for (int i = 0; i < len; ++i) {
                h = 31 * h + cs.charAt(off++);
            }
        }
        return h;
    }

    public static CharSequence subSequence(CharSequence seq, int startIdx, int endIdx) {
        if (startIdx == 0 && endIdx == seq.length()) {
            return seq;
        }
        if (startIdx >= endIdx) {
            return "";
        }
        return new SubSequence(seq, endIdx - startIdx, startIdx);
    }

    public static boolean endsWith(CharSequence qc, CharSequence with) {
        int l = qc.length();
        int start = l - with.length();
        if (start >= 0) {
            int i = start;
            int j = 0;
            while (i < l) {
                if (qc.charAt(i) != with.charAt(j)) {
                    return false;
                }
                ++i;
                ++j;
            }
            return true;
        }
        return false;
    }

    public static Appendable lineNumbered(int startLineNr, Appendable appendable) throws IOException {
        return CharSequences.lineNumbered(startLineNr, appendable, IntAppender.CommentNumberAppender.INSTANCE);
    }

    public static Appendable lineNumbered(final int startLineNr, final Appendable appendable, final IntAppender ia) throws IOException {
        ia.append(startLineNr, appendable);
        return new Appendable(){
            private int lineNr;
            {
                this.lineNr = startLineNr + 1;
            }

            @Override
            public Appendable append(CharSequence csq) throws IOException {
                return this.append(csq, 0, csq.length());
            }

            @Override
            public Appendable append(CharSequence csq, int start, int end) throws IOException {
                int lastIdx = start;
                for (int i = start; i < end; ++i) {
                    if (csq.charAt(i) != '\n') continue;
                    int next = i + 1;
                    appendable.append(csq, lastIdx, next);
                    ia.append(this.lineNr++, appendable);
                    lastIdx = next;
                }
                if (lastIdx < end) {
                    appendable.append(csq, lastIdx, end);
                }
                return this;
            }

            @Override
            public Appendable append(char c) throws IOException {
                appendable.append(c);
                if (c == '\n') {
                    ia.append(this.lineNr++, appendable);
                }
                return this;
            }
        };
    }

    public static CharSequence toLineNumbered(int startLineNr, CharSequence source) {
        return CharSequences.toLineNumbered(startLineNr, source, IntAppender.CommentNumberAppender.INSTANCE);
    }

    public static CharSequence toLineNumbered(int startLineNr, CharSequence source, IntAppender ia) {
        int length = source.length();
        StringBuilder destination = new StringBuilder(length + 6 * length / 80);
        try {
            CharSequences.lineNumbered(startLineNr, destination, ia).append(source);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return destination;
    }

    public static int parseInt(@Nonnull CharSequence s) {
        return CharSequences.parseInt(s, 10);
    }

    public static int parseInt(@Nonnull CharSequence cs, int radix) {
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        int result = 0;
        boolean negative = false;
        int len = cs.length();
        if (len > 0) {
            int i = 0;
            int limit = -2147483647;
            char firstChar = cs.charAt(0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Integer.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
                }
                if (len == 1) {
                    throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
                }
                ++i;
            }
            int multmin = limit / radix;
            while (i < len) {
                int digit;
                if ((digit = Character.digit(cs.charAt(i++), radix)) < 0) {
                    throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
                }
                if (result < multmin) {
                    throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
                }
                if ((result *= radix) < limit + digit) {
                    throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
        }
        return negative ? result : -result;
    }

    public static int parseUnsignedInt(@Nonnull CharSequence cs, int radix, int idxFrom) {
        return CharSequences.parseUnsignedInt(cs, radix, idxFrom, cs.length());
    }

    public static int parseUnsignedInt(@Nonnull CharSequence cs, int radix, int idxFrom, int idxTo) {
        int digit;
        int i;
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        int result = 0;
        int limit = -2147483647;
        int multmin = limit / radix;
        for (i = idxFrom; i < idxTo && (digit = Character.digit(cs.charAt(i), radix)) >= 0; ++i) {
            if (result < multmin) {
                throw new NumberFormatException("For input char sequence: \"" + cs + "\" at " + i);
            }
            if ((result *= radix) < limit + digit) {
                throw new NumberFormatException("For input char sequence: \"" + cs + "\" at " + i);
            }
            result -= digit;
        }
        if (i == idxFrom) {
            throw new NumberFormatException("No number in \"" + cs + "\" at " + idxFrom);
        }
        return -result;
    }

    public static long parseUnsignedLong(@Nonnull CharSequence cs, int radix, int idxFrom) {
        return CharSequences.parseUnsignedLong(cs, radix, idxFrom, cs.length(), false);
    }

    public static long parseUnsignedLong(@Nonnull CharSequence cs, int radix, int idxFrom, int idxTo, boolean strict) {
        int digit;
        int i;
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        long result = 0L;
        long limit = -9223372036854775807L;
        long multmin = limit / (long)radix;
        for (i = idxFrom; i < idxTo && (digit = Character.digit(cs.charAt(i), radix)) >= 0; ++i) {
            if (result < multmin) {
                throw new NumberFormatException("For input char sequence: \"" + cs + "\" at " + i);
            }
            if ((result *= (long)radix) < limit + (long)digit) {
                throw new NumberFormatException("For input char sequence: \"" + cs + "\" at " + i);
            }
            result -= (long)digit;
        }
        if (i == idxFrom) {
            throw new NumberFormatException("No number in " + cs + " at " + idxFrom);
        }
        if (strict && i < idxTo) {
            throw new NumberFormatException("No valid number in " + cs + " at " + idxFrom + " to " + idxTo);
        }
        return -result;
    }

    public static long parseLong(@Nonnull CharSequence cs) {
        return CharSequences.parseLong(cs, 10);
    }

    public static long parseLong(@Nonnull CharSequence cs, int radix) {
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        long result = 0L;
        boolean negative = false;
        int len = cs.length();
        if (len > 0) {
            int i = 0;
            long limit = -9223372036854775807L;
            char firstChar = cs.charAt(0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
                }
                if (len == 1) {
                    throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
                }
                ++i;
            }
            long multmin = limit / (long)radix;
            while (i < len) {
                int digit;
                if ((digit = Character.digit(cs.charAt(i++), radix)) < 0) {
                    throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
                }
                if (result < multmin) {
                    throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
                }
                result -= (long)digit;
            }
        } else {
            throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
        }
        return negative ? result : -result;
    }

    public static boolean containsAnyChar(CharSequence string, char ... chars) {
        return CharSequences.containsAnyChar(string, 0, string.length(), chars);
    }

    public static boolean containsAnyChar(CharSequence string, int start, int end, char ... chars) {
        for (int i = start; i < end; ++i) {
            char c = string.charAt(i);
            if (Arrays.search(chars, c) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidFileName(@Nonnull CharSequence fileName) {
        return !CharSequences.containsAnyChar(fileName, '/', '\\');
    }

    public static <T extends CharSequence> T validatedFileName(@Nonnull T fileName) {
        if (!CharSequences.isValidFileName(fileName)) {
            throw new IllegalArgumentException("Invalid file name: " + fileName);
        }
        return fileName;
    }

    public static boolean regionMatches(CharSequence t, int toffset, CharSequence other, int ooffset, int plen) {
        int to = toffset;
        int po = ooffset;
        if (ooffset < 0 || toffset < 0 || (long)toffset > (long)t.length() - (long)plen || (long)ooffset > (long)other.length() - (long)plen) {
            return false;
        }
        int len = plen;
        while (len-- > 0) {
            if (t.charAt(to++) == other.charAt(po++)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatchesIgnoreCase(CharSequence ta, int toffset, CharSequence pa, int ooffset, int plen) {
        int to = toffset;
        int po = ooffset;
        if (ooffset < 0 || toffset < 0 || (long)toffset > (long)ta.length() - (long)plen || (long)ooffset > (long)pa.length() - (long)plen) {
            return false;
        }
        int len = plen;
        while (len-- > 0) {
            char u2;
            char u1;
            char c2;
            char c1;
            if ((c1 = ta.charAt(to++)) == (c2 = pa.charAt(po++)) || (u1 = Character.toUpperCase(c1)) == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2)) continue;
            return false;
        }
        return true;
    }

    public static boolean match(CharSequence wildcard, CharSequence cs2Match) {
        int i = 0;
        int j = 0;
        int length = wildcard.length();
        while (i < length) {
            char some2 = wildcard.charAt(i);
            if (some2 != cs2Match.charAt(j)) {
                if (some2 == '*') {
                    if (++i == length) {
                        return true;
                    }
                    char some = wildcard.charAt(i);
                    while (some != cs2Match.charAt(j)) {
                        ++j;
                    }
                    --j;
                } else if (some2 != '?') {
                    return false;
                }
            }
            ++i;
            ++j;
        }
        return j == cs2Match.length();
    }

    public CharSequence getJavaRegexpStr(CharSequence wildcard) {
        int length = wildcard.length();
        StringBuilder buff = new StringBuilder(length + 4);
        block5: for (int i = 0; i < length; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    buff.append(".*");
                    continue block5;
                }
                case '?': {
                    buff.append('.');
                    continue block5;
                }
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    buff.append('\\').append(c);
                    continue block5;
                }
                default: {
                    buff.append(c);
                }
            }
        }
        return buff;
    }

    public static int indexOf(CharSequence cs, int from, int to, char c) {
        for (int i = from; i < to; ++i) {
            if (c != cs.charAt(i)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(CharSequence cs, int from, int to, IntPredicate cp) {
        for (int i = from; i < to; ++i) {
            if (!cp.test(cs.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(CharSequence cs, int from, int to, char ... chars) {
        for (int i = from; i < to; ++i) {
            char charAt = cs.charAt(i);
            for (char c : chars) {
                if (c != charAt) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence searchStr) {
        return CharSequences.lastIndexOfIgnoreCase(str, searchStr) >= 0;
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        int length = searchStr.length();
        if (length == 0) {
            return 0;
        }
        for (int i = str.length() - length; i >= 0; --i) {
            if (!CharSequences.regionMatchesIgnoreCase(str, i, searchStr, 0, length)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int idxStart) {
        int sLen = searchStr.length();
        if (sLen == 0) {
            return 0;
        }
        int l = str.length() - sLen;
        for (int i = idxStart; i <= l; ++i) {
            if (!CharSequences.regionMatchesIgnoreCase(str, i, searchStr, 0, sLen)) continue;
            return i;
        }
        return -1;
    }

    public static int countIgnoreCase(CharSequence str, CharSequence searchStr) {
        int idx;
        int result = 0;
        int sLen = searchStr.length();
        if (sLen == 0) {
            return 0;
        }
        int from = 0;
        while ((idx = CharSequences.indexOfIgnoreCase(str, searchStr, from)) >= 0) {
            ++result;
            from = idx + sLen;
        }
        return result;
    }

    @GwtIncompatible
    public static Reader reader(CharSequence cs) {
        try {
            return CharSource.wrap((CharSequence)cs).openStream();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static final class SubSequence
    implements CharSequence {
        private final CharSequence underlyingSequence;
        private final int length;
        private final int startIdx;

        SubSequence(CharSequence underlyingSequence, int length, int startIdx) {
            this.underlyingSequence = underlyingSequence;
            this.length = length;
            this.startIdx = startIdx;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int index) {
            return this.underlyingSequence.charAt(this.startIdx + index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return CharSequences.subSequence(this.underlyingSequence, this.startIdx + start, this.startIdx + end);
        }

        @Override
        @SuppressFBWarnings(value={"STT_STRING_PARSING_A_FIELD"})
        public String toString() {
            if (this.underlyingSequence instanceof String) {
                return ((String)this.underlyingSequence).substring(this.startIdx, this.startIdx + this.length);
            }
            if (this.underlyingSequence instanceof StringBuilder) {
                return ((StringBuilder)this.underlyingSequence).substring(this.startIdx, this.startIdx + this.length);
            }
            char[] chars = new char[this.length];
            int idx = this.startIdx;
            int i = 0;
            while (i < this.length) {
                chars[i] = this.underlyingSequence.charAt(idx);
                ++i;
                ++idx;
            }
            return new String(chars);
        }
    }
}

