/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.spf4j.base.CloseableIterator;

@CleanupObligation
public interface CloseableIterable<T>
extends Closeable,
Iterable<T> {
    @Override
    @DischargesObligation
    public void close();

    public static <T> CloseableIterable<T> from(final CloseableIterator<T> iterator) {
        return new CloseableIterable<T>(){

            @Override
            public void close() {
                iterator.close();
            }

            @Override
            public Iterator<T> iterator() {
                return iterator;
            }
        };
    }

    public static <T> CloseableIterable<T> from(Iterable<T> it) {
        return CloseableIterable.from(it, () -> {});
    }

    public static <T> CloseableIterable<T> from(final Iterable<T> it, final AutoCloseable close) {
        return new CloseableIterable<T>(){

            @Override
            @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CHECKED"})
            public void close() {
                try {
                    close.close();
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public Iterator<T> iterator() {
                return it.iterator();
            }
        };
    }

    default public Stream<T> toStream() {
        return this.toStream(false);
    }

    default public Stream<T> toStream(boolean parallel) {
        return (Stream)StreamSupport.stream(this.spliterator(), parallel).onClose(() -> this.close());
    }
}

