/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@CleanupObligation
public interface CloseableIterator<T>
extends Iterator<T>,
Closeable {
    @Override
    @DischargesObligation
    public void close();

    public static <T> CloseableIterator<T> from(Iterator<T> it) {
        return CloseableIterator.from(it, () -> {});
    }

    public static <T> CloseableIterator<T> from(final Iterator<T> it, final AutoCloseable close) {
        return new CloseableIterator<T>(){

            @Override
            @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CHECKED"})
            public void close() {
                try {
                    close.close();
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public T next() {
                return it.next();
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
    }

    default public Stream<T> toStreamRemaining() {
        return this.toStreamRemaining(false);
    }

    default public Stream<T> toStreamRemaining(boolean parallel) {
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(this, 0), parallel).onClose(() -> this.close());
    }
}

