/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.spf4j.base.Throwables;

public final class Closeables {
    private Closeables() {
    }

    @Nullable
    @CheckReturnValue
    public static Exception closeAll(AutoCloseable ... closeables) {
        return Closeables.closeAll(null, closeables);
    }

    @Nullable
    @CheckReturnValue
    public static Exception closeAll(@Nullable Exception propagate, AutoCloseable ... closeables) {
        Exception ex = propagate;
        for (AutoCloseable closeable : closeables) {
            try {
                closeable.close();
            }
            catch (Exception ex1) {
                if (ex == null) {
                    ex = ex1;
                    continue;
                }
                Throwables.suppressLimited(ex1, ex);
                ex = ex1;
            }
        }
        return ex;
    }

    @Nullable
    @CheckReturnValue
    public static IOException closeAll(Closeable ... closeables) {
        return Closeables.closeAll(null, closeables);
    }

    @Nullable
    @CheckReturnValue
    public static IOException closeAll(@Nullable Exception propagate, Closeable ... closeables) {
        IOException ex = propagate == null ? null : (propagate instanceof IOException ? (IOException)propagate : new IOException(propagate));
        for (Closeable closeable : closeables) {
            try {
                closeable.close();
            }
            catch (IOException ex1) {
                if (ex != null) {
                    Throwables.suppressLimited(ex1, ex);
                }
                ex = ex1;
            }
        }
        return ex;
    }

    @Nullable
    @CheckReturnValue
    public static IOException closeAll(Closeable[] closeables, int from, int to) {
        IOException ex = null;
        for (int i = from; i < to; ++i) {
            Closeable closeable = closeables[i];
            try {
                closeable.close();
                continue;
            }
            catch (IOException ex1) {
                if (ex != null) {
                    Throwables.suppressLimited(ex1, ex);
                }
                ex = ex1;
            }
        }
        return ex;
    }

    @Nullable
    @CheckReturnValue
    public static Exception closeAll(Iterable<? extends AutoCloseable> closeables) {
        return Closeables.closeAll(null, closeables);
    }

    @Nullable
    @CheckReturnValue
    public static Exception closeAll(@Nullable Exception propagate, Iterable<? extends AutoCloseable> closeables) {
        Exception ex = propagate;
        for (AutoCloseable autoCloseable : closeables) {
            try {
                autoCloseable.close();
            }
            catch (Exception ex1) {
                if (ex != null) {
                    Throwables.suppressLimited(ex1, ex);
                }
                ex = ex1;
            }
        }
        return ex;
    }

    @Nullable
    @CheckReturnValue
    public static IOException closeSelectorChannels(Selector selector) {
        return Closeables.closeSelectorChannels(null, selector);
    }

    @Nullable
    @CheckReturnValue
    public static IOException closeSelectorChannels(@Nullable IOException propagate, Selector selector) {
        IOException ex = propagate;
        for (SelectionKey key : selector.keys()) {
            SelectableChannel channel = key.channel();
            try {
                channel.close();
            }
            catch (IOException ex2) {
                if (ex != null) {
                    Throwables.suppressLimited(ex2, ex);
                }
                ex = ex2;
            }
        }
        return ex;
    }
}

