/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.Signed;
import org.spf4j.base.ContextValue;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.base.JsonWriteable;
import org.spf4j.base.StackSamples;
import org.spf4j.base.TimeSource;
import org.spf4j.base.UncheckedTimeoutException;
import org.spf4j.base.avro.Converters;
import org.spf4j.base.avro.DebugDetail;
import org.spf4j.base.avro.StackSampleElement;
import org.spf4j.log.Level;
import org.spf4j.log.Slf4jLogRecord;

@CleanupObligation
@ParametersAreNonnullByDefault
public interface ExecutionContext
extends AutoCloseable,
JsonWriteable {
    @Override
    @DischargesObligation
    public void close();

    @Nonnull
    public String getName();

    public CharSequence getId();

    public long getStartTimeNanos();

    public long getDeadlineNanos();

    @Nullable
    public ExecutionContext getSource();

    default public ExecutionContext getRoot() {
        ExecutionContext parent;
        ExecutionContext curr = this;
        while ((parent = curr.getSource()) != null) {
            curr = parent;
        }
        return curr;
    }

    default public ExecutionContext getRootParent() {
        ExecutionContext parent;
        ExecutionContext curr = this;
        while (curr.getRelationToSource() == Relation.CHILD_OF && (parent = curr.getSource()) != null) {
            curr = parent;
        }
        return curr;
    }

    @Nullable
    default public ExecutionContext getNotClosedParent() {
        ExecutionContext parent;
        ExecutionContext curr = this;
        while (true) {
            if (curr.getRelationToSource() != Relation.CHILD_OF) {
                return null;
            }
            parent = curr.getSource();
            if (parent == null || !parent.isClosed()) break;
            curr = parent;
        }
        return parent;
    }

    @Beta
    public void addLog(Slf4jLogRecord var1);

    @Beta
    public void addLogs(Collection<Slf4jLogRecord> var1);

    @Beta
    public void addCloseable(AutoCloseable var1);

    @Beta
    public Level getContextMinLogLevel(String var1);

    default public Level getContextMinLogLevel() {
        return this.getContextMinLogLevel("");
    }

    @Nullable
    @Beta
    public Level getBackendMinLogLevel(String var1);

    @Nullable
    default public Level getBackendMinLogLevel() {
        return this.getBackendMinLogLevel("");
    }

    @Nullable
    @Beta
    public Level setBackendMinLogLevel(String var1, Level var2);

    @Nullable
    default public Level setBackendMinLogLevel(Level level) {
        return this.setBackendMinLogLevel("", level);
    }

    @Beta
    public void streamLogs(Consumer<Slf4jLogRecord> var1);

    public void detach();

    public void attach();

    public boolean isAttached();

    @Nonnegative
    default public long getTimeToDeadline(TimeUnit unit) throws TimeoutException {
        long result = this.getTimeRelativeToDeadline(unit);
        if (result <= 0L) {
            throw new TimeoutException("Deadline exceeded by " + -result + ' ' + (Object)((Object)unit));
        }
        return result;
    }

    @Nonnegative
    default public long getUncheckedTimeToDeadline(TimeUnit unit) {
        long result = this.getTimeRelativeToDeadline(unit);
        if (result <= 0L) {
            throw new UncheckedTimeoutException("Deadline exceeded by " + -result + ' ' + (Object)((Object)unit));
        }
        return result;
    }

    @Signed
    default public long getTimeRelativeToDeadline(TimeUnit unit) {
        return unit.convert(this.getDeadlineNanos() - TimeSource.nanoTime(), TimeUnit.NANOSECONDS);
    }

    @Nonnegative
    default public long getMillisToDeadline() throws TimeoutException {
        return this.getTimeToDeadline(TimeUnit.MILLISECONDS);
    }

    @Nonnegative
    default public int getSecondsToDeadline() throws TimeoutException {
        long secondsToDeadline = this.getTimeToDeadline(TimeUnit.SECONDS);
        if (secondsToDeadline > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)secondsToDeadline;
    }

    @Nullable
    @Beta
    public <T> T get(Tag<T, ?> var1);

    @Nullable
    @Beta
    public <T> ContextValue<T> getContextAndValue(Tag<T, ?> var1);

    @Nullable
    @Beta
    public <T> T getLocal(Tag<T, ?> var1);

    @Nullable
    @Beta
    public <T> T put(Tag<T, ?> var1, T var2);

    @Deprecated
    default public <T> void combine(Tag<T, ?> tag, T data) {
        this.accumulate(tag, data);
    }

    @Beta
    default public <T> void accumulate(Tag<T, ?> tag, T data) {
        this.compute(tag, (t, v) -> t.accumulate(v, data));
    }

    @Beta
    default public <T, A> void accumulateComponent(Tag<T, A> tag, A data) {
        this.compute(tag, (t, v) -> t.accumulateComponent(v, data));
    }

    @Nullable
    @Beta
    default public <T> T putToRootParent(Tag<T, ?> key, T data) {
        return this.getRootParent().put(key, data);
    }

    @Nullable
    @Beta
    public <V, A> V compute(Tag<V, A> var1, BiFunction<Tag<V, A>, V, V> var2);

    @Nullable
    @Beta
    default public <T> List<T> addToRootParent(Tag<List<T>, T> tag, T data) {
        ExecutionContext ctx = this.getRootParent();
        return ctx.compute(tag, (k, v) -> {
            if (v == null) {
                v = new ArrayList<Object>(2);
            }
            v.add(data);
            return v;
        });
    }

    default public ExecutionContext startChild(String operationName, long timeout, TimeUnit tu) {
        return ExecutionContexts.start(operationName, this, timeout, tu);
    }

    default public ExecutionContext startChild(String operationName) {
        return ExecutionContexts.start(operationName, this);
    }

    default public ExecutionContext detachedChild(String operationName, long timeout, TimeUnit tu) {
        return ExecutionContexts.createDetached(operationName, this, timeout, tu);
    }

    default public ExecutionContext detachedChild(String operationName) {
        return ExecutionContexts.createDetached(operationName, this, TimeSource.nanoTime(), this.getDeadlineNanos());
    }

    public long nextChildId();

    public void add(StackTraceElement[] var1);

    public void add(StackSamples var1);

    @Nullable
    public StackSamples getAndClearStackSamples();

    @Nullable
    public StackSamples getStackSamples();

    public boolean isClosed();

    public Relation getRelationToSource();

    default public DebugDetail getDebugDetail(String origin, @Nullable Throwable throwable) {
        return this.getDebugDetail(origin, throwable, true);
    }

    default public DebugDetail getDebugDetail(String origin, @Nullable Throwable throwable, boolean addStackSamples) {
        ArrayList<Slf4jLogRecord> ctxLogs = new ArrayList<Slf4jLogRecord>();
        for (ExecutionContext curr = this; curr != null; curr = curr.getSource()) {
            curr.streamLogs(log -> ctxLogs.add((Slf4jLogRecord)log));
        }
        Collections.sort(ctxLogs, Slf4jLogRecord::compareByTimestamp);
        if (addStackSamples) {
            StackSamples ss = this.getAndClearStackSamples();
            List<StackSampleElement> sses = Converters.convert(ss);
            return new DebugDetail(origin + '/' + this.getName(), Converters.convert("", this.getId().toString(), ctxLogs), throwable == null ? null : Converters.convert(throwable), sses);
        }
        return new DebugDetail(origin + '/' + this.getName(), Converters.convert("", this.getId().toString(), ctxLogs), throwable == null ? null : Converters.convert(throwable), Collections.emptyList());
    }

    public static enum Relation {
        CHILD_OF,
        FOLLOWS;

    }

    public static interface Tag<T, A> {
        public String toString();

        default public boolean isInherited(Relation relation) {
            return true;
        }

        default public boolean pushOnClose() {
            return false;
        }

        default public T accumulate(@Nullable T existing, T newVal) {
            return newVal;
        }

        default public T accumulateComponent(@Nullable T existing, A component) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface SimpleTag<T>
    extends Tag<T, Void> {
    }
}

