/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.Signed;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.base.BasicExecutionContext;
import org.spf4j.base.ExecutionContext;
import org.spf4j.base.ExecutionContextFactory;
import org.spf4j.base.ThreadLocalContextAttacher;
import org.spf4j.base.TimeSource;
import org.spf4j.base.TimeoutDeadline;
import org.spf4j.base.UncheckedTimeoutException;
import org.spf4j.base.Wrapper;
import org.spf4j.concurrent.ScalableSequence;
import org.spf4j.concurrent.UIDGenerator;
import org.spf4j.ds.SimpleStack;

@ParametersAreNonnullByDefault
@ThreadSafe
public final class ExecutionContexts {
    private static final UIDGenerator ID_GEN = new UIDGenerator(new ScalableSequence(0L, 10), "X", 1544368928196L);
    public static final long DEFAULT_TIMEOUT_NANOS = Long.getLong("spf4j.execContext.defaultTimeoutNanos", TimeUnit.HOURS.toNanos(8L));
    private static final ThreadLocal<SimpleStack<ExecutionContext>> EXEC_CTX = new ThreadLocal<SimpleStack<ExecutionContext>>(){

        @Override
        protected SimpleStack<ExecutionContext> initialValue() {
            return new SimpleStack<ExecutionContext>(4);
        }
    };
    private static final ThreadLocalContextAttacher DEFAULT_TL_ATTACHER = new ThreadLocalContextAttacherImpl();
    private static final ExecutionContextFactory<ExecutionContext> CTX_FACTORY = ExecutionContexts.initFactory();
    private static final ThreadLocalContextAttacher TL_ATTACHER = ExecutionContexts.initTLAttacher();

    private ExecutionContexts() {
    }

    private static ThreadLocalContextAttacher initTLAttacher() {
        ThreadLocalContextAttacher factory;
        String factoryClass = System.getProperty("spf4j.execContext.tlAttacherClass");
        if (factoryClass == null) {
            factory = DEFAULT_TL_ATTACHER;
        } else {
            try {
                factory = (ThreadLocalContextAttacher)Class.forName(factoryClass).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }
        return factory;
    }

    private static ExecutionContextFactory<ExecutionContext> initFactory() {
        ExecutionContextFactory<ExecutionContext> factory;
        String factoryClass = System.getProperty("spf4j.execContext.factoryClass");
        if (factoryClass == null) {
            factory = new BasicExecutionContextFactory();
        } else {
            try {
                factory = (ExecutionContextFactory)Class.forName(factoryClass).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }
        String factoryWrapperClass = System.getProperty("spf4j.execContext.factoryWrapperClass");
        if (factoryWrapperClass != null) {
            try {
                factory = (ExecutionContextFactory)Class.forName(factoryWrapperClass).getConstructor(ExecutionContextFactory.class).newInstance(factory);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }
        return factory;
    }

    public static ThreadLocalContextAttacher defaultThreadLocalAttacher() {
        return DEFAULT_TL_ATTACHER;
    }

    public static ThreadLocalContextAttacher threadLocalAttacher() {
        return TL_ATTACHER;
    }

    public static CharSequence genId() {
        return ID_GEN.next();
    }

    public static ExecutionContextFactory<ExecutionContext> getContextFactory() {
        return CTX_FACTORY;
    }

    @Nullable
    public static ExecutionContext current() {
        return EXEC_CTX.get().peek();
    }

    public static boolean inCurrentThread(ExecutionContext ctx) {
        return EXEC_CTX.get().contains(ctx);
    }

    public static void clearCurrentThread() {
        EXEC_CTX.get().clear();
    }

    public static ExecutionContext start(long startTimeNanos, long deadlineNanos) {
        return ExecutionContexts.start("anon", null, startTimeNanos, deadlineNanos);
    }

    public static ExecutionContext start(long timeout, TimeUnit tu) {
        return ExecutionContexts.start("anon", ExecutionContexts.current(), timeout, tu);
    }

    public static ExecutionContext start(String opname) {
        return ExecutionContexts.start(opname, ExecutionContexts.current(), DEFAULT_TIMEOUT_NANOS, TimeUnit.NANOSECONDS);
    }

    public static ExecutionContext start(String opname, long timeout, TimeUnit tu) {
        return ExecutionContexts.start(opname, ExecutionContexts.current(), timeout, tu);
    }

    public static ExecutionContext start(@Nullable ExecutionContext parent, long timeout, TimeUnit tu) {
        return ExecutionContexts.start("anon", parent, timeout, tu);
    }

    public static ExecutionContext start(@Nullable ExecutionContext parent) {
        long nanoTime = TimeSource.nanoTime();
        return ExecutionContexts.start(parent, nanoTime, parent != null ? parent.getDeadlineNanos() : nanoTime + DEFAULT_TIMEOUT_NANOS);
    }

    public static ExecutionContext start(@Nullable ExecutionContext parent, long startTimeNanos, long deadlineNanos) {
        return ExecutionContexts.start("anon", parent, startTimeNanos, deadlineNanos);
    }

    public static ExecutionContext start(String name, long startTimeNanos, long deadlineNanos) {
        return ExecutionContexts.start(name, ExecutionContexts.current(), startTimeNanos, deadlineNanos);
    }

    public static ExecutionContext start(String name, long deadlineNanos) {
        return ExecutionContexts.start(name, ExecutionContexts.current(), TimeSource.nanoTime(), deadlineNanos);
    }

    public static ExecutionContext start(String name, @Nullable ExecutionContext parent) {
        long nanoTime = TimeSource.nanoTime();
        return ExecutionContexts.start(name, parent, nanoTime, parent != null ? parent.getDeadlineNanos() : nanoTime + DEFAULT_TIMEOUT_NANOS);
    }

    public static ExecutionContext start(String name, @Nullable ExecutionContext parent, long timeout, TimeUnit tu) {
        return ExecutionContexts.start(name, null, parent, timeout, tu);
    }

    public static ExecutionContext start(String name, @Nullable CharSequence id, @Nullable ExecutionContext parent, long timeout, TimeUnit tu) {
        long nanoTime = TimeSource.nanoTime();
        return ExecutionContexts.start(name, id, parent, nanoTime, ExecutionContexts.computeDeadline(nanoTime, parent, tu, timeout));
    }

    public static ExecutionContext createDetached(String name, @Nullable ExecutionContext parent, long timeout, TimeUnit tu) {
        long nanoTime = TimeSource.nanoTime();
        return ExecutionContexts.createDetached(name, parent, nanoTime, ExecutionContexts.computeDeadline(nanoTime, parent, tu, timeout));
    }

    public static ExecutionContext start(String name, @Nullable ExecutionContext parent, long deadlineNanos) {
        return ExecutionContexts.start(name, parent, TimeSource.nanoTime(), deadlineNanos);
    }

    public static ExecutionContext start(String name, @Nullable ExecutionContext parent, long startTimeNanos, long deadlineNanos) {
        return ExecutionContexts.start(name, null, parent, startTimeNanos, deadlineNanos);
    }

    public static ExecutionContext start(String name, @Nullable CharSequence id, @Nullable ExecutionContext parent, long startTimeNanos, long deadlineNanos) {
        return ExecutionContexts.start(name, id, parent, ExecutionContext.Relation.CHILD_OF, startTimeNanos, deadlineNanos);
    }

    public static ExecutionContext start(String name, @Nullable CharSequence id, @Nullable ExecutionContext parent, ExecutionContext.Relation relation, long startTimeNanos, long deadlineNanos) {
        ExecutionContext nCtx = CTX_FACTORY.start(name, id, parent, relation, startTimeNanos, deadlineNanos);
        nCtx.attach();
        return nCtx;
    }

    public static ExecutionContext createDetached(String name, @Nullable ExecutionContext parent, long startTimeNanos, long deadlineNanos) {
        return ExecutionContexts.createDetached(name, parent, ExecutionContext.Relation.CHILD_OF, startTimeNanos, deadlineNanos);
    }

    public static ExecutionContext createDetached(String name, @Nullable ExecutionContext parent, ExecutionContext.Relation relation, long startTimeNanos, long deadlineNanos) {
        return ExecutionContexts.createDetached(name, null, parent, relation, startTimeNanos, deadlineNanos);
    }

    public static ExecutionContext createDetached(String name, @Nullable CharSequence id, @Nullable ExecutionContext parent, ExecutionContext.Relation relation, long startTimeNanos, long deadlineNanos) {
        return CTX_FACTORY.start(name, id, parent, relation, startTimeNanos, deadlineNanos);
    }

    public static long getContextDeadlineNanos() {
        ExecutionContext ec = ExecutionContexts.current();
        if (ec == null) {
            return TimeSource.nanoTime() + DEFAULT_TIMEOUT_NANOS;
        }
        return ec.getDeadlineNanos();
    }

    public static long getContextDeadlineNanos(long currentTime) {
        ExecutionContext ec = ExecutionContexts.current();
        if (ec == null) {
            return currentTime + DEFAULT_TIMEOUT_NANOS;
        }
        return ec.getDeadlineNanos();
    }

    @Signed
    public static long getTimeRelativeToDeadline(TimeUnit unit) {
        return unit.convert(ExecutionContexts.getContextDeadlineNanos() - TimeSource.nanoTime(), TimeUnit.NANOSECONDS);
    }

    @Nonnegative
    public static long getTimeToDeadline(TimeUnit unit) throws TimeoutException {
        long timeRelativeToDeadline = ExecutionContexts.getTimeRelativeToDeadline(unit);
        if (timeRelativeToDeadline <= 0L) {
            throw new TimeoutException("Deadline exceeded by " + -timeRelativeToDeadline + ' ' + (Object)((Object)unit));
        }
        return timeRelativeToDeadline;
    }

    @Nonnegative
    public static long getTimeToDeadlineUnchecked(TimeUnit unit) {
        long timeRelativeToDeadline = ExecutionContexts.getTimeRelativeToDeadline(unit);
        if (timeRelativeToDeadline <= 0L) {
            throw new UncheckedTimeoutException("Deadline exceeded by " + -timeRelativeToDeadline + ' ' + (Object)((Object)unit));
        }
        return timeRelativeToDeadline;
    }

    @Nonnegative
    public static int getTimeToDeadlineInt(TimeUnit unit) throws TimeoutException {
        long timeRelativeToDeadline = ExecutionContexts.getTimeToDeadline(unit);
        if (timeRelativeToDeadline > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)timeRelativeToDeadline;
    }

    @Nonnegative
    public static long getMillisToDeadline() throws TimeoutException {
        return ExecutionContexts.getTimeToDeadline(TimeUnit.MILLISECONDS);
    }

    @Nonnegative
    public static int getSecondsToDeadline() throws TimeoutException {
        long secondsToDeadline = ExecutionContexts.getTimeToDeadline(TimeUnit.SECONDS);
        if (secondsToDeadline > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)secondsToDeadline;
    }

    public static long computeDeadline(long timeout, TimeUnit unit) {
        return ExecutionContexts.computeDeadline(ExecutionContexts.current(), timeout, unit);
    }

    public static long computeTimeout(long timeout, TimeUnit unit) throws TimeoutException {
        return unit.convert(ExecutionContexts.computeTimeoutDeadline(ExecutionContexts.current(), unit, timeout).getTimeoutNanos(), TimeUnit.NANOSECONDS);
    }

    @Deprecated
    public static long computeDeadline(@Nullable ExecutionContext current, TimeUnit unit, long timeout) {
        return ExecutionContexts.computeDeadline(current, timeout, unit);
    }

    public static long computeDeadline(@Nullable ExecutionContext current, long timeout, TimeUnit unit) {
        long timeoutNanos;
        if (current == null) {
            return TimeSource.getDeadlineNanos(timeout, unit);
        }
        long nanoTime = TimeSource.nanoTime();
        long ctxDeadlinenanos = current.getDeadlineNanos();
        return ctxDeadlinenanos - nanoTime < (timeoutNanos = unit.toNanos(timeout)) ? ctxDeadlinenanos : nanoTime + timeoutNanos;
    }

    public static long computeDeadline(long startTimeNanos, @Nullable ExecutionContext current, TimeUnit unit, long timeout) {
        long timeoutNanos;
        if (current == null) {
            return TimeSource.getDeadlineNanos(startTimeNanos, timeout, unit);
        }
        long ctxDeadlinenanos = current.getDeadlineNanos();
        return ctxDeadlinenanos - startTimeNanos < (timeoutNanos = unit.toNanos(timeout)) ? ctxDeadlinenanos : startTimeNanos + timeoutNanos;
    }

    public static TimeoutDeadline computeTimeoutDeadline(@Nullable ExecutionContext current, TimeUnit unit, long timeout) throws TimeoutException {
        long timeoutNanos;
        if (current == null) {
            return TimeoutDeadline.of(unit.toNanos(timeout), TimeSource.getDeadlineNanos(timeout, unit));
        }
        long nanoTime = TimeSource.nanoTime();
        long ctxDeadlinenanos = current.getDeadlineNanos();
        long contextTimeoutNanos = ctxDeadlinenanos - nanoTime;
        return contextTimeoutNanos < (timeoutNanos = unit.toNanos(timeout)) ? TimeoutDeadline.of(contextTimeoutNanos, ctxDeadlinenanos) : TimeoutDeadline.of(timeoutNanos, nanoTime + timeoutNanos);
    }

    public static <T> Callable<T> propagatingCallable(Callable<T> callable) {
        ExecutionContext current = ExecutionContexts.current();
        return current == null ? callable : ExecutionContexts.propagatingCallable(callable, current);
    }

    public static <T> Callable<T> propagatingCallable(Callable<T> callable, ExecutionContext ctx) {
        return new PropagatingCallable<T>(callable, ctx);
    }

    public static <T> Collection<? extends Callable<T>> propagatingCallables(Collection<? extends Callable<T>> tasks) {
        ExecutionContext current = ExecutionContexts.current();
        return current == null ? tasks : ExecutionContexts.propagatingCallables(tasks, current);
    }

    public static <T> Collection<? extends Callable<T>> propagatingCallables(Collection<? extends Callable<T>> tasks, ExecutionContext ctx) {
        return tasks.stream().map(c -> new PropagatingCallable(c, ctx)).collect(Collectors.toCollection(() -> new ArrayList(tasks.size())));
    }

    public static <T> Collection<? extends Callable<T>> deadlinedPropagatingCallables(Collection<? extends Callable<T>> tasks, ExecutionContext ctx, long deadlineNanos) {
        return tasks.stream().map(c -> new PropagatingNamedCallable(c, ctx, null, deadlineNanos)).collect(Collectors.toCollection(() -> new ArrayList(tasks.size())));
    }

    public static <T> Callable<T> deadlinedPropagatingCallable(Callable<T> callable, ExecutionContext ctx, long deadlineNanos) {
        return new PropagatingNamedCallable<T>(callable, ctx, null, deadlineNanos);
    }

    public static Runnable propagatingRunnable(Runnable runnable) {
        ExecutionContext current = ExecutionContexts.current();
        return current == null ? runnable : ExecutionContexts.propagatingRunnable(runnable, current);
    }

    public static Runnable propagatingRunnable(Runnable runnable, ExecutionContext ctx) {
        return new PropagatingRunnable(runnable, ctx, null, ctx.getDeadlineNanos());
    }

    public static Runnable propagatingRunnable(Runnable runnable, ExecutionContext ctx, @Nullable String name, long deadlineNanos) {
        return new PropagatingRunnable(runnable, ctx, name, deadlineNanos);
    }

    public static <T> Callable<T> propagatingCallable(Callable<T> callable, ExecutionContext ctx, @Nullable String name, long deadlineNanos) {
        return new PropagatingNamedCallable<T>(callable, ctx, name, deadlineNanos);
    }

    public static <X, Y> Function<X, Y> propagatingFunction(Function<X, Y> callable, ExecutionContext ctx, @Nullable String name, long deadlineNanos) {
        return new PropagatingFunction<X, Y>(callable, ctx, name, deadlineNanos);
    }

    public static <X, Y, Z> BiFunction<X, Y, Z> propagatingBiFunction(BiFunction<X, Y, Z> callable, ExecutionContext ctx, @Nullable String name, long deadlineNanos) {
        return new PropagatingBiFunction<X, Y, Z>(callable, ctx, name, deadlineNanos);
    }

    public static <X> Consumer<X> propagatingConsumer(Consumer<X> callable, ExecutionContext ctx, @Nullable String name, long deadlineNanos) {
        return new PropagatingConsumer<X>(callable, ctx, name, deadlineNanos);
    }

    public static <X> Supplier<X> propagatingSupplier(Supplier<X> callable, ExecutionContext ctx, @Nullable String name, long deadlineNanos) {
        return new PropagatingSupplier<X>(callable, ctx, name, deadlineNanos);
    }

    public static <X, Y> BiConsumer<X, Y> propagatingBiConsumer(BiConsumer<X, Y> callable, ExecutionContext ctx, @Nullable String name, long deadlineNanos) {
        return new PropagatingBiConsumer<X, Y>(callable, ctx, name, deadlineNanos);
    }

    private static class ThreadLocalContextAttacherImpl
    implements ThreadLocalContextAttacher {
        private ThreadLocalContextAttacherImpl() {
        }

        @Override
        public ThreadLocalContextAttacher.Attached attach(ExecutionContext ctx) {
            Thread currentThread = Thread.currentThread();
            SimpleStack contextStack = (SimpleStack)EXEC_CTX.get();
            int stackPtr = contextStack.pushAndGetIdx(ctx);
            return new AttachedImpl(currentThread, contextStack, ctx, stackPtr);
        }

        private static class AttachedImpl
        implements ThreadLocalContextAttacher.Attached {
            private final Thread thread;
            private final SimpleStack<ExecutionContext> contextStack;
            private final ExecutionContext ctx;
            private final int stackPtr;

            AttachedImpl(Thread currentThread, SimpleStack<ExecutionContext> contextStack, ExecutionContext ctx, int stackPtr) {
                this.thread = currentThread;
                this.contextStack = contextStack;
                this.ctx = ctx;
                this.stackPtr = stackPtr;
            }

            @Override
            public void detach() {
                Thread now = Thread.currentThread();
                if (now != this.thread) {
                    throw new IllegalStateException("Detaching in different thread " + this.thread + " != " + now);
                }
                ExecutionContext pop = (ExecutionContext)this.contextStack.pop();
                if (pop != this.ctx) {
                    this.contextStack.push(pop);
                    throw new IllegalStateException("Detaching ctx that is not attached " + this.ctx + ", found: " + pop);
                }
            }

            @Override
            public boolean isTopOfStack() {
                return this.stackPtr == 0;
            }

            @Override
            public Thread attachedThread() {
                return this.thread;
            }
        }
    }

    private static final class PropagatingRunnable
    implements Runnable,
    Wrapper<Runnable> {
        private final Runnable task;
        private final ExecutionContext current;
        private final String name;
        private final long deadlineNanos;

        PropagatingRunnable(Runnable task, ExecutionContext current, String name, long deadlineNanos) {
            this.task = task;
            this.current = current;
            this.name = name;
            this.deadlineNanos = deadlineNanos;
        }

        @Override
        public void run() {
            try (ExecutionContext ctx = ExecutionContexts.start(this.toString(), this.current, this.deadlineNanos);){
                this.task.run();
            }
        }

        @Override
        public Runnable getWrapped() {
            return this.task;
        }

        public String toString() {
            return this.name == null ? this.task.toString() : this.name;
        }
    }

    private static final class PropagatingBiConsumer<X, Y>
    implements BiConsumer<X, Y>,
    Wrapper<BiConsumer<X, Y>> {
        private final BiConsumer<X, Y> function;
        private final ExecutionContext current;
        private final String name;
        private final long deadlineNanos;

        PropagatingBiConsumer(BiConsumer<X, Y> task, ExecutionContext current, String name, long deadlineNanos) {
            this.function = task;
            this.current = current;
            this.name = name;
            this.deadlineNanos = deadlineNanos;
        }

        @Override
        public void accept(X x, Y y) {
            try (ExecutionContext ctx = ExecutionContexts.start(this.toString(), this.current, this.deadlineNanos);){
                this.function.accept(x, y);
            }
        }

        public String toString() {
            return this.name == null ? this.function.toString() : this.name;
        }

        @Override
        public BiConsumer<X, Y> getWrapped() {
            return this.function;
        }
    }

    private static final class PropagatingSupplier<X>
    implements Supplier<X>,
    Wrapper<Supplier<X>> {
        private final Supplier<X> function;
        private final ExecutionContext current;
        private final String name;
        private final long deadlineNanos;

        PropagatingSupplier(Supplier<X> task, ExecutionContext current, String name, long deadlineNanos) {
            this.function = task;
            this.current = current;
            this.name = name;
            this.deadlineNanos = deadlineNanos;
        }

        @Override
        public X get() {
            try (ExecutionContext ctx = ExecutionContexts.start(this.toString(), this.current, this.deadlineNanos);){
                X x = this.function.get();
                return x;
            }
        }

        public String toString() {
            return this.name == null ? this.function.toString() : this.name;
        }

        @Override
        public Supplier<X> getWrapped() {
            return this.function;
        }
    }

    private static final class PropagatingConsumer<X>
    implements Consumer<X>,
    Wrapper<Consumer<X>> {
        private final Consumer<X> function;
        private final ExecutionContext current;
        private final String name;
        private final long deadlineNanos;

        PropagatingConsumer(Consumer<X> task, ExecutionContext current, String name, long deadlineNanos) {
            this.function = task;
            this.current = current;
            this.name = name;
            this.deadlineNanos = deadlineNanos;
        }

        @Override
        public void accept(X in) {
            try (ExecutionContext ctx = ExecutionContexts.start(this.toString(), this.current, this.deadlineNanos);){
                this.function.accept(in);
            }
        }

        public String toString() {
            return this.name == null ? this.function.toString() : this.name;
        }

        @Override
        public Consumer<X> getWrapped() {
            return this.function;
        }
    }

    private static final class PropagatingBiFunction<X, Y, Z>
    implements BiFunction<X, Y, Z>,
    Wrapper<BiFunction<X, Y, Z>> {
        private final BiFunction<X, Y, Z> function;
        private final ExecutionContext current;
        private final String name;
        private final long deadlineNanos;

        PropagatingBiFunction(BiFunction<X, Y, Z> task, ExecutionContext current, String name, long deadlineNanos) {
            this.function = task;
            this.current = current;
            this.name = name;
            this.deadlineNanos = deadlineNanos;
        }

        @Override
        public Z apply(X x, Y y) {
            try (ExecutionContext ctx = ExecutionContexts.start(this.toString(), this.current, this.deadlineNanos);){
                Z z = this.function.apply(x, y);
                return z;
            }
        }

        public String toString() {
            return this.name == null ? this.function.toString() : this.name;
        }

        @Override
        public BiFunction<X, Y, Z> getWrapped() {
            return this.function;
        }
    }

    private static final class PropagatingFunction<X, Y>
    implements Function<X, Y>,
    Wrapper<Function<X, Y>> {
        private final Function<X, Y> function;
        private final ExecutionContext current;
        private final String name;
        private final long deadlineNanos;

        PropagatingFunction(Function<X, Y> task, ExecutionContext current, String name, long deadlineNanos) {
            this.function = task;
            this.current = current;
            this.name = name;
            this.deadlineNanos = deadlineNanos;
        }

        @Override
        public Y apply(X in) {
            try (ExecutionContext ctx = ExecutionContexts.start(this.toString(), this.current, this.deadlineNanos);){
                Y y = this.function.apply(in);
                return y;
            }
        }

        public String toString() {
            return this.name == null ? this.function.toString() : this.name;
        }

        @Override
        public Function<X, Y> getWrapped() {
            return this.function;
        }
    }

    private static final class PropagatingNamedCallable<T>
    implements Callable<T>,
    Wrapper<Callable<T>> {
        private final Callable<T> task;
        private final ExecutionContext current;
        private final String name;
        private final long deadlineNanos;

        PropagatingNamedCallable(Callable<T> task, ExecutionContext current, @Nullable String name, long deadlineNanos) {
            this.task = task;
            this.current = current;
            this.name = name;
            this.deadlineNanos = deadlineNanos;
        }

        @Override
        public T call() throws Exception {
            try (ExecutionContext ctx = ExecutionContexts.start(this.toString(), this.current, this.deadlineNanos);){
                T t = this.task.call();
                return t;
            }
        }

        public String toString() {
            return this.name == null ? this.task.toString() : this.name;
        }

        @Override
        public Callable<T> getWrapped() {
            return this.task;
        }
    }

    private static final class PropagatingCallable<T>
    implements Callable<T> {
        private final Callable<T> task;
        private final ExecutionContext current;

        PropagatingCallable(Callable<T> task, ExecutionContext current) {
            this.task = task;
            this.current = current;
        }

        @Override
        public T call() throws Exception {
            try (ExecutionContext ctx = this.current.startChild(this.task.toString());){
                T t = this.task.call();
                return t;
            }
        }
    }

    private static class BasicExecutionContextFactory
    implements ExecutionContextFactory<ExecutionContext> {
        private BasicExecutionContextFactory() {
        }

        @Override
        public ExecutionContext start(String name, @Nullable CharSequence id, @Nullable ExecutionContext parent, ExecutionContext.Relation relation, long startTimeNanos, long deadlineNanos) {
            return new BasicExecutionContext(name, id, parent, relation, startTimeNanos, deadlineNanos);
        }
    }
}

