/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.google.common.annotations.GwtCompatible;
import java.io.IOException;

@GwtCompatible
public interface IntAppender {
    public void append(int var1, Appendable var2) throws IOException;

    public static final class SimplePrefixNumberAppender
    implements IntAppender {
        public static final SimplePrefixNumberAppender INSTANCE = new SimplePrefixNumberAppender();

        private SimplePrefixNumberAppender() {
        }

        @Override
        public void append(int number, Appendable appendTo) throws IOException {
            appendTo.append(Integer.toString(number)).append(": ");
        }
    }

    public static final class CommentNumberAppender
    implements IntAppender {
        public static final CommentNumberAppender INSTANCE = new CommentNumberAppender();

        private CommentNumberAppender() {
        }

        @Override
        public void append(int number, Appendable appendTo) throws IOException {
            appendTo.append("/* ").append(Integer.toString(number)).append(" */ ");
        }
    }
}

