/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.ServiceLoader;
import org.spf4j.base.JsonWriteable;

public final class Json {
    public static final JsonFactory FACTORY = new JsonFactory();
    public static final ObjectMapper MAPPER = new ObjectMapper(FACTORY);

    private Json() {
    }

    private static void loadServices(SimpleModule module) {
        ServiceLoader<JsonSerializer> loader = ServiceLoader.load(JsonSerializer.class);
        for (JsonSerializer ser : loader) {
            module.addSerializer(ser);
        }
    }

    public static JsonSerializer<JsonWriteable> jsonWritableSerializer() {
        return new JsonSerializer<JsonWriteable>(){

            public void serialize(JsonWriteable value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                Object outputTarget = jgen.getOutputTarget();
                if (outputTarget instanceof Appendable) {
                    jgen.flush();
                    if (jgen.getOutputContext().getCurrentName() != null) {
                        ((Appendable)outputTarget).append(':');
                    }
                    value.writeJsonTo((Appendable)outputTarget);
                    return;
                }
                StringBuilder json = new StringBuilder(32);
                value.writeJsonTo(json);
                jgen.writeRawValue(json.toString());
            }
        };
    }

    public static JsonSerializer<Object> toStringJsonWritableSerializer() {
        return new JsonSerializer<Object>(){

            public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                jgen.writeString(value.toString());
            }
        };
    }

    static {
        FACTORY.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        SimpleModule module = new SimpleModule("spf4j");
        Json.loadServices(module);
        module.addSerializer(JsonWriteable.class, Json.jsonWritableSerializer());
        MAPPER.registerModule((Module)module);
        ServiceLoader<Module> loader = ServiceLoader.load(Module.class);
        for (Module mod : loader) {
            MAPPER.registerModule(mod);
        }
    }
}

