/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.Callable;
import org.spf4j.base.NullAbleOptional;

@SuppressFBWarnings(value={"NOS_NON_OWNED_SYNCHRONIZATION"})
public final class MemorizedCallable<V>
implements Callable<V> {
    private static final Object NOTHING = new Object();
    private volatile V value;
    private final Callable<V> callable;

    MemorizedCallable(Callable<V> callable) {
        this.callable = callable;
        this.value = NOTHING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V call() throws Exception {
        V result = this.value;
        if (result == NOTHING) {
            MemorizedCallable memorizedCallable = this;
            synchronized (memorizedCallable) {
                result = this.value;
                if (result == NOTHING) {
                    this.value = result = this.callable.call();
                }
            }
        }
        return result;
    }

    public V clear() {
        V result = this.value;
        this.value = NOTHING;
        return result;
    }

    public NullAbleOptional<V> getIfMemorized() {
        V rv = this.value;
        if (rv == NOTHING) {
            return NullAbleOptional.EMPTY;
        }
        return NullAbleOptional.of(rv);
    }

    public void set(V v) {
        this.value = v;
    }

    public String toString() {
        return "MemorizedCallable{value=" + this.value + '}';
    }
}

