/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.spf4j.base.CharSequences;
import org.spf4j.base.avro.Converters;
import org.spf4j.base.avro.Method;

@Immutable
@SuppressFBWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
public final class Methods {
    public static final Method ROOT = Converters.ROOT;
    private static final Map<String, Map<String, Method>> INSTANCE_REPO = new THashMap(1024);

    private Methods() {
    }

    public static void writeHtml(Method m, Writer w) throws IOException {
        Escaper htmlEscaper = HtmlEscapers.htmlEscaper();
        w.append(htmlEscaper.escape(m.getName())).append(htmlEscaper.escape("@")).append(htmlEscaper.escape(m.getDeclaringClass()));
    }

    public static Method getMethod(StackTraceElement elem) {
        return Methods.getMethod(elem.getClassName(), elem.getMethodName());
    }

    @SuppressFBWarnings(value={"PMB_POSSIBLE_MEMORY"})
    public static synchronized Method getMethod(String className, String methodName) {
        Method result;
        THashMap mtom = INSTANCE_REPO.get(className);
        if (mtom == null) {
            mtom = new THashMap(5);
            result = new Method(className, methodName);
            mtom.put(methodName, result);
            INSTANCE_REPO.put(className, (Map<String, Method>)mtom);
        } else {
            result = mtom.get(methodName);
            if (result == null) {
                result = new Method(className, methodName);
                mtom.put(methodName, result);
            }
        }
        return result;
    }

    public static void writeTo(Method m, Appendable w) throws IOException {
        w.append(m.getName()).append('@').append(m.getDeclaringClass());
    }

    public static void writeTo(Method m, StringBuilder w) {
        w.append(m.getName()).append('@').append(m.getDeclaringClass());
    }

    public static CharSequence toCharSequence(Method m) {
        StringBuilder sb = new StringBuilder(32);
        Methods.writeTo(m, sb);
        return sb;
    }

    public static String toString(Method m) {
        return Methods.toCharSequence(m).toString();
    }

    public static Method from(CharSequence cs) {
        return Methods.from(cs, 0, cs.length());
    }

    public static Method from(CharSequence cs, int start, int end) {
        int idx = CharSequences.indexOf(cs, start, end, '@');
        if (idx < 0) {
            throw new IllegalArgumentException("Invalid method representation: " + cs);
        }
        return Methods.getMethod(cs.subSequence(idx + 1, end).toString(), cs.subSequence(start, idx).toString());
    }
}

