/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URL;
import java.security.CodeSource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spf4j.base.Throwables;

@SuppressFBWarnings(value={"FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY"})
public final class PackageInfo {
    public static final org.spf4j.base.avro.PackageInfo NONE = new org.spf4j.base.avro.PackageInfo("", "");
    private static final LoadingCache<String, org.spf4j.base.avro.PackageInfo> CACHE = CacheBuilder.newBuilder().weakKeys().weakValues().build((CacheLoader)new CacheLoader<String, org.spf4j.base.avro.PackageInfo>(){

        public org.spf4j.base.avro.PackageInfo load(String key) {
            return PackageInfo.getPackageInfoDirect(key);
        }
    });

    private PackageInfo() {
    }

    public static void errorNoPackageDetail(String message, Throwable t) {
        if (Boolean.getBoolean("spf4j.reportPackageDetailIssues")) {
            System.err.println(message);
            Throwables.writeTo(t, System.err, Throwables.PackageDetail.NONE);
        }
    }

    @Nonnull
    public static org.spf4j.base.avro.PackageInfo getPackageInfoDirect(@Nonnull String className) {
        Class<?> aClass;
        try {
            aClass = Class.forName(className);
        }
        catch (Throwable ex) {
            PackageInfo.errorNoPackageDetail("Error getting package detail for " + className, ex);
            return NONE;
        }
        return PackageInfo.getPackageInfoDirect(aClass);
    }

    @Nonnull
    public static org.spf4j.base.avro.PackageInfo getPackageInfoDirect(@Nonnull Class<?> aClass) {
        URL jarSourceUrl = PackageInfo.getJarSourceUrl(aClass);
        Package aPackage = aClass.getPackage();
        if (aPackage == null) {
            return NONE;
        }
        String version = aPackage.getImplementationVersion();
        return new org.spf4j.base.avro.PackageInfo(jarSourceUrl == null ? "" : jarSourceUrl.toString(), version == null ? "" : version);
    }

    @Nonnull
    public static org.spf4j.base.avro.PackageInfo getPackageInfo(@Nonnull String className) {
        return (org.spf4j.base.avro.PackageInfo)CACHE.getUnchecked((Object)className);
    }

    @Nullable
    public static URL getJarSourceUrl(Class<?> clasz) {
        CodeSource codeSource = clasz.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            return null;
        }
        return codeSource.getLocation();
    }
}

