/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.UncheckedExecutionException;
import org.spf4j.concurrent.UnboundedLoadingCache;

@ParametersAreNonnullByDefault
@SuppressFBWarnings(value={"PMB_POSSIBLE_MEMORY_BLOAT"})
public final class Reflections {
    private static final BiMap<Class<?>, Class<?>> PRIMITIVE_MAP = HashBiMap.create((int)12);
    private static final Map<String, Class<?>> PRIMITIVES = new HashMap(12);
    private static final MethodHandle PARAMETER_TYPES_METHOD_FIELD_GET;
    private static final MethodHandle PARAMETER_TYPES_CONSTR_FIELD_GET;
    private static final MethodHandle FIND_CLASS;
    private static final LoadingCache<MethodDesc, Optional<Method>> CACHE_FAST;
    private static final LoadingCache<MethodDesc, MethodHandle> CACHE_FAST_MH;

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    private static void initPrimitiveMap() {
        PRIMITIVE_MAP.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_MAP.put(Character.TYPE, Character.class);
        PRIMITIVE_MAP.put(Short.TYPE, Short.class);
        PRIMITIVE_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_MAP.put(Double.TYPE, Double.class);
        PRIMITIVE_MAP.put(Void.TYPE, Void.class);
        for (Class clasz : PRIMITIVE_MAP.keySet()) {
            PRIMITIVES.put(clasz.getName(), clasz);
        }
    }

    private Reflections() {
    }

    public static Class<?>[] getParameterTypes(Method m) {
        if (PARAMETER_TYPES_METHOD_FIELD_GET != null) {
            try {
                return PARAMETER_TYPES_METHOD_FIELD_GET.invokeExact(m);
            }
            catch (Error | RuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new UncheckedExecutionException(ex);
            }
        }
        return m.getParameterTypes();
    }

    public static Class<?>[] getParameterTypes(Constructor<?> m) {
        if (PARAMETER_TYPES_CONSTR_FIELD_GET != null) {
            try {
                return PARAMETER_TYPES_CONSTR_FIELD_GET.invokeExact(m);
            }
            catch (Error | RuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new UncheckedExecutionException(ex);
            }
        }
        return m.getParameterTypes();
    }

    public static Class<?> primitiveToWrapper(Class<?> clasz) {
        if (clasz.isPrimitive()) {
            return (Class)PRIMITIVE_MAP.get(clasz);
        }
        return clasz;
    }

    @Nonnull
    public static Type primitiveToWrapper(Type type) {
        if (type instanceof Class && ((Class)type).isPrimitive()) {
            return (Type)PRIMITIVE_MAP.get((Object)((Class)type));
        }
        return type;
    }

    public static Class<?> wrapperToPrimitive(Class<?> clasz) {
        if (clasz.isPrimitive()) {
            return clasz;
        }
        return (Class)PRIMITIVE_MAP.inverse().get(clasz);
    }

    public static boolean isWrappableOrWrapper(Class clasz) {
        return PRIMITIVE_MAP.containsKey((Object)clasz) || PRIMITIVE_MAP.containsValue((Object)clasz);
    }

    public static Object getAnnotationAttribute(@Nonnull Annotation annot, @Nonnull String attributeName) {
        for (Method method : annot.annotationType().getDeclaredMethods()) {
            if (!method.getName().equals(attributeName)) continue;
            try {
                return method.invoke((Object)annot, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new UncheckedExecutionException(ex);
            }
        }
        throw new IllegalArgumentException(attributeName + " attribute is not present on annotation " + annot);
    }

    @Nullable
    @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="comparing interned strings")
    public static Method getDeclaredMethod(Class<?> c, String methodName, Class<?> ... paramTypes) {
        String internedName = methodName.intern();
        for (final Method m : c.getDeclaredMethods()) {
            if (m.getName() != internedName || !Arrays.equals(paramTypes, Reflections.getParameterTypes(m))) continue;
            if (!m.isAccessible()) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        m.setAccessible(true);
                        return null;
                    }
                });
            }
            return m;
        }
        return null;
    }

    @Nullable
    @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="comparing interned strings")
    public static Method getMethod(Class<?> c, String methodName, Class<?> ... paramTypes) {
        String internedName = methodName.intern();
        for (Method m : c.getMethods()) {
            if (m.getName() != internedName || !Arrays.equals(paramTypes, Reflections.getParameterTypes(m))) continue;
            return m;
        }
        return null;
    }

    @Nullable
    public static Constructor<?> getConstructor(Class<?> c, Class<?> ... paramTypes) {
        for (Constructor<?> cons : c.getDeclaredConstructors()) {
            if (!Arrays.equals(Reflections.getParameterTypes(cons), paramTypes)) continue;
            AccessController.doPrivileged(() -> {
                cons.setAccessible(true);
                return null;
            });
            return cons;
        }
        return null;
    }

    @Nullable
    public static Method getCompatibleMethod(Class<?> c, String methodName, Class<?> ... paramTypes) {
        Method[] methods;
        for (Method m : methods = c.getMethods()) {
            Class<?>[] actualTypes;
            if (!methodName.equals(m.getName()) || (actualTypes = Reflections.getParameterTypes(m)).length > paramTypes.length) continue;
            boolean found = true;
            int last = actualTypes.length - 1;
            for (int j = 0; j < actualTypes.length; ++j) {
                Class<?> actType = actualTypes[j];
                Class<?> paramType = paramTypes[j];
                found = Reflections.canAssign(actType, paramType);
                if (!found && j == last) {
                    if (actType.isArray()) {
                        boolean matchvararg = true;
                        Class<?> varargType = actType.getComponentType();
                        for (int k = j; k < paramTypes.length; ++k) {
                            if (Reflections.canAssign(varargType, paramTypes[k])) continue;
                            matchvararg = false;
                            break;
                        }
                        found = matchvararg;
                    }
                } else if (j == last && actualTypes.length < paramTypes.length) {
                    found = false;
                }
                if (!found) break;
            }
            if (!found) continue;
            return m;
        }
        return null;
    }

    @Nullable
    public static MethodHandle getCompatibleMethodHandle(Class<?> c, String methodName, Class<?> ... paramTypes) {
        Method compatibleMethod = Reflections.getCompatibleMethod(c, methodName, paramTypes);
        if (compatibleMethod == null) {
            return null;
        }
        try {
            return MethodHandles.lookup().unreflect(compatibleMethod);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object invoke(Method m, Object object, Object[] parameters) throws IllegalAccessException, InvocationTargetException {
        int np = parameters.length;
        if (np > 0) {
            Class<?>[] actTypes = Reflections.getParameterTypes(m);
            Class<?> lastParamClass = actTypes[actTypes.length - 1];
            if (Reflections.canAssign(lastParamClass, parameters[np - 1].getClass())) {
                return m.invoke(object, parameters);
            }
            if (lastParamClass.isArray()) {
                int lidx = actTypes.length - 1;
                int l = np - lidx;
                Object array = Array.newInstance(lastParamClass.getComponentType(), l);
                for (int k = 0; k < l; ++k) {
                    Array.set(array, k, parameters[lidx + k]);
                }
                Object[] newParams = new Object[actTypes.length];
                System.arraycopy(parameters, 0, newParams, 0, lidx);
                newParams[lidx] = array;
                return m.invoke(object, newParams);
            }
            throw new IllegalStateException();
        }
        return m.invoke(object, new Object[0]);
    }

    public static boolean canAssign(Class<?> to, Class<?> from) {
        boolean found = true;
        if (!to.isAssignableFrom(from)) {
            if (to.isPrimitive()) {
                Class boxed = (Class)PRIMITIVE_MAP.get(to);
                found = boxed.equals(from);
            } else {
                found = from.isPrimitive() ? ((Class)PRIMITIVE_MAP.get(from)).equals(to) : false;
            }
        }
        return found;
    }

    @Nullable
    public static Method getCompatibleMethodCached(Class<?> c, String methodName, Class<?> ... paramTypes) {
        return ((Optional)CACHE_FAST.getUnchecked((Object)new MethodDesc(c, methodName, paramTypes))).orElse(null);
    }

    public static MethodHandle getCompatibleMethodHandleCached(Class<?> c, String methodName, Class<?> ... paramTypes) {
        return (MethodHandle)CACHE_FAST_MH.getUnchecked((Object)new MethodDesc(c, methodName, paramTypes));
    }

    @Nullable
    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE", "URLCONNECTION_SSRF_FD"})
    public static Manifest getManifest(@Nonnull URL jarUrl) throws IOException {
        try (JarInputStream jis = new JarInputStream(jarUrl.openStream());){
            Manifest manifest = jis.getManifest();
            return manifest;
        }
    }

    public static <T> T implementStatic(Class<T> clasz, Class<?> target) {
        Method[] methods = clasz.getMethods();
        HashMap<Method, Method> map = new HashMap<Method, Method>(methods.length);
        for (Method from : methods) {
            Method to = Reflections.getCompatibleMethodCached(target, from.getName(), Reflections.getParameterTypes(from));
            if (to == null || !Modifier.isStatic(to.getModifiers())) {
                throw new IllegalArgumentException("Cannot map from " + clasz + " to " + target);
            }
            map.put(from, to);
        }
        return (T)Proxy.newProxyInstance(clasz.getClassLoader(), new Class[]{clasz}, (proxy, method, args) -> ((Method)map.get(method)).invoke(null, args));
    }

    public static <T> T implement(Class<T> clasz, Object target) {
        Method[] methods = clasz.getMethods();
        HashMap<Method, Method> map = new HashMap<Method, Method>(methods.length);
        Class<?> aClass = target.getClass();
        for (Method from : methods) {
            Method to = Reflections.getCompatibleMethodCached(aClass, from.getName(), Reflections.getParameterTypes(from));
            if (to == null) {
                throw new IllegalArgumentException("Cannot map from " + clasz + " to " + target);
            }
            map.put(from, to);
        }
        return (T)Proxy.newProxyInstance(clasz.getClassLoader(), new Class[]{clasz}, (proxy, method, args) -> ((Method)map.get(method)).invoke(target, args));
    }

    @Nullable
    public static Class<?> getLoadedClass(ClassLoader cl, String className) {
        try {
            return FIND_CLASS.invoke(cl, className);
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new UncheckedExecutionException(ex);
        }
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        Class<?> primitive = PRIMITIVES.get(name);
        if (primitive == null) {
            return Class.forName(name);
        }
        return primitive;
    }

    public static Class<?> forName(String name, ClassLoader loader) throws ClassNotFoundException {
        Class<?> primitive = PRIMITIVES.get(name);
        if (primitive == null) {
            return Class.forName(name, true, loader);
        }
        return primitive;
    }

    public static List<Type> getImplementedGenericInterfaces(Class<?> clasz) {
        Type[] genericInterfaces = clasz.getGenericInterfaces();
        Class<?> superclass = clasz.getSuperclass();
        if (superclass == null) {
            return Arrays.asList(genericInterfaces);
        }
        ArrayList<Type> result = new ArrayList<Type>(genericInterfaces.length);
        for (Type type : genericInterfaces) {
            result.add(type);
        }
        result.addAll(Reflections.getImplementedGenericInterfaces(superclass));
        return result;
    }

    @Nullable
    public static <A extends Annotation> A getInheritedAnnotation(Class<A> annotationClass, AnnotatedElement element) {
        A annotation = element.getAnnotation(annotationClass);
        if (annotation == null && element instanceof Method) {
            annotation = Reflections.getOverriddenAnnotation(annotationClass, (Method)element);
        }
        return annotation;
    }

    @Nullable
    private static <A extends Annotation> A getOverriddenAnnotation(Class<A> annotationClass, Method method) {
        A annotation;
        Class<?> methodClass = method.getDeclaringClass();
        String name = method.getName();
        Class<?>[] params = method.getParameterTypes();
        Class<?> superclass = methodClass.getSuperclass();
        if (superclass != null && (annotation = Reflections.getOverriddenMethodAnnotationFrom(annotationClass, superclass, name, params)) != null) {
            return annotation;
        }
        for (Class<?> intf : methodClass.getInterfaces()) {
            A annotation2 = Reflections.getOverriddenMethodAnnotationFrom(annotationClass, intf, name, params);
            if (annotation2 == null) continue;
            return annotation2;
        }
        return null;
    }

    @Nullable
    private static <A extends Annotation> A getOverriddenMethodAnnotationFrom(Class<A> annotationClass, Class<?> searchClass, String methodName, Class<?>[] params) {
        Method method = Reflections.getMethod(searchClass, methodName, params);
        if (method == null) {
            return null;
        }
        A annotation = method.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        return Reflections.getOverriddenAnnotation(annotationClass, method);
    }

    static {
        Reflections.initPrimitiveMap();
        Field mPtField = AccessController.doPrivileged(() -> {
            Field f;
            try {
                f = Method.class.getDeclaredField("parameterTypes");
                f.setAccessible(true);
            }
            catch (NoSuchFieldException | SecurityException ex) {
                Logger.getLogger(Reflections.class.getName()).log(Level.INFO, "Para type stealing from Method not supported", ex);
                f = null;
            }
            return f;
        });
        Field cPtField = AccessController.doPrivileged(() -> {
            Field f;
            try {
                f = Constructor.class.getDeclaredField("parameterTypes");
                f.setAccessible(true);
            }
            catch (NoSuchFieldException | SecurityException ex) {
                Logger.getLogger(Reflections.class.getName()).log(Level.INFO, "Para type stealing from Constructor not supported", ex);
                f = null;
            }
            return f;
        });
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        if (mPtField != null) {
            try {
                PARAMETER_TYPES_METHOD_FIELD_GET = lookup.unreflectGetter(mPtField);
            }
            catch (IllegalAccessException ex) {
                throw new ExceptionInInitializerError(ex);
            }
        } else {
            PARAMETER_TYPES_METHOD_FIELD_GET = null;
        }
        if (cPtField != null) {
            try {
                PARAMETER_TYPES_CONSTR_FIELD_GET = lookup.unreflectGetter(cPtField);
            }
            catch (IllegalAccessException ex) {
                throw new ExceptionInInitializerError(ex);
            }
        } else {
            PARAMETER_TYPES_CONSTR_FIELD_GET = null;
        }
        Method fc = AccessController.doPrivileged(() -> {
            Method m;
            try {
                m = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
                m.setAccessible(true);
            }
            catch (NoSuchMethodException | SecurityException ex) {
                throw new ExceptionInInitializerError(ex);
            }
            return m;
        });
        try {
            FIND_CLASS = lookup.unreflect(fc);
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionInInitializerError(ex);
        }
        CACHE_FAST = new UnboundedLoadingCache<MethodDesc, Optional<Method>>(64, new CacheLoader<MethodDesc, Optional<Method>>(){

            public Optional<Method> load(MethodDesc k) {
                final Method m = Reflections.getCompatibleMethod(k.getClasz(), k.getName(), k.getParamTypes());
                if (m == null) {
                    return Optional.empty();
                }
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        m.setAccessible(true);
                        return null;
                    }
                });
                return Optional.of(m);
            }
        });
        CACHE_FAST_MH = new UnboundedLoadingCache<MethodDesc, MethodHandle>(64, new CacheLoader<MethodDesc, MethodHandle>(){

            public MethodHandle load(MethodDesc k) {
                return Reflections.getCompatibleMethodHandle(k.getClasz(), k.getName(), k.getParamTypes());
            }
        });
    }

    static final class MethodDesc {
        @Nonnull
        private final Class<?> clasz;
        @Nonnull
        private final String name;
        @Nonnull
        private final Class<?>[] paramTypes;

        MethodDesc(Class<?> clasz, String name, Class<?>[] paramTypes) {
            this.clasz = clasz;
            this.name = name;
            this.paramTypes = paramTypes;
        }

        public Class<?> getClasz() {
            return this.clasz;
        }

        public String getName() {
            return this.name;
        }

        public Class<?>[] getParamTypes() {
            return this.paramTypes;
        }

        public int hashCode() {
            return 47 * this.clasz.hashCode() + this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof MethodDesc) {
                MethodDesc other = (MethodDesc)obj;
                if (!this.clasz.equals(other.clasz)) {
                    return false;
                }
                if (!this.name.equals(other.name)) {
                    return false;
                }
                return Arrays.equals(this.paramTypes, other.paramTypes);
            }
            return false;
        }

        public String toString() {
            return "MethodDesc{clasz=" + this.clasz + ',' + " name=" + this.name + ", paramTypes=" + Arrays.toString(this.paramTypes) + '}';
        }
    }
}

