/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.Arrays;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.base.JNA;
import org.spf4j.base.Reflections;
import org.spf4j.base.SysExits;
import org.spf4j.base.Threads;
import org.spf4j.base.Throwables;
import org.spf4j.base.TimeSource;
import org.spf4j.base.Timing;
import org.spf4j.base.avro.ApplicationInfo;
import org.spf4j.base.avro.Organization;
import org.spf4j.base.avro.PackageInfo;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.concurrent.UIDGenerator;
import org.spf4j.io.ByteArrayBuilder;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;
import org.spf4j.os.OperatingSystem;
import org.spf4j.os.ProcessHandler;
import org.spf4j.os.ProcessResponse;
import org.spf4j.os.ProcessUtil;
import org.spf4j.recyclable.impl.ArraySuppliers;
import org.spf4j.unix.CLibrary;
import org.spf4j.unix.JVMArguments;
import org.spf4j.unix.Lsof;
import org.spf4j.unix.UnixRuntime;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
public final class Runtime {
    public static final boolean IS_LITTLE_ENDIAN = "little".equals(System.getProperty("sun.cpu.endian"));
    public static final long WAIT_FOR_SHUTDOWN_NANOS = TimeUnit.MILLISECONDS.toNanos(Integer.getInteger("spf4j.waitForShutdownMillis", 30000).intValue());
    public static final String TMP_FOLDER = System.getProperty("java.io.tmpdir");
    public static final Path TMP_FOLDER_PATH = Paths.get(TMP_FOLDER, new String[0]);
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String USER_NAME = System.getProperty("user.name");
    public static final String USER_DIR = System.getProperty("user.dir");
    public static final String USER_HOME = System.getProperty("user.home");
    public static final String JAVA_HOME = System.getProperty("java.home");
    public static final int PID = ProcessUtil.getPid();
    public static final String PROCESS_NAME;
    public static final String OS_NAME;
    public static final String PROCESS_ID;
    public static final int NR_PROCESSORS;
    public static final Version JAVA_PLATFORM;
    private static final SortedMap<Integer, Set<Runnable>> SHUTDOWN_HOOKS;
    private static final List<Class<?>> PRELOADED;
    private static final java.lang.Runtime JAVA_RUNTIME;

    private Runtime() {
    }

    public static org.spf4j.base.Version getAppVersion() {
        return new org.spf4j.base.Version(Runtime.getAppVersionString());
    }

    public static String getAppVersionString() {
        Class<?> mainClass = Runtime.getMainClass();
        String version = mainClass.getPackage().getImplementationVersion();
        if (version == null) {
            return "N/A";
        }
        return version;
    }

    public static ApplicationInfo getApplicationInfo() {
        Class<?> mainClass = Runtime.getMainClass();
        if (mainClass == null) {
            try {
                return new ApplicationInfo("N/A", "N/A main class", new URL("file://manifest/Implementation-Url"), null);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
        Package p = mainClass.getPackage();
        if (p == null) {
            try {
                return new ApplicationInfo("N/A", "N/A package Info", new URL("file://manifest/Implementation-Url"), null);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
        URL jarSourceUrl = org.spf4j.base.PackageInfo.getJarSourceUrl(mainClass);
        String implementationTitle = p.getImplementationTitle();
        if (implementationTitle == null) {
            implementationTitle = "N/A manifest:Implementation-Title";
        }
        if (jarSourceUrl == null) {
            try {
                return new ApplicationInfo(implementationTitle, "N/A jar", new URL("file://manifest/Implementation-Url"), null);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            Manifest manifest = Reflections.getManifest(jarSourceUrl);
            if (manifest == null) {
                try {
                    return new ApplicationInfo(implementationTitle, "N/A jar manifest", new URL("file://manifest/Implementation-Url"), null);
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            String appDescription = mainAttributes.getValue("Implementation-Description");
            String appUrl = mainAttributes.getValue("Implementation-Url");
            String org = mainAttributes.getValue("Implementation-Org");
            String orgUrl = mainAttributes.getValue("Implementation-Org-Url");
            return new ApplicationInfo(implementationTitle, appDescription == null ? "" : appDescription, appUrl == null || appUrl.trim().isEmpty() ? new URL("file://manifest/Implementation-Url") : new URL(appUrl), org != null && !org.trim().isEmpty() ? new Organization(org, new URL(orgUrl == null || orgUrl.trim().isEmpty() ? "file://manifest/Implementation-Org-Url" : orgUrl)) : null);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean isShuttingDown() {
        try {
            java.lang.Runtime runtime = java.lang.Runtime.getRuntime();
            Thread dummy = new Thread(AbstractRunnable.NOP);
            runtime.addShutdownHook(dummy);
            runtime.removeShutdownHook(dummy);
        }
        catch (IllegalStateException e) {
            return true;
        }
        return false;
    }

    public static void error(String message) {
        System.err.println(message);
    }

    public static void error(String message, Throwable t) {
        System.err.println(message);
        Throwables.writeTo(t, System.err, Throwables.PackageDetail.SHORT);
    }

    public static void errorNoPackageDetail(String message, Throwable t) {
        System.err.println(message);
        Throwables.writeTo(t, System.err, Throwables.PackageDetail.NONE);
    }

    public static void goDownWithError(SysExits exitCode) {
        Runtime.goDownWithError(null, exitCode.exitCode());
    }

    public static void goDownWithError(@Nullable Throwable t, SysExits exitCode) {
        Runtime.goDownWithError(t, exitCode.exitCode());
    }

    @SuppressFBWarnings(value={"MDM_RUNTIME_EXIT_OR_HALT"})
    public static void goDownWithError(@Nullable Throwable t, int exitCode) {
        try {
            if (t != null) {
                Throwables.writeTo(t, System.err, Throwables.PackageDetail.NONE);
                Runtime.error("Error, going down with exit code " + exitCode, t);
                Logger logger = Logger.getLogger(Runtime.class.getName());
                logger.log(Level.SEVERE, "Error, going down with exit code {0}", exitCode);
                logger.log(Level.SEVERE, "Exception detail", t);
            } else {
                Runtime.error("Error, going down with exit code " + exitCode);
                Logger.getLogger(Runtime.class.getName()).log(Level.SEVERE, "Error, going down with exit code {0}", exitCode);
            }
        }
        finally {
            JAVA_RUNTIME.halt(exitCode);
        }
    }

    @Deprecated
    public static boolean isMacOsx() {
        return OperatingSystem.isMacOsx();
    }

    @Deprecated
    public static boolean isWindows() {
        return OperatingSystem.isWindows();
    }

    public static boolean isTestFramework() {
        StackTraceElement[][] stackTraces;
        for (StackTraceElement[] sts : stackTraces = Threads.getStackTraces(Threads.getThreads())) {
            if (sts == null) continue;
            for (StackTraceElement ste : sts) {
                String className = ste.getClassName();
                if (!className.startsWith("org.junit") && !className.startsWith("org.openjdk.jmh")) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean haveJnaPlatform() {
        return JNA.haveJnaPlatform();
    }

    @Deprecated
    public static boolean haveJnaPlatformClib() {
        return JNA.haveJnaPlatformClib();
    }

    @CheckReturnValue
    @Deprecated
    public static int getNrOpenFiles() {
        return (int)OperatingSystem.getOpenFileDescriptorCount();
    }

    @Nullable
    @CheckReturnValue
    @Deprecated
    public static CharSequence getLsofOutput() {
        return Lsof.getLsofOutput();
    }

    @Deprecated
    public static CharSequence run(String[] command, long timeoutMillis) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        return OperatingSystem.forkExec(command, timeoutMillis);
    }

    @Deprecated
    public static int killProcess(Process proc, long terminateTimeoutMillis, long forceTerminateTimeoutMillis) throws InterruptedException, TimeoutException {
        return OperatingSystem.killProcess(proc, terminateTimeoutMillis, forceTerminateTimeoutMillis);
    }

    public static int run(String[] command, ProcOutputHandler handler, long timeoutMillis) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        return Runtime.run(command, handler, timeoutMillis, 60000L);
    }

    @Deprecated
    @SuppressFBWarnings(value={"COMMAND_INJECTION"})
    public static int run(String[] command, final ProcOutputHandler handler, long timeoutMillis, long terminationTimeoutMillis) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        ProcessResponse<Void, Void> resp = OperatingSystem.forkExec(command, new ProcessHandler<Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void handleStdOut(InputStream is) throws IOException {
                byte[] buffer = ArraySuppliers.Bytes.TL_SUPPLIER.get(8192);
                try {
                    int cos;
                    while ((cos = is.read(buffer)) >= 0) {
                        handler.handleStdOut(buffer, cos);
                    }
                }
                finally {
                    ArraySuppliers.Bytes.TL_SUPPLIER.recycle(buffer);
                    handler.stdOutDone();
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void handleStdErr(InputStream stderr) throws IOException {
                byte[] buffer = ArraySuppliers.Bytes.TL_SUPPLIER.get(8192);
                try {
                    int cos;
                    while ((cos = stderr.read(buffer)) >= 0) {
                        handler.handleStdErr(buffer, cos);
                    }
                }
                finally {
                    ArraySuppliers.Bytes.TL_SUPPLIER.recycle(buffer);
                    handler.stdErrDone();
                }
                return null;
            }
        }, timeoutMillis, terminationTimeoutMillis);
        return resp.getResponseCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queueHookAtBeginning(Runnable runnable) {
        SortedMap<Integer, Set<Runnable>> sortedMap = SHUTDOWN_HOOKS;
        synchronized (sortedMap) {
            Runtime.queueHook(Integer.MIN_VALUE, runnable);
        }
    }

    public static void queueHookAtEnd(Runnable runnable) {
        Runtime.queueHook(Integer.MAX_VALUE, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queueHook(int priority, Runnable runnable) {
        SortedMap<Integer, Set<Runnable>> sortedMap = SHUTDOWN_HOOKS;
        synchronized (sortedMap) {
            Integer pr = priority;
            HashSet<Runnable> runnables = (HashSet<Runnable>)SHUTDOWN_HOOKS.get(pr);
            if (runnables == null) {
                runnables = new HashSet<Runnable>();
                SHUTDOWN_HOOKS.put(pr, runnables);
            }
            runnables.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeQueuedShutdownHook(Runnable runnable) {
        if ("spf4j queued shutdown".equals(Thread.currentThread().getName())) {
            return false;
        }
        SortedMap<Integer, Set<Runnable>> sortedMap = SHUTDOWN_HOOKS;
        synchronized (sortedMap) {
            for (Set<Runnable> entry : SHUTDOWN_HOOKS.values()) {
                if (!entry.remove(runnable)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static long getDeadline() {
        return Timing.getCurrentTiming().fromNanoTimeToEpochMillis(ExecutionContexts.getContextDeadlineNanos());
    }

    @Deprecated
    public static long millisToDeadline() throws TimeoutException {
        return ExecutionContexts.getTimeToDeadline(TimeUnit.MILLISECONDS);
    }

    @SuppressFBWarnings
    public static boolean gc(long timeoutMillis) {
        WeakReference<Object> ref = new WeakReference<Object>(new Object());
        long deadline = TimeSource.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeoutMillis);
        do {
            System.gc();
        } while (ref.get() != null && TimeSource.nanoTime() < deadline);
        return ref.get() == null;
    }

    public static CharSequence jrun(Class<?> classWithMain, long timeoutMillis, String ... arguments) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        String classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
        return Runtime.jrun(classWithMain, classPath, timeoutMillis, arguments);
    }

    public static CharSequence jrun(Class<?> classWithMain, String classPath, long timeoutMillis, String ... arguments) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String[] arr = Runtime.getJvmArgsNoJMXNoDebug();
        return Runtime.jrun(classWithMain, classPath, timeoutMillis, arr, arguments);
    }

    private static String[] getJvmArgsNoJMXNoDebug() {
        String[] arr;
        List<String> jvmInputArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
        if (jvmInputArgs.isEmpty()) {
            arr = Arrays.EMPTY_STRING_ARRAY;
        } else {
            JVMArguments inputArguments = new JVMArguments(jvmInputArgs);
            inputArguments.removeAllSystemPropertiesStartingWith("com.sun.management.jmxremote");
            inputArguments.removeVMArgumentStartingWith("-agentlib:jdwp");
            arr = inputArguments.toArray();
        }
        return arr;
    }

    public static synchronized void setCurrentDir(String sourceAbsolutePath) {
        if (Runtime.haveJnaPlatformClib()) {
            CLibrary.INSTANCE.chdir(sourceAbsolutePath);
        }
        System.setProperty("user.dir", sourceAbsolutePath);
    }

    public static synchronized String getCurrentDir() {
        return System.getProperty("user.dir");
    }

    public static CharSequence jrun(Class<?> classWithMain, String classPath, long timeoutMillis, String[] jvmArgs, String ... arguments) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String jvmPath = JAVA_HOME + File.separatorChar + "bin" + File.separatorChar + "java";
        String[] command = Arrays.concat({jvmPath}, jvmArgs, {"-cp", classPath, classWithMain.getName()}, arguments);
        return OperatingSystem.forkExec(command, timeoutMillis);
    }

    public static void jrunAndLog(Class<?> classWithMain, long timeoutMillis, String ... arguments) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        String classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
        Runtime.jrunAndLog(classWithMain, classPath, timeoutMillis, arguments);
    }

    public static void jrunAndLog(Class<?> classWithMain, String classPath, long timeoutMillis, String ... arguments) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String[] arr = Runtime.getJvmArgsNoJMXNoDebug();
        Runtime.jrun(classWithMain, classPath, timeoutMillis, arr, arguments);
    }

    public static void jrunAndLog(Class<?> classWithMain, String classPath, long timeoutMillis, String[] jvmArgs, String ... arguments) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String jvmPath = JAVA_HOME + File.separatorChar + "bin" + File.separatorChar + "java";
        String[] command = Arrays.concat({jvmPath}, jvmArgs, {"-cp", classPath, classWithMain.getName()}, arguments);
        OperatingSystem.forkExecLog(command, timeoutMillis);
    }

    @Nullable
    public static Thread getMainThread() {
        Thread[] threads;
        for (Thread t : threads = Threads.getThreads()) {
            if (t.getId() != 1L) continue;
            return t;
        }
        return null;
    }

    @Nullable
    public static Class<?> getMainClass() {
        return LazyMain.MAIN_CLASS;
    }

    static {
        OS_NAME = OperatingSystem.getOsName();
        SHUTDOWN_HOOKS = new TreeMap<Integer, Set<Runnable>>();
        PRELOADED = new ArrayList(2);
        JAVA_RUNTIME = java.lang.Runtime.getRuntime();
        try (PrintStream stream = new PrintStream((OutputStream)new ByteArrayBuilder(), false, "UTF-8");){
            RuntimeException rex = new RuntimeException("priming");
            Throwables.writeTo((Throwable)rex, stream, Throwables.PackageDetail.NONE);
            Throwables.containsNonRecoverable(rex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new ExceptionInInitializerError(ex);
        }
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        int availableProcessors = JAVA_RUNTIME.availableProcessors();
        if (availableProcessors <= 0) {
            Runtime.error("Invalid number of processors " + availableProcessors + " defaulting to 1");
            NR_PROCESSORS = 1;
        } else {
            NR_PROCESSORS = availableProcessors;
        }
        String mxBeanName = runtimeMxBean.getName();
        PROCESS_NAME = System.getProperty("spf4j.processName", mxBeanName);
        boolean useUIDGeneratorForJvmId = Boolean.getBoolean("spf4j.useUIDForProcessId");
        PROCESS_ID = useUIDGeneratorForJvmId ? UIDGenerator.generateIdBase("J", '-').toString() : mxBeanName + ':' + Long.toHexString((System.currentTimeMillis() - 1509741164184L) / 1000L);
        boolean dumpNonDaemonThreadInfoOnShutdown = Boolean.getBoolean("spf4j.dumpNonDaemonThreadInfoOnShutdown");
        if (dumpNonDaemonThreadInfoOnShutdown) {
            PRELOADED.add(Threads.class);
        }
        JAVA_RUNTIME.addShutdownHook(new Thread((Runnable)new ShutdownRunnable(false, dumpNonDaemonThreadInfoOnShutdown), "spf4j queued shutdown"));
        JAVA_PLATFORM = Version.fromSpecVersion(JAVA_VERSION);
        if (Boolean.getBoolean("spf4j.runtime.jmx")) {
            Registry.export(Jmx.class);
        }
    }

    private static class ShutdownRunnable
    extends AbstractRunnable {
        private final boolean dumpNonDaemonThreadInfoOnShutdown;

        ShutdownRunnable(boolean lenient, boolean dumpNonDaemonThreadInfoOnShutdown) {
            super(lenient);
            this.dumpNonDaemonThreadInfoOnShutdown = dumpNonDaemonThreadInfoOnShutdown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void doRun() throws Exception {
            TreeMap hooks;
            Exception rex = null;
            SortedMap sortedMap = SHUTDOWN_HOOKS;
            synchronized (sortedMap) {
                hooks = new TreeMap(SHUTDOWN_HOOKS);
                for (Map.Entry entry : hooks.entrySet()) {
                    entry.setValue(new HashSet((Collection)entry.getValue()));
                }
            }
            block11: for (Map.Entry entry : hooks.entrySet()) {
                Set set = (Set)entry.getValue();
                if (set.size() <= 1) {
                    for (Runnable runnable : set) {
                        try {
                            runnable.run();
                        }
                        catch (RuntimeException runtimeException) {
                            if (rex == null) {
                                rex = runtimeException;
                                continue;
                            }
                            rex.addSuppressed(runtimeException);
                        }
                    }
                    continue;
                }
                if ((Integer)entry.getKey() >= Integer.MAX_VALUE) {
                    Thread[] threads = new Thread[set.size()];
                    int i = 0;
                    for (Runnable runnable : set) {
                        Thread thread = new Thread(runnable);
                        thread.start();
                        threads[i++] = thread;
                    }
                    long l = TimeSource.nanoTime() + WAIT_FOR_SHUTDOWN_NANOS;
                    for (Thread thread : threads) {
                        try {
                            thread.join(TimeUnit.NANOSECONDS.toMillis(l - TimeSource.nanoTime()));
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                            if (rex == null) {
                                rex = ex;
                                continue block11;
                            }
                            rex.addSuppressed(ex);
                            continue block11;
                        }
                    }
                    continue;
                }
                ArrayList futures = new ArrayList(set.size());
                for (Runnable runnable : set) {
                    futures.add(DefaultExecutor.INSTANCE.submit(runnable));
                }
                for (Future future : futures) {
                    try {
                        future.get();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        if (rex == null) {
                            rex = ex;
                            continue block11;
                        }
                        rex.addSuppressed(ex);
                        continue block11;
                    }
                    catch (RuntimeException | ExecutionException ex) {
                        if (rex == null) {
                            rex = ex;
                            continue;
                        }
                        rex.addSuppressed(ex);
                    }
                }
            }
            if (this.dumpNonDaemonThreadInfoOnShutdown) {
                void var8_25;
                Thread[] threads = Threads.getThreads();
                Thread thread = Thread.currentThread();
                boolean bl = true;
                Thread[] threadArray = threads;
                int n = threadArray.length;
                boolean bl2 = false;
                while (var8_25 < n) {
                    Object thread2 = threadArray[var8_25];
                    if (((Thread)thread2).isAlive() && !((Thread)thread2).isDaemon() && !thread2.equals(thread) && !((Thread)thread2).getName().contains("DestroyJavaVM")) {
                        boolean bl3;
                        if (bl3) {
                            Runtime.error("Non daemon threads still running:");
                            bl3 = false;
                        }
                        Runtime.error("Non daemon thread " + thread2 + ", stackTrace = " + java.util.Arrays.toString(((Thread)thread2).getStackTrace()));
                    }
                    ++var8_25;
                }
            }
            if (rex != null) {
                throw rex;
            }
        }
    }

    public static final class Jmx {
        @JmxExport
        public static PackageInfo getPackageInfo(@JmxExport(value="className") String className) {
            return org.spf4j.base.PackageInfo.getPackageInfo(className);
        }

        @JmxExport
        public static void restart() throws IOException {
            UnixRuntime.restart();
        }
    }

    private static class LazyMain {
        private static final Class<?> MAIN_CLASS = LazyMain.getMainClass();

        private LazyMain() {
        }

        @Nullable
        private static Class<?> getMainClass() {
            Thread mainThread = Runtime.getMainThread();
            if (mainThread == null) {
                return null;
            }
            StackTraceElement[] stackTrace = mainThread.getStackTrace();
            if (stackTrace.length == 0) {
                return null;
            }
            String className = stackTrace[stackTrace.length - 1].getClassName();
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                NoClassDefFoundError tex = new NoClassDefFoundError("Cannot find " + className);
                tex.initCause(ex);
                throw tex;
            }
        }
    }

    @Deprecated
    public static interface ProcOutputHandler {
        public void handleStdOut(byte[] var1, int var2);

        public void stdOutDone();

        public void handleStdErr(byte[] var1, int var2);

        public void stdErrDone();
    }

    public static enum Version {
        V1_0,
        V1_1,
        V1_2,
        V1_3,
        V1_4,
        V1_5,
        V1_6,
        V1_7,
        V1_8,
        V1_9,
        V_10,
        V_11,
        V_12;


        @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
        public static Version fromSpecVersion(String specVersion) {
            String[] cmpnts = specVersion.split("\\.");
            if (cmpnts.length > 1) {
                return Version.values()[Integer.parseInt(cmpnts[1])];
            }
            if (cmpnts.length == 1) {
                return Version.values()[Integer.parseInt(cmpnts[0])];
            }
            throw new IllegalArgumentException("Unsupported specVersion: " + specVersion);
        }
    }
}

