/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.set.hash.THashSet;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nonnull;
import org.spf4j.base.Throwables;
import org.spf4j.io.ObjectAppenderSupplier;

public final class Slf4jMessageFormatter {
    private static final char DELIM_START = '{';
    private static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    private Slf4jMessageFormatter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exHandle(Object obj, Appendable sbuf, Throwable t) throws IOException {
        String className = obj.getClass().getName();
        PrintStream printStream = System.err;
        synchronized (printStream) {
            System.err.print("SPF4J: Failed toString() invocation on an object of type [");
            System.err.print(className);
            System.err.println(']');
        }
        Throwables.writeTo(t, System.err, Throwables.PackageDetail.SHORT);
        sbuf.append("[FAILED toString() for ");
        sbuf.append(className);
        sbuf.append(']');
    }

    public static String toString(@Nonnull String messagePattern, Object ... argArray) {
        StringBuilder sb = new StringBuilder(messagePattern.length() + argArray.length * 8);
        try {
            int nrUsed = Slf4jMessageFormatter.format((Appendable)sb, messagePattern, argArray);
            if (nrUsed != argArray.length) {
                throw new IllegalArgumentException("Invalid format " + messagePattern + ", params " + Arrays.toString(argArray));
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return sb.toString();
    }

    public static int format(@Nonnull Appendable to, @Nonnull String messagePattern, Object ... argArray) throws IOException {
        return Slf4jMessageFormatter.format(to, messagePattern, ObjectAppenderSupplier.TO_STRINGER, argArray);
    }

    public static int format(@Nonnull Appendable to, @Nonnull ObjectAppenderSupplier appSupplier, @Nonnull String messagePattern, Object ... argArray) throws IOException {
        return Slf4jMessageFormatter.format(to, messagePattern, appSupplier, argArray);
    }

    public static int format(@Nonnull Appendable to, @Nonnull String messagePattern, @Nonnull ObjectAppenderSupplier appSupplier, Object ... argArray) throws IOException {
        return Slf4jMessageFormatter.format(0, to, messagePattern, appSupplier, argArray);
    }

    public static int format(int firstArgIdx, @Nonnull Appendable to, @Nonnull String messagePattern, @Nonnull ObjectAppenderSupplier appSupplier, Object ... argArray) throws IOException {
        return Slf4jMessageFormatter.format(Slf4jMessageFormatter::exHandle, firstArgIdx, to, messagePattern, appSupplier, argArray);
    }

    public static int format(ErrorHandler exHandler, int firstArgIdx, @Nonnull Appendable to, @Nonnull String messagePattern, @Nonnull ObjectAppenderSupplier appSupplier, Object ... argArray) throws IOException {
        int j;
        int k;
        int i = 0;
        int len = argArray.length;
        for (k = firstArgIdx; k < len && (j = messagePattern.indexOf(DELIM_STR, i)) != -1; ++k) {
            if (Slf4jMessageFormatter.isEscapedDelimeter(messagePattern, j)) {
                if (!Slf4jMessageFormatter.isDoubleEscaped(messagePattern, j)) {
                    --k;
                    to.append(messagePattern, i, j - 1);
                    to.append('{');
                    i = j + 1;
                    continue;
                }
                to.append(messagePattern, i, j - 1);
                Slf4jMessageFormatter.deeplyAppendParameter(exHandler, to, argArray[k], (Set<Object[]>)new THashSet(), appSupplier);
                i = j + 2;
                continue;
            }
            to.append(messagePattern, i, j);
            Slf4jMessageFormatter.deeplyAppendParameter(exHandler, to, argArray[k], (Set<Object[]>)new THashSet(), appSupplier);
            i = j + 2;
        }
        to.append(messagePattern, i, messagePattern.length());
        return k;
    }

    private static boolean isEscapedDelimeter(String messagePattern, int delimeterStartIndex) {
        if (delimeterStartIndex == 0) {
            return false;
        }
        return messagePattern.charAt(delimeterStartIndex - 1) == '\\';
    }

    private static boolean isDoubleEscaped(String messagePattern, int delimeterStartIndex) {
        return delimeterStartIndex >= 2 && messagePattern.charAt(delimeterStartIndex - 2) == '\\';
    }

    @SuppressFBWarnings(value={"ITC_INHERITANCE_TYPE_CHECKING"})
    private static void deeplyAppendParameter(ErrorHandler exHandler, Appendable sbuf, Object o, Set<Object[]> seen, ObjectAppenderSupplier appSupplier) throws IOException {
        if (o == null) {
            sbuf.append("null");
            return;
        }
        if (!o.getClass().isArray()) {
            Slf4jMessageFormatter.safeObjectAppend(exHandler, sbuf, o, appSupplier);
        } else if (o instanceof boolean[]) {
            Slf4jMessageFormatter.booleanArrayAppend(sbuf, (boolean[])o);
        } else if (o instanceof byte[]) {
            Slf4jMessageFormatter.byteArrayAppend(sbuf, (byte[])o);
        } else if (o instanceof char[]) {
            Slf4jMessageFormatter.charArrayAppend(sbuf, (char[])o);
        } else if (o instanceof short[]) {
            Slf4jMessageFormatter.shortArrayAppend(sbuf, (short[])o);
        } else if (o instanceof int[]) {
            Slf4jMessageFormatter.intArrayAppend(sbuf, (int[])o);
        } else if (o instanceof long[]) {
            Slf4jMessageFormatter.longArrayAppend(sbuf, (long[])o);
        } else if (o instanceof float[]) {
            Slf4jMessageFormatter.floatArrayAppend(sbuf, (float[])o);
        } else if (o instanceof double[]) {
            Slf4jMessageFormatter.doubleArrayAppend(sbuf, (double[])o);
        } else {
            Slf4jMessageFormatter.objectArrayAppend(exHandler, sbuf, (Object[])o, seen, appSupplier);
        }
    }

    public static void safeObjectAppend(ErrorHandler exHandler, Appendable sbuf, Object obj, ObjectAppenderSupplier appSupplier) throws IOException {
        try {
            appSupplier.get(obj.getClass()).append(obj, sbuf, appSupplier);
        }
        catch (IOException | RuntimeException | StackOverflowError t) {
            exHandler.accept(obj, sbuf, t);
        }
    }

    @SuppressFBWarnings(value={"ABC_ARRAY_BASED_COLLECTIONS"})
    private static void objectArrayAppend(ErrorHandler exHandler, Appendable sbuf, Object[] a, Set<Object[]> seen, ObjectAppenderSupplier appSupplier) throws IOException {
        sbuf.append('[');
        if (seen.add(a)) {
            int len = a.length;
            if (len > 0) {
                Slf4jMessageFormatter.deeplyAppendParameter(exHandler, sbuf, a[0], seen, appSupplier);
                for (int i = 1; i < len; ++i) {
                    sbuf.append(", ");
                    Slf4jMessageFormatter.deeplyAppendParameter(exHandler, sbuf, a[i], seen, appSupplier);
                }
            }
            seen.remove(a);
        } else {
            sbuf.append("...");
        }
        sbuf.append(']');
    }

    private static void booleanArrayAppend(Appendable sbuf, boolean[] a) throws IOException {
        sbuf.append('[');
        int len = a.length;
        if (len > 0) {
            sbuf.append(Boolean.toString(a[0]));
            for (int i = 1; i < len; ++i) {
                sbuf.append(", ");
                sbuf.append(Boolean.toString(a[i]));
            }
        }
        sbuf.append(']');
    }

    private static void byteArrayAppend(Appendable sbuf, byte[] a) throws IOException {
        sbuf.append('[');
        int len = a.length;
        if (len > 0) {
            sbuf.append(Byte.toString(a[0]));
            for (int i = 1; i < len; ++i) {
                sbuf.append(", ");
                sbuf.append(Byte.toString(a[i]));
            }
        }
        sbuf.append(']');
    }

    private static void charArrayAppend(Appendable sbuf, char[] a) throws IOException {
        sbuf.append('[');
        int len = a.length;
        if (len > 0) {
            sbuf.append(a[0]);
            for (int i = 1; i < len; ++i) {
                sbuf.append(", ");
                sbuf.append(a[i]);
            }
        }
        sbuf.append(']');
    }

    private static void shortArrayAppend(Appendable sbuf, short[] a) throws IOException {
        sbuf.append('[');
        int len = a.length;
        if (len > 0) {
            sbuf.append(Short.toString(a[0]));
            for (int i = 1; i < len; ++i) {
                sbuf.append(", ");
                sbuf.append(Short.toString(a[i]));
            }
        }
        sbuf.append(']');
    }

    private static void intArrayAppend(Appendable sbuf, int[] a) throws IOException {
        sbuf.append('[');
        int len = a.length;
        if (len > 0) {
            sbuf.append(Integer.toString(a[0]));
            for (int i = 1; i < len; ++i) {
                sbuf.append(", ");
                sbuf.append(Integer.toString(a[i]));
            }
        }
        sbuf.append(']');
    }

    private static void longArrayAppend(Appendable sbuf, long[] a) throws IOException {
        sbuf.append('[');
        int len = a.length;
        if (len > 0) {
            sbuf.append(Long.toString(a[0]));
            for (int i = 1; i < len; ++i) {
                sbuf.append(", ");
                sbuf.append(Long.toString(a[i]));
            }
        }
        sbuf.append(']');
    }

    private static void floatArrayAppend(Appendable sbuf, float[] a) throws IOException {
        sbuf.append('[');
        int len = a.length;
        if (len > 0) {
            sbuf.append(Float.toString(a[0]));
            for (int i = 1; i < len; ++i) {
                sbuf.append(", ");
                sbuf.append(Float.toString(a[i]));
            }
        }
        sbuf.append(']');
    }

    private static void doubleArrayAppend(Appendable sbuf, double[] a) throws IOException {
        sbuf.append('[');
        int len = a.length;
        if (len > 0) {
            sbuf.append(Double.toString(a[0]));
            for (int i = 1; i < len; ++i) {
                sbuf.append(", ");
                sbuf.append(Double.toString(a[i]));
            }
        }
        sbuf.append(']');
    }

    public static interface ErrorHandler {
        public void accept(Object var1, Appendable var2, Throwable var3) throws IOException;
    }
}

