/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import javax.annotation.Nonnull;

public enum SysExits {
    OK(0),
    EX_GENERAL(1),
    EX_SHELL_BUILTIN_MISSUSE(2),
    EX_USAGE(64),
    EX_DATAERR(65),
    EX_NOINPUT(66),
    EX_NOUSER(67),
    EX_NOHOST(68),
    EX_UNAVAILABLE(69),
    EX_SOFTWARE(70),
    EX_OSERR(71),
    EX_OSFILE(72),
    EX_CANTCREAT(73),
    EX_IOERR(74),
    EX_TEMPFAIL(75),
    EX_PROTOCOL(76),
    EX_NOPERM(77),
    EX_CONFIG(78),
    EX_CANNOT_EXEC_CMD(126),
    EX_CMD_NOT_FOUND(127),
    EX_INVALID_ARG_TO_EXIT(128),
    EX_SIG_HUP(129),
    EX_SIG_INT(130),
    EX_SIG_QUIT(131),
    EX_SIG_ILL(132),
    EX_SIG_TRAP(133),
    EX_SIG_ABRT(134),
    EX_SIG_7(135),
    EX_SIG_FPE(136),
    EX_SIG_KILL(137),
    EX_SIG_10(138),
    EX_SIG_11(139),
    EX_SIG_12(140),
    EX_SIG_PIPE(141),
    EX_SIG_ALRM(142),
    EX_SIG_TERM(143),
    EX_SIG_16(144),
    EX_SIG_17(145),
    EX_SIG_18(146),
    EX_SIG_19(147),
    EX_SIG_20(148),
    EX_SIG_21(149),
    EX_SIG_22(150),
    EX_SIG_23(151),
    EX_SIG_24(152),
    EX_SIG_25(153),
    EX_SIG_26(154),
    EX_SIG_27(155),
    EX_SIG_28(156),
    EX_SIG_29(157),
    EX_SIG_30(158),
    EX_SIG_31(159),
    EX_STATUS_OUT_OF_RANGE(255),
    EX_UNKNOWN(-1);

    private static final TIntObjectMap<SysExits> CODE2ENUM;
    private final int exitCode;

    private SysExits(int code) {
        this.exitCode = code;
    }

    public int exitCode() {
        return this.exitCode;
    }

    public boolean isOk() {
        return this.exitCode == 0;
    }

    public boolean isError() {
        return this.exitCode != 0;
    }

    @Nonnull
    public static SysExits fromCode(int exitCode) {
        SysExits result = (SysExits)((Object)CODE2ENUM.get(exitCode));
        if (result == null) {
            return EX_UNKNOWN;
        }
        return result;
    }

    static {
        SysExits[] values = SysExits.values();
        TIntObjectHashMap c2e = new TIntObjectHashMap(values.length);
        for (SysExits e : values) {
            if (c2e.put(e.exitCode(), (Object)e) == null) continue;
            throw new ExceptionInInitializerError("Duplicate exit code " + (Object)((Object)e));
        }
        CODE2ENUM = c2e;
    }
}

