/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;

public final class TLScratch {
    private static final int MAX_LOCAL_ARRAY_SIZE = Integer.getInteger("spf4j.TLScratch.maxLocalArraySize", 262144);
    private static final ThreadLocal<Reference<byte[]>> BYTES_TMP = new ThreadLocal();
    private static final ThreadLocal<Reference<char[]>> CHARS_TMP = new ThreadLocal();

    private TLScratch() {
    }

    public static byte[] getBytesTmp(int size) {
        byte[] result;
        if (size > MAX_LOCAL_ARRAY_SIZE) {
            return new byte[size];
        }
        Reference<byte[]> sr = BYTES_TMP.get();
        if (sr == null) {
            result = new byte[size];
            BYTES_TMP.set(new SoftReference<byte[]>(result));
        } else {
            result = sr.get();
            if (result == null || result.length < size) {
                result = new byte[size];
                BYTES_TMP.set(new SoftReference<byte[]>(result));
            }
        }
        return result;
    }

    @SuppressFBWarnings(value={"SUA_SUSPICIOUS_UNINITIALIZED_ARRAY"})
    public static char[] getCharsTmp(int size) {
        char[] result;
        if (size > MAX_LOCAL_ARRAY_SIZE) {
            return new char[size];
        }
        Reference<char[]> sr = CHARS_TMP.get();
        if (sr == null) {
            result = new char[size];
            CHARS_TMP.set(new SoftReference<char[]>(result));
        } else {
            result = sr.get();
            if (result == null || result.length < size) {
                result = new char[size];
                CHARS_TMP.set(new SoftReference<char[]>(result));
            }
        }
        return result;
    }
}

