/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.spf4j.base.Arrays;
import org.spf4j.base.Throwables;
import org.spf4j.base.UncheckedExecutionException;

public final class Threads {
    public static final Thread[] EMPTY_ARRAY;
    private static final ThreadInfoSupplier TI_SUPP;

    private Threads() {
    }

    public static Thread[] getThreads() {
        return TI_SUPP.getThreads();
    }

    @SuppressFBWarnings(value={"PREDICTABLE_RANDOM"})
    public static int randomFirst(int nr, Thread[] threads) {
        int length = threads.length;
        if (nr >= length) {
            return length;
        }
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        for (int i = 0; i < nr; ++i) {
            int nextInt = rnd.nextInt(i, length);
            if (nextInt == i) continue;
            Thread t = threads[i];
            threads[i] = threads[nextInt];
            threads[nextInt] = t;
        }
        Arrays.fill(threads, nr, length, null);
        return nr;
    }

    public static StackTraceElement[][] getStackTraces(Thread ... threads) {
        return TI_SUPP.getStackTraces(threads);
    }

    public static void dumpTo(Appendable stream) throws IOException {
        Thread[] threads = Threads.getThreads();
        StackTraceElement[][] stackTraces = Threads.getStackTraces(threads);
        for (int i = 0; i < threads.length; ++i) {
            StackTraceElement[] stackTrace = stackTraces[i];
            if (stackTrace == null || stackTrace.length <= 0) continue;
            Thread thread = threads[i];
            stream.append("Thread ").append(thread.getName()).append('\n');
            Throwables.writeTo(stackTrace, stream, Throwables.PackageDetail.SHORT, true);
        }
    }

    public static void dumpToPrintStream(PrintStream stream) {
        StringBuilder sb = new StringBuilder(1024);
        try {
            Threads.dumpTo(sb);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        stream.append(sb);
    }

    static {
        ThreadInfoSupplier supp;
        EMPTY_ARRAY = new Thread[0];
        try {
            supp = new OracleJdkThreadInfoSupplier();
        }
        catch (ExceptionInInitializerError ex) {
            Logger logger = Logger.getLogger(Threads.class.getName());
            logger.warning("Optimized stack trace access not available, profiling overhead will be higher");
            logger.log(Level.FINE, "Exception detail", ex);
            supp = new SlowThreadInfoSupplierImpl();
        }
        TI_SUPP = supp;
    }

    private static class SlowThreadInfoSupplierImpl
    implements ThreadInfoSupplier {
        private SlowThreadInfoSupplierImpl() {
        }

        @Override
        public Thread[] getThreads() {
            Set<Thread> keySet = Thread.getAllStackTraces().keySet();
            return keySet.toArray(new Thread[keySet.size()]);
        }

        @Override
        public StackTraceElement[][] getStackTraces(Thread ... threads) {
            Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
            StackTraceElement[][] result = new StackTraceElement[threads.length][];
            for (int i = 0; i < threads.length; ++i) {
                result[i] = allStackTraces.get(threads[i]);
            }
            return result;
        }
    }

    private static class OracleJdkThreadInfoSupplier
    implements ThreadInfoSupplier {
        private static final MethodHandle GET_THREADS;
        private static final MethodHandle DUMP_THREADS;

        private OracleJdkThreadInfoSupplier() {
        }

        @Override
        @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CHECKED"})
        public Thread[] getThreads() {
            try {
                return GET_THREADS.invokeExact();
            }
            catch (Error | RuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new UncheckedExecutionException(ex);
            }
        }

        @Override
        @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CHECKED"})
        public StackTraceElement[][] getStackTraces(Thread ... threads) {
            StackTraceElement[][] stackDump;
            try {
                stackDump = DUMP_THREADS.invokeExact(threads);
            }
            catch (Error | RuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new UncheckedExecutionException(ex);
            }
            return stackDump;
        }

        static {
            Method dumpThreads;
            Method getThreads;
            try {
                getThreads = Thread.class.getDeclaredMethod("getThreads", new Class[0]);
                dumpThreads = Thread.class.getDeclaredMethod("dumpThreads", Thread[].class);
            }
            catch (NoSuchMethodException ex) {
                throw new ExceptionInInitializerError(ex);
            }
            AccessController.doPrivileged(() -> {
                getThreads.setAccessible(true);
                dumpThreads.setAccessible(true);
                return null;
            });
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            try {
                GET_THREADS = lookup.unreflect(getThreads);
                DUMP_THREADS = lookup.unreflect(dumpThreads);
            }
            catch (IllegalAccessException ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }
    }

    static interface ThreadInfoSupplier {
        public Thread[] getThreads();

        public StackTraceElement[][] getStackTraces(Thread ... var1);
    }
}

