/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLRecoverableException;
import java.sql.SQLTransientException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.net.ssl.SSLException;
import org.spf4j.base.CloneFailedException;
import org.spf4j.base.Objects;
import org.spf4j.base.avro.AThrowables;
import org.spf4j.base.avro.PackageInfo;
import org.spf4j.base.avro.RemoteException;
import org.spf4j.ds.IdentityHashSet;

@ParametersAreNonnullByDefault
@SuppressFBWarnings(value={"FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY"})
public final class Throwables {
    public static final String SUPPRESSED_CAPTION = "Suppressed: ";
    public static final String CAUSE_CAPTION = "Caused by: ";
    private static final int MAX_SUPPRESS_CHAIN = Integer.getInteger("spf4j.throwables.defaultMaxSuppressChain", 100);
    private static final Field CAUSE_FIELD = AccessController.doPrivileged(() -> {
        Field causeField;
        try {
            causeField = Throwable.class.getDeclaredField("cause");
        }
        catch (NoSuchFieldException | SecurityException ex) {
            throw new ExceptionInInitializerError(ex);
        }
        causeField.setAccessible(true);
        return causeField;
    });
    private static final Field SUPPRESSED_FIELD = AccessController.doPrivileged(() -> {
        Field suppressedField;
        try {
            suppressedField = Throwable.class.getDeclaredField("suppressedExceptions");
        }
        catch (NoSuchFieldException | SecurityException ex) {
            throw new ExceptionInInitializerError(ex);
        }
        suppressedField.setAccessible(true);
        return suppressedField;
    });
    private static final PackageDetail DEFAULT_PACKAGE_DETAIL = PackageDetail.valueOf(System.getProperty("spf4j.throwables.defaultStackTracePackageDetail", "SHORT"));
    private static final boolean DEFAULT_TRACE_ELEMENT_ABBREVIATION = Boolean.parseBoolean(System.getProperty("spf4j.throwables.defaultStackTraceAbbreviation", "true"));
    private static volatile Predicate<Throwable> nonRecoverableClassificationPredicate = new Predicate<Throwable>(){

        @Override
        @SuppressFBWarnings(value={"ITC_INHERITANCE_TYPE_CHECKING"})
        public boolean test(Throwable t) {
            String message;
            if (t instanceof Error && !(t instanceof StackOverflowError) && !(t instanceof AssertionError) && !t.getClass().getName().endsWith("TokenMgrError")) {
                return true;
            }
            return t instanceof IOException && (message = t.getMessage()) != null && message.contains("Too many open files");
        }
    };
    private static volatile Predicate<Throwable> isRetryablePredicate = new Predicate<Throwable>(){

        @Override
        @SuppressFBWarnings(value={"ITC_INHERITANCE_TYPE_CHECKING"})
        public boolean test(Throwable t) {
            String name;
            if (Throwables.containsNonRecoverable(t)) {
                return false;
            }
            Throwable rootCause = com.google.common.base.Throwables.getRootCause((Throwable)t);
            if (rootCause instanceof SSLException) {
                return false;
            }
            if (rootCause instanceof RuntimeException && ((name = rootCause.getClass().getName()).contains("NonTransient") || !name.contains("Transient"))) {
                return false;
            }
            Throwable e = Throwables.firstCause(t, ex -> {
                String exClassName = ex.getClass().getName();
                return ex instanceof SQLTransientException || ex instanceof SQLRecoverableException || ex instanceof IOException && !exClassName.contains("Json") || ex instanceof TimeoutException || exClassName.contains("Transient") && !exClassName.contains("NonTransient");
            });
            return e != null;
        }
    };

    private Throwables() {
    }

    public static boolean isRetryable(Throwable value) {
        return isRetryablePredicate.test(value);
    }

    public static Predicate<Throwable> getIsRetryablePredicate() {
        return isRetryablePredicate;
    }

    public static void setIsRetryablePredicate(Predicate<Throwable> isRetryablePredicate) {
        Throwables.isRetryablePredicate = isRetryablePredicate;
    }

    public static int getNrSuppressedExceptions(Throwable t) {
        try {
            List suppressedExceptions = (List)SUPPRESSED_FIELD.get(t);
            if (suppressedExceptions != null) {
                return suppressedExceptions.size();
            }
            return 0;
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static int getNrRecursiveSuppressedExceptions(Throwable t) {
        try {
            List suppressedExceptions = (List)SUPPRESSED_FIELD.get(t);
            if (suppressedExceptions != null) {
                int count = 0;
                for (Throwable se : suppressedExceptions) {
                    count += 1 + Throwables.getNrRecursiveSuppressedExceptions(se);
                }
                return count;
            }
            return 0;
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Nullable
    public static Throwable removeOldestSuppressedRecursive(Throwable t) {
        try {
            List suppressedExceptions = (List)SUPPRESSED_FIELD.get(t);
            if (suppressedExceptions != null && !suppressedExceptions.isEmpty()) {
                Throwable ex = (Throwable)suppressedExceptions.get(0);
                if (Throwables.getNrSuppressedExceptions(ex) > 0) {
                    return Throwables.removeOldestSuppressedRecursive(ex);
                }
                return (Throwable)suppressedExceptions.remove(0);
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Nullable
    public static Throwable removeOldestSuppressed(Throwable t) {
        try {
            List suppressedExceptions = (List)SUPPRESSED_FIELD.get(t);
            if (suppressedExceptions != null && !suppressedExceptions.isEmpty()) {
                return (Throwable)suppressedExceptions.remove(0);
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void chain0(Throwable t, Throwable cause) {
        Throwable rc = com.google.common.base.Throwables.getRootCause((Throwable)t);
        Throwables.setCause(rc, cause);
    }

    private static void setCause(final Throwable rc, final @Nullable Throwable cause) {
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        CAUSE_FIELD.set(rc, cause);
                    }
                    catch (IllegalAccessException | IllegalArgumentException ex) {
                        throw new RuntimeException(ex);
                    }
                    return null;
                }
            });
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T extends Throwable> T chain(T t, Throwable newRootCause) {
        return Throwables.chain(t, newRootCause, MAX_SUPPRESS_CHAIN);
    }

    public static <T extends Throwable> T chain(T t, Throwable newRootCause, int maxChained) {
        int chainedExNr = com.google.common.base.Throwables.getCausalChain(t).size();
        if (chainedExNr > maxChained) {
            T res = Throwables.clone0(t);
            Throwables.trimCausalChain(res, maxChained);
            return res;
        }
        T result = Throwables.clone0(t);
        Throwables.chain0(result, newRootCause);
        Throwables.trimCausalChain(result, maxChained);
        return result;
    }

    public static void setRootCause(Throwable t, Throwable newRootCause) {
        Throwables.setRootCause(t, newRootCause, MAX_SUPPRESS_CHAIN);
    }

    public static void setRootCause(Throwable t, Throwable newRootCause, int maxChained) {
        int chainedExNr = com.google.common.base.Throwables.getCausalChain((Throwable)t).size();
        if (chainedExNr > maxChained) {
            Throwables.trimCausalChain(t, maxChained);
            return;
        }
        Throwables.chain0(t, newRootCause);
        Throwables.trimCausalChain(t, maxChained);
    }

    private static <T extends Throwable> T clone0(T t) {
        T result;
        try {
            result = Objects.clone(t);
        }
        catch (RuntimeException ex) {
            result = t;
            t.addSuppressed(new CloneFailedException("Unable to clone exception " + t));
        }
        return result;
    }

    public static void trimCausalChain(Throwable t, int maxSize) {
        List causalChain = com.google.common.base.Throwables.getCausalChain((Throwable)t);
        if (causalChain.size() <= maxSize) {
            return;
        }
        int lastExIdx = maxSize - 1;
        if (lastExIdx >= 0) {
            Throwables.setCause((Throwable)causalChain.get(lastExIdx), new TrimmedException("Trimmed after " + maxSize + " exceptions"));
        }
    }

    @CheckReturnValue
    @Deprecated
    public static <T extends Throwable> T suppress(@Nonnull T t, @Nonnull Throwable suppressed) {
        return Throwables.suppress(t, suppressed, MAX_SUPPRESS_CHAIN);
    }

    public static void suppressLimited(@Nonnull Throwable t, @Nonnull Throwable suppressed) {
        Throwables.suppressLimited(t, suppressed, MAX_SUPPRESS_CHAIN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NOS_NON_OWNED_SYNCHRONIZATION"})
    public static void suppressLimited(@Nonnull Throwable t, @Nonnull Throwable suppressed, int maxSuppressed) {
        if (Throwables.contains(t, suppressed)) {
            Logger.getLogger(Throwables.class.getName()).log(Level.INFO, "Circular suppression attempted", new RuntimeException(suppressed));
            return;
        }
        Throwable throwable = t;
        synchronized (throwable) {
            t.addSuppressed(suppressed);
            while (Throwables.getNrRecursiveSuppressedExceptions(t) > maxSuppressed) {
                if (Throwables.removeOldestSuppressedRecursive(t) != null) continue;
                throw new IllegalArgumentException("Impossible state for " + t);
            }
        }
    }

    @CheckReturnValue
    public static <T extends Throwable> T suppress(@Nonnull T t, @Nonnull Throwable suppressed, int maxSuppressed) {
        T clone;
        try {
            clone = Objects.clone(t);
        }
        catch (RuntimeException ex) {
            t.addSuppressed(ex);
            clone = t;
        }
        if (Throwables.contains(t, suppressed)) {
            return clone;
        }
        clone.addSuppressed(suppressed);
        while (Throwables.getNrRecursiveSuppressedExceptions(clone) > maxSuppressed) {
            if (Throwables.removeOldestSuppressedRecursive(clone) != null) continue;
            throw new IllegalArgumentException("Impossible state for " + clone);
        }
        return clone;
    }

    public static Throwable[] getSuppressed(Throwable t) {
        if (t instanceof Iterable) {
            ArrayList<Throwable> suppressed = new ArrayList<Throwable>(Arrays.asList(t.getSuppressed()));
            IdentityHashSet ignore = new IdentityHashSet();
            ignore.addAll(com.google.common.base.Throwables.getCausalChain((Throwable)t));
            for (Object next : (Iterable)((Object)t)) {
                if (!(next instanceof Throwable)) break;
                if (ignore.contains((Throwable)next)) continue;
                suppressed.add((Throwable)next);
                ignore.addAll(com.google.common.base.Throwables.getCausalChain((Throwable)((Throwable)next)));
            }
            for (Throwable st : t.getSuppressed()) {
                if (ignore.contains(st)) continue;
                suppressed.add(st);
            }
            return suppressed.toArray(new Throwable[suppressed.size()]);
        }
        return t.getSuppressed();
    }

    public static void writeTo(StackTraceElement element, @Nullable StackTraceElement previous, Appendable to, PackageDetail detail, boolean abbreviatedTraceElement) throws IOException {
        String currFileName;
        String prevClassName;
        String currClassName = element.getClassName();
        String string = prevClassName = previous == null ? null : previous.getClassName();
        if (abbreviatedTraceElement) {
            if (currClassName.equals(prevClassName)) {
                to.append('^');
            } else {
                Throwables.writeAbreviatedClassName(currClassName, to);
            }
        } else {
            to.append(currClassName);
        }
        to.append('.');
        to.append(element.getMethodName());
        String fileName = currFileName = element.getFileName();
        if (abbreviatedTraceElement && java.util.Objects.equals(currFileName, previous == null ? null : previous.getFileName())) {
            fileName = "^";
        }
        int lineNumber = element.getLineNumber();
        if (element.isNativeMethod()) {
            to.append("(Native Method)");
        } else if (fileName == null) {
            to.append("(Unknown Source)");
        } else if (lineNumber >= 0) {
            to.append('(').append(fileName).append(':').append(Integer.toString(lineNumber)).append(')');
        } else {
            to.append('(').append(fileName).append(')');
        }
        if (detail == PackageDetail.NONE) {
            return;
        }
        if (abbreviatedTraceElement && currClassName.equals(prevClassName)) {
            to.append("[^]");
            return;
        }
        PackageInfo pInfo = org.spf4j.base.PackageInfo.getPackageInfo(currClassName);
        if (abbreviatedTraceElement && prevClassName != null && pInfo.equals((Object)org.spf4j.base.PackageInfo.getPackageInfo(prevClassName))) {
            to.append("[^]");
            return;
        }
        if (!pInfo.getUrl().isEmpty() || !pInfo.getVersion().isEmpty()) {
            String jarSourceUrl = pInfo.getUrl();
            String version = pInfo.getVersion();
            to.append('[');
            if (!jarSourceUrl.isEmpty()) {
                if (detail == PackageDetail.SHORT) {
                    String url = jarSourceUrl;
                    int lastIndexOf = url.lastIndexOf(47);
                    if (lastIndexOf >= 0) {
                        int lpos = url.length() - 1;
                        if (lastIndexOf == lpos) {
                            int prevSlPos = url.lastIndexOf(47, lpos - 1);
                            if (prevSlPos < 0) {
                                to.append(url);
                            } else {
                                to.append(url, prevSlPos + 1, url.length());
                            }
                        } else {
                            to.append(url, lastIndexOf + 1, url.length());
                        }
                    } else {
                        to.append(url);
                    }
                } else {
                    to.append(jarSourceUrl);
                }
            } else {
                to.append("na");
            }
            if (!version.isEmpty()) {
                to.append(':');
                to.append(version);
            }
            to.append(']');
        }
    }

    public static String toString(Throwable t) {
        return Throwables.toString(t, DEFAULT_PACKAGE_DETAIL);
    }

    public static String toString(Throwable t, PackageDetail detail) {
        return Throwables.toString(t, detail, DEFAULT_TRACE_ELEMENT_ABBREVIATION);
    }

    public static String toString(Throwable t, PackageDetail detail, boolean abbreviatedTraceElement) {
        StringBuilder sb = Throwables.toStringBuilder(t, detail, abbreviatedTraceElement);
        return sb.toString();
    }

    public static StringBuilder toStringBuilder(Throwable t, PackageDetail detail) {
        return Throwables.toStringBuilder(t, detail, DEFAULT_TRACE_ELEMENT_ABBREVIATION);
    }

    public static StringBuilder toStringBuilder(Throwable t, PackageDetail detail, boolean abbreviatedTraceElement) {
        StringBuilder sb = new StringBuilder(1024);
        try {
            Throwables.writeTo(t, (Appendable)sb, detail, abbreviatedTraceElement);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return sb;
    }

    public static void writeTo(@Nonnull Throwable t, @Nonnull PrintStream to, @Nonnull PackageDetail detail) {
        Throwables.writeTo(t, to, detail, DEFAULT_TRACE_ELEMENT_ABBREVIATION);
    }

    @SuppressFBWarnings(value={"OCP_OVERLY_CONCRETE_PARAMETER"})
    public static void writeTo(@Nonnull Throwable t, @Nonnull PrintStream to, @Nonnull PackageDetail detail, boolean abbreviatedTraceElement) {
        StringBuilder sb = new StringBuilder(1024);
        try {
            Throwables.writeTo(t, (Appendable)sb, detail, abbreviatedTraceElement);
            to.append(sb);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void writeTo(Throwable t, Appendable to, PackageDetail detail) throws IOException {
        Throwables.writeTo(t, to, detail, DEFAULT_TRACE_ELEMENT_ABBREVIATION);
    }

    public static void writeTo(Throwable t, Appendable to, PackageDetail detail, String prefix) throws IOException {
        Throwables.writeTo(t, to, detail, DEFAULT_TRACE_ELEMENT_ABBREVIATION, prefix);
    }

    public static void writeTo(Throwable t, Appendable to, PackageDetail detail, boolean abbreviatedTraceElement) throws IOException {
        Throwables.writeTo(t, to, detail, abbreviatedTraceElement, "");
    }

    public static void writeTo(Throwable t, Appendable to, PackageDetail detail, boolean abbreviatedTraceElement, String prefix) throws IOException {
        if (t instanceof RemoteException) {
            AThrowables.writeTo((RemoteException)t, to, detail, abbreviatedTraceElement, prefix);
            return;
        }
        to.append(prefix);
        Throwables.writeMessageString(to, t);
        to.append('\n');
        Throwables.writeThrowableDetail(t, to, detail, abbreviatedTraceElement, prefix);
    }

    public static void writeThrowableDetail(Throwable t, Appendable to, PackageDetail detail, boolean abbreviatedTraceElement, String prefix) throws IOException {
        StackTraceElement[] trace = t.getStackTrace();
        Throwables.writeTo(trace, to, detail, abbreviatedTraceElement, prefix);
        Throwable[] suppressed = Throwables.getSuppressed(t);
        Throwable ourCause = t.getCause();
        if (ourCause == null && suppressed.length == 0) {
            return;
        }
        IdentityHashSet dejaVu = new IdentityHashSet();
        dejaVu.add((Throwable)t);
        for (Throwable se : suppressed) {
            Throwables.printEnclosedStackTrace(se, to, trace, SUPPRESSED_CAPTION, prefix + "\t", dejaVu, detail, abbreviatedTraceElement);
        }
        if (ourCause != null) {
            Throwables.printEnclosedStackTrace(ourCause, to, trace, CAUSE_CAPTION, prefix, dejaVu, detail, abbreviatedTraceElement);
        }
    }

    public static void writeMessageString(Appendable to, Throwable t) throws IOException {
        to.append(t.getClass().getName());
        String message = t.getMessage();
        if (message != null) {
            to.append(':').append(message);
        }
    }

    public static void writeTo(StackTraceElement[] trace, Appendable to, PackageDetail detail, boolean abbreviatedTraceElement) throws IOException {
        Throwables.writeTo(trace, to, detail, abbreviatedTraceElement, "");
    }

    public static void writeTo(StackTraceElement[] trace, Appendable to, PackageDetail detail, boolean abbreviatedTraceElement, String prefix) throws IOException {
        StackTraceElement prevElem = null;
        for (StackTraceElement traceElement : trace) {
            to.append(prefix);
            to.append("\tat ");
            Throwables.writeTo(traceElement, prevElem, to, detail, abbreviatedTraceElement);
            to.append('\n');
            prevElem = traceElement;
        }
    }

    public static int commonFrames(StackTraceElement[] trace, StackTraceElement[] enclosingTrace) {
        int from;
        int m = from = trace.length - 1;
        for (int n = enclosingTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(enclosingTrace[n]); --m, --n) {
        }
        return from - m;
    }

    private static void printEnclosedStackTrace(Throwable t, Appendable s, StackTraceElement[] enclosingTrace, String caption, String prefix, Set<Throwable> dejaVu, PackageDetail detail, boolean abbreviatedTraceElement) throws IOException {
        if (dejaVu.contains(t)) {
            s.append("\t[CIRCULAR REFERENCE:");
            Throwables.writeMessageString(s, t);
            s.append("]\n");
        } else {
            dejaVu.add(t);
            StackTraceElement[] trace = t.getStackTrace();
            int framesInCommon = Throwables.commonFrames(trace, enclosingTrace);
            int m = trace.length - framesInCommon;
            s.append(prefix).append(caption);
            Throwables.writeMessageString(s, t);
            s.append('\n');
            StackTraceElement prev = null;
            for (int i = 0; i < m; ++i) {
                s.append(prefix).append("\tat ");
                StackTraceElement ste = trace[i];
                Throwables.writeTo(ste, prev, s, detail, abbreviatedTraceElement);
                s.append('\n');
                prev = ste;
            }
            if (framesInCommon != 0) {
                s.append(prefix).append("\t... ").append(Integer.toString(framesInCommon)).append(" more");
                s.append('\n');
            }
            for (Throwable se : Throwables.getSuppressed(t)) {
                Throwables.printEnclosedStackTrace(se, s, trace, SUPPRESSED_CAPTION, prefix + '\t', dejaVu, detail, abbreviatedTraceElement);
            }
            Throwable ourCause = t.getCause();
            if (ourCause != null) {
                Throwables.printEnclosedStackTrace(ourCause, s, trace, CAUSE_CAPTION, prefix, dejaVu, detail, abbreviatedTraceElement);
            }
        }
    }

    public static boolean isNonRecoverable(@Nonnull Throwable t) {
        return nonRecoverableClassificationPredicate.test(t);
    }

    public static boolean containsNonRecoverable(@Nonnull Throwable t) {
        return Throwables.contains(t, nonRecoverableClassificationPredicate);
    }

    public static boolean contains(@Nonnull Throwable t, Predicate<Throwable> predicate) {
        return Throwables.first(t, predicate) != null;
    }

    public static boolean contains(@Nonnull Throwable t, @Nonnull Throwable toLookFor) {
        return Throwables.first(t, (Throwable x) -> x == toLookFor) != null;
    }

    @Nullable
    @CheckReturnValue
    public static <T extends Throwable> T first(@Nonnull Throwable t, Class<T> clasz) {
        return (T)Throwables.first(t, (Throwable th) -> clasz.isAssignableFrom(th.getClass()));
    }

    @Nullable
    @CheckReturnValue
    public static Throwable first(@Nonnull Throwable t, Predicate<Throwable> predicate) {
        Throwable th;
        if (predicate.test(t)) {
            return t;
        }
        ArrayDeque<Throwable> toScan = new ArrayDeque<Throwable>();
        Throwable cause = t.getCause();
        if (cause != null) {
            toScan.addFirst(cause);
        }
        for (Throwable supp : Throwables.getSuppressed(t)) {
            toScan.addLast(supp);
        }
        IdentityHashSet seen = new IdentityHashSet();
        while ((th = (Throwable)toScan.pollFirst()) != null) {
            if (seen.contains(th)) continue;
            if (predicate.test(th)) {
                return th;
            }
            cause = th.getCause();
            if (cause != null) {
                toScan.addFirst(cause);
            }
            for (Throwable supp : Throwables.getSuppressed(th)) {
                toScan.addLast(supp);
            }
            seen.add(th);
        }
        return null;
    }

    @Nullable
    @CheckReturnValue
    public static Throwable firstCause(@Nonnull Throwable throwable, Predicate<Throwable> predicate) {
        Throwable t = throwable;
        do {
            if (!predicate.test(t)) continue;
            return t;
        } while ((t = t.getCause()) != null);
        return null;
    }

    public static Predicate<Throwable> getNonRecoverablePredicate() {
        return nonRecoverableClassificationPredicate;
    }

    public static void setNonRecoverablePredicate(Predicate<Throwable> predicate) {
        nonRecoverableClassificationPredicate = predicate;
    }

    public static void writeAbreviatedClassName(String className, Appendable writeTo) throws IOException {
        int ldIdx = className.lastIndexOf(46);
        if (ldIdx < 0) {
            writeTo.append(className);
            return;
        }
        boolean isPreviousDot = true;
        for (int i = 0; i < ldIdx; ++i) {
            boolean isCurrentCharDot;
            char c = className.charAt(i);
            boolean bl = isCurrentCharDot = c == '.';
            if (isPreviousDot || isCurrentCharDot) {
                writeTo.append(c);
            }
            isPreviousDot = isCurrentCharDot;
        }
        writeTo.append(className, ldIdx, className.length());
    }

    @SuppressFBWarnings(value={"ITC_INHERITANCE_TYPE_CHECKING"})
    public static void throwException(Exception ex) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        if (ex instanceof InterruptedException) {
            throw (InterruptedException)ex;
        }
        if (ex instanceof ExecutionException) {
            throw (ExecutionException)ex;
        }
        if (ex instanceof TimeoutException) {
            throw (TimeoutException)ex;
        }
        throw new ExecutionException(ex);
    }

    public static enum PackageDetail {
        NONE,
        SHORT,
        LONG;

    }

    public static final class TrimmedException
    extends Exception {
        public TrimmedException(String message) {
            super(message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

