/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.LongSupplier;

public final class TimeSource {
    private static final LongSupplier TIMESUPP;

    private TimeSource() {
    }

    public static long nanoTime() {
        return TIMESUPP.getAsLong();
    }

    public static LongSupplier nanoTimeSupplier() {
        return TIMESUPP;
    }

    public static long getDeadlineNanos(long timeout, TimeUnit timeUnit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Invalid timeout " + timeout + " " + (Object)((Object)timeUnit));
        }
        return TimeSource.nanoTime() + timeUnit.toNanos(timeout);
    }

    public static long getDeadlineNanos(long currentTimeNanos, long timeout, TimeUnit timeUnit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Invalid timeout " + timeout + " " + (Object)((Object)timeUnit));
        }
        return currentTimeNanos + timeUnit.toNanos(timeout);
    }

    public static long getTimeToDeadlineStrict(long deadlineNanos, TimeUnit timeUnit) throws TimeoutException {
        long timeoutNanos = deadlineNanos - TimeSource.nanoTime();
        if (timeoutNanos < 0L) {
            throw new TimeoutException("Exceeded deadline " + deadlineNanos + " with " + -timeoutNanos);
        }
        return timeUnit.convert(timeoutNanos, TimeUnit.NANOSECONDS);
    }

    public static long getTimeToDeadline(long deadlineNanos, TimeUnit timeUnit) {
        long timeoutNanos = deadlineNanos - TimeSource.nanoTime();
        return timeUnit.convert(timeoutNanos, TimeUnit.NANOSECONDS);
    }

    static {
        String cfgTimeSource = System.getProperty("spf4j.timeSource");
        if (cfgTimeSource == null) {
            TIMESUPP = () -> System.nanoTime();
        } else if ("systemTime".equals(cfgTimeSource)) {
            TIMESUPP = new SystemTimeProvider();
        } else {
            try {
                TIMESUPP = (LongSupplier)Class.forName(cfgTimeSource).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }
    }

    private static final class SystemTimeProvider
    implements LongSupplier {
        private static final long LOCAL_EPOCH = System.currentTimeMillis();

        private SystemTimeProvider() {
        }

        @Override
        public long getAsLong() {
            return TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis() - LOCAL_EPOCH);
        }
    }
}

