/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnegative;
import org.spf4j.base.Timing;

@SuppressFBWarnings(value={"FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY"})
public final class TimeoutDeadline {
    private final long timeoutNanos;
    private final long deadlineNanos;

    public TimeoutDeadline(@Nonnegative long timeoutNanos, long deadlineNanos) {
        this.timeoutNanos = timeoutNanos;
        this.deadlineNanos = deadlineNanos;
    }

    public static TimeoutDeadline of(long timeoutNanos, long deadlineNanos) throws TimeoutException {
        if (timeoutNanos < 0L) {
            throw new TimeoutException("Timeout exceeded by " + -timeoutNanos + " ns, deadline: " + Timing.getCurrentTiming().fromNanoTimeToInstant(deadlineNanos));
        }
        return new TimeoutDeadline(timeoutNanos, deadlineNanos);
    }

    public long getTimeoutNanos() {
        return this.timeoutNanos;
    }

    public long getDeadlineNanos() {
        return this.deadlineNanos;
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + (int)(this.timeoutNanos ^ this.timeoutNanos >>> 32);
        return 23 * hash + (int)(this.deadlineNanos ^ this.deadlineNanos >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeoutDeadline other = (TimeoutDeadline)obj;
        if (this.timeoutNanos != other.timeoutNanos) {
            return false;
        }
        return this.deadlineNanos == other.deadlineNanos;
    }

    public String toString() {
        return "TimeoutDeadline{timeoutNanos=" + this.timeoutNanos + ", deadlineNanos=" + this.deadlineNanos + '}';
    }
}

