/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.google.common.annotations.Beta;
import java.time.Instant;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.spf4j.base.Runtime;
import org.spf4j.base.TimeSource;
import org.spf4j.concurrent.DefaultScheduler;
import org.spf4j.jmx.JmxExport;

@Beta
public final class Timing {
    public static final long MAX_MS_SPAN;
    private static final long TIMING_UPDATE_INTERVAL_MINUTES;
    private static volatile Timing latestTiming;
    private static final ScheduledFuture UPDATER;
    private final long nanoTimeRef = TimeSource.nanoTime();
    private final long currentTimeMillisRef = System.currentTimeMillis();

    @JmxExport
    public static void updateTiming() {
        latestTiming = new Timing();
    }

    private Timing() {
    }

    public long fromNanoTimeToEpochMillis(long nanoTime) {
        return this.currentTimeMillisRef + TimeUnit.NANOSECONDS.toMillis(nanoTime - this.nanoTimeRef);
    }

    public Instant fromNanoTimeToInstant(long nanoTime) {
        long relNanos = nanoTime - this.nanoTimeRef;
        return Instant.ofEpochSecond(this.currentTimeMillisRef / 1000L + relNanos / 1000000000L, this.currentTimeMillisRef % 1000L * 1000000L + relNanos % 1000000000L);
    }

    public long fromEpochMillisToNanoTime(long epochTimeMillis) {
        long msSinceLast = epochTimeMillis - this.currentTimeMillisRef;
        if (Math.abs(msSinceLast) > MAX_MS_SPAN) {
            return TimeSource.nanoTime() + Long.MAX_VALUE;
        }
        return this.nanoTimeRef + TimeUnit.MILLISECONDS.toNanos(msSinceLast);
    }

    public static Timing getCurrentTiming() {
        return latestTiming;
    }

    @JmxExport
    public static void stopUpdate() {
        if (UPDATER != null) {
            UPDATER.cancel(false);
        }
    }

    public String toString() {
        return "Timing{nanoTimeRef=" + this.nanoTimeRef + ", currentTimeMillisRef=" + this.currentTimeMillisRef + '}';
    }

    static {
        ScheduledFuture<?> sf;
        block2: {
            MAX_MS_SPAN = TimeUnit.NANOSECONDS.toMillis(Long.MAX_VALUE);
            TIMING_UPDATE_INTERVAL_MINUTES = Long.getLong("spf4j.timing.updateIntervalMinutes", 60L);
            Timing.updateTiming();
            Timing.updateTiming();
            sf = null;
            try {
                ScheduledFuture<?> fut;
                sf = fut = DefaultScheduler.INSTANCE.scheduleWithFixedDelay(Timing::updateTiming, TIMING_UPDATE_INTERVAL_MINUTES, TIMING_UPDATE_INTERVAL_MINUTES, TimeUnit.MINUTES);
                Runtime.queueHookAtBeginning(() -> fut.cancel(true));
            }
            catch (RejectedExecutionException ex) {
                if (Runtime.isShuttingDown()) break block2;
                throw ex;
            }
        }
        UPDATER = sf;
    }
}

