/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.google.common.primitives.Ints;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.Comparables;

@ParametersAreNonnullByDefault
public final class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient Comparable[] components;
    private final String image;

    public Version(String version) {
        this((CharSequence)version);
    }

    public Version(CharSequence version) {
        this.image = version.toString();
        this.parse(version);
    }

    private void parse(CharSequence version) {
        ArrayList comps = new ArrayList(4);
        StringBuilder sb = new StringBuilder();
        int l = version.length();
        for (int i = 0; i < l; ++i) {
            char prev;
            char c = version.charAt(i);
            int length = sb.length();
            if (c == '.') {
                Version.addPart(sb.toString(), comps);
                sb.setLength(0);
                continue;
            }
            if (Character.isDigit(c)) {
                if (length > 0 && !Character.isDigit(prev = sb.charAt(length - 1))) {
                    comps.add((Comparable<?>)((Object)sb.toString()));
                    sb.setLength(0);
                }
                sb.append(c);
                continue;
            }
            if (length > 0 && Character.isDigit(prev = sb.charAt(length - 1))) {
                comps.add(Integer.valueOf(sb.toString()));
                sb.setLength(0);
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            Version.addPart(sb.toString(), comps);
        }
        this.components = comps.toArray(new Comparable[comps.size()]);
    }

    private static void addPart(String strPart, Collection<Comparable<?>> comps) {
        Integer nr = Ints.tryParse((String)strPart);
        if (nr == null) {
            comps.add((Comparable<?>)((Object)strPart));
        } else {
            comps.add(nr);
        }
    }

    @Override
    public int compareTo(Version o) {
        if (this.components.length == o.components.length) {
            return Comparables.compareArrays((Comparable[])this.components, (Comparable[])o.components);
        }
        if (this.components.length < o.components.length) {
            int res = Comparables.compareArrays((Comparable[])this.components, (Comparable[])o.components, (int)0, (int)this.components.length);
            if (res == 0) {
                Comparable component = o.components[this.components.length];
                if (component instanceof String && ((String)((Object)component)).contains("SNAPSHOT")) {
                    return 1;
                }
                return -1;
            }
            return res;
        }
        int res = Comparables.compareArrays((Comparable[])this.components, (Comparable[])o.components, (int)0, (int)o.components.length);
        if (res == 0) {
            Comparable component = this.components[o.components.length];
            if (component instanceof String && ((String)((Object)component)).contains("SNAPSHOT")) {
                return -1;
            }
            return 1;
        }
        return res;
    }

    public int hashCode() {
        return this.image.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((Version)obj) == 0;
    }

    public String getImage() {
        return this.image;
    }

    public Comparable[] getComponents() {
        return (Comparable[])this.components.clone();
    }

    public Comparable getComponent(int pos) {
        return this.components[pos];
    }

    @SuppressFBWarnings(value={"CLI_CONSTANT_LIST_INDEX"})
    public int getMajor() {
        return (Integer)this.components[0];
    }

    @SuppressFBWarnings(value={"CLI_CONSTANT_LIST_INDEX"})
    public int getMinor() {
        return (Integer)this.components[1];
    }

    @SuppressFBWarnings(value={"CLI_CONSTANT_LIST_INDEX"})
    public int getPatch() {
        return (Integer)this.components[2];
    }

    public int getNrComponents() {
        return this.components.length;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.parse(this.image);
    }

    public String toString() {
        return this.image;
    }
}

