/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;

public final class XCollectors {
    private XCollectors() {
    }

    public static <T> Collector<T, ?, ArrayDeque<T>> last(int limit) {
        return Collector.of(ArrayDeque::new, (l, e) -> {
            if (l.size() >= limit) {
                l.removeFirst();
            }
            l.addLast(e);
        }, (l1, l2) -> {
            throw new UnsupportedOperationException("Limiting collectors do not support combining");
        }, new Collector.Characteristics[0]);
    }

    public static <T, X extends T> Collector<T, ArrayDeque<T>, ArrayDeque<T>> last(int limit, X addIfLimited) {
        return XCollectors.last(() -> new ArrayDeque(), limit, addIfLimited);
    }

    public static <T, X extends T, D extends Deque<T>> Collector<T, D, D> last(Supplier<D> dqSupp, final int limit, final X addIfLimited) {
        return Collector.of(dqSupp, (l, e) -> {
            l.addLast(e);
            XCollectors.limitDequeue(l, limit, addIfLimited);
        }, new BinaryOperator<D>(){

            @Override
            @SuppressFBWarnings(value={"CFS_CONFUSING_FUNCTION_SEMANTICS"})
            public D apply(D l1, D l2) {
                l1.addAll(l2);
                XCollectors.limitDequeue(l1, limit, addIfLimited);
                return l1;
            }
        }, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <T> void limitDequeue(Deque<T> l1, int limit, T addIfLimited) {
        int extra = l1.size() - limit;
        if (extra > 0) {
            int m = extra + 1;
            for (int i = 0; i < m; ++i) {
                l1.removeFirst();
            }
            l1.addFirst(addIfLimited);
        }
    }

    public static <T, A, R> Collector<T, ?, R> filtering(Predicate<? super T> predicate, Collector<? super T, A, R> downstream) {
        BiConsumer downstreamAccumulator = downstream.accumulator();
        return new CollectorImpl<Object, Object, R>(downstream.supplier(), (r, t) -> {
            if (predicate.test(t)) {
                downstreamAccumulator.accept(r, t);
            }
        }, downstream.combiner(), downstream.finisher(), downstream.characteristics());
    }

    private static <I, R> Function<I, R> castingIdentity() {
        return Function.identity();
    }

    static final class CollectorImpl<T, A, R>
    implements Collector<T, A, R> {
        private final Supplier<A> supplier;
        private final BiConsumer<A, T> accumulator;
        private final BinaryOperator<A> combiner;
        private final Function<A, R> finisher;
        private final Set<Collector.Characteristics> characteristics;

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Set<Collector.Characteristics> characteristics) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.combiner = combiner;
            this.finisher = finisher;
            this.characteristics = characteristics;
        }

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Set<Collector.Characteristics> characteristics) {
            this(supplier, accumulator, combiner, XCollectors.castingIdentity(), characteristics);
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.combiner;
        }

        @Override
        public Function<A, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.characteristics;
        }
    }
}

