/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base.avro;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.spf4j.base.Throwables;
import org.spf4j.base.avro.FileLocation;
import org.spf4j.base.avro.Method;
import org.spf4j.base.avro.PackageInfo;
import org.spf4j.base.avro.RemoteException;
import org.spf4j.base.avro.StackTraceElement;
import org.spf4j.base.avro.Throwable;
import org.spf4j.ds.IdentityHashSet;

public final class AThrowables {
    private AThrowables() {
    }

    public static void writeTo(RemoteException t, Appendable to, Throwables.PackageDetail detail, boolean abbreviatedTraceElement, String prefix) throws IOException {
        to.append(prefix);
        AThrowables.writeMessageString(to, t);
        to.append('\n');
        AThrowables.writeThrowableDetails(t.getRemoteCause(), to, detail, abbreviatedTraceElement, prefix);
    }

    public static void writeMessageString(Appendable to, RemoteException t) throws IOException {
        to.append(t.getClass().getName());
        to.append(':');
        to.append(t.getRemoteClass());
        to.append('@');
        to.append(t.getSource());
        String message = t.getRemoteCause().getMessage();
        if (message != null) {
            to.append(':').append(message);
        }
    }

    public static void writeTo(Throwable t, Appendable to, Throwables.PackageDetail detail, boolean abbreviatedTraceElement, String prefix) throws IOException {
        to.append(prefix);
        AThrowables.writeMessageString(to, t);
        to.append('\n');
        AThrowables.writeThrowableDetails(t, to, detail, abbreviatedTraceElement, prefix);
    }

    public static void writeThrowableDetails(Throwable t, Appendable to, Throwables.PackageDetail detail, boolean abbreviatedTraceElement, String prefix) throws IOException {
        List trace = t.getStackTrace();
        AThrowables.writeTo(trace, to, detail, abbreviatedTraceElement, prefix);
        Throwable ourCause = t.getCause();
        List suppressed = t.getSuppressed();
        if (ourCause == null && suppressed.isEmpty()) {
            return;
        }
        IdentityHashSet dejaVu = new IdentityHashSet();
        dejaVu.add((Throwable)t);
        for (Throwable se : suppressed) {
            AThrowables.printEnclosedStackTrace(se, to, trace, "Suppressed: ", prefix + "\t", dejaVu, detail, abbreviatedTraceElement);
        }
        if (ourCause != null) {
            AThrowables.printEnclosedStackTrace(ourCause, to, trace, "Caused by: ", prefix, dejaVu, detail, abbreviatedTraceElement);
        }
    }

    public static void writeTo(List<StackTraceElement> trace, Appendable to, Throwables.PackageDetail detail, boolean abbreviatedTraceElement, String prefix) throws IOException {
        StackTraceElement prevElem = null;
        for (StackTraceElement traceElement : trace) {
            to.append(prefix);
            to.append("\tat ");
            AThrowables.writeTo(traceElement, prevElem, to, detail, abbreviatedTraceElement);
            to.append('\n');
            prevElem = traceElement;
        }
    }

    public static void writeTo(StackTraceElement element, @Nullable StackTraceElement previous, Appendable to, Throwables.PackageDetail detail, boolean abbreviatedTraceElement) throws IOException {
        int lineNumber;
        String prevClassName;
        Method method = element.getMethod();
        String currClassName = method.getDeclaringClass();
        String string = prevClassName = previous == null ? null : previous.getMethod().getDeclaringClass();
        if (abbreviatedTraceElement) {
            if (currClassName.equals(prevClassName)) {
                to.append('^');
            } else {
                Throwables.writeAbreviatedClassName(currClassName, to);
            }
        } else {
            to.append(currClassName);
        }
        to.append('.');
        to.append(method.getName());
        FileLocation location = element.getLocation();
        FileLocation prevLocation = previous == null ? null : previous.getLocation();
        String currFileName = location != null ? location.getFileName() : "";
        String prevFileName = prevLocation != null ? prevLocation.getFileName() : "";
        String fileName = currFileName;
        if (abbreviatedTraceElement && Objects.equals(currFileName, prevFileName)) {
            fileName = "^";
        }
        int n = lineNumber = location != null ? location.getLineNumber() : -1;
        if (fileName.isEmpty()) {
            to.append("(Unknown Source)");
        } else if (lineNumber >= 0) {
            to.append('(').append(fileName).append(':').append(Integer.toString(lineNumber)).append(')');
        } else {
            to.append('(').append(fileName).append(')');
        }
        if (detail == Throwables.PackageDetail.NONE) {
            return;
        }
        if (abbreviatedTraceElement && currClassName.equals(prevClassName)) {
            to.append("[^]");
            return;
        }
        PackageInfo presPackageInfo = previous == null ? null : previous.getPackageInfo();
        PackageInfo pInfo = element.getPackageInfo();
        if (abbreviatedTraceElement && Objects.equals(pInfo, presPackageInfo)) {
            to.append("[^]");
            return;
        }
        if (!pInfo.getUrl().isEmpty() || !pInfo.getVersion().isEmpty()) {
            String jarSourceUrl = pInfo.getUrl();
            String version = pInfo.getVersion();
            to.append('[');
            if (!jarSourceUrl.isEmpty()) {
                if (detail == Throwables.PackageDetail.SHORT) {
                    String url = jarSourceUrl;
                    int lastIndexOf = url.lastIndexOf(47);
                    if (lastIndexOf >= 0) {
                        int lpos = url.length() - 1;
                        if (lastIndexOf == lpos) {
                            int prevSlPos = url.lastIndexOf(47, lpos - 1);
                            if (prevSlPos < 0) {
                                to.append(url);
                            } else {
                                to.append(url, prevSlPos + 1, url.length());
                            }
                        } else {
                            to.append(url, lastIndexOf + 1, url.length());
                        }
                    } else {
                        to.append(url);
                    }
                } else {
                    to.append(jarSourceUrl);
                }
            } else {
                to.append("na");
            }
            if (!version.isEmpty()) {
                to.append(':');
                to.append(version);
            }
            to.append(']');
        }
    }

    private static void printEnclosedStackTrace(Throwable t, Appendable s, List<StackTraceElement> enclosingTrace, String caption, String prefix, Set<Throwable> dejaVu, Throwables.PackageDetail detail, boolean abbreviatedTraceElement) throws IOException {
        if (dejaVu.contains(t)) {
            s.append("\t[CIRCULAR REFERENCE:");
            AThrowables.writeMessageString(s, t);
            s.append(']');
        } else {
            dejaVu.add(t);
            List trace = t.getStackTrace();
            int framesInCommon = AThrowables.commonFrames(trace, enclosingTrace);
            int m = trace.size() - framesInCommon;
            s.append(prefix).append(caption);
            AThrowables.writeMessageString(s, t);
            s.append('\n');
            StackTraceElement prev = null;
            for (int i = 0; i < m; ++i) {
                s.append(prefix).append("\tat ");
                StackTraceElement ste = (StackTraceElement)trace.get(i);
                AThrowables.writeTo(ste, prev, s, detail, abbreviatedTraceElement);
                s.append('\n');
                prev = ste;
            }
            if (framesInCommon != 0) {
                s.append(prefix).append("\t... ").append(Integer.toString(framesInCommon)).append(" more");
                s.append('\n');
            }
            for (Throwable se : t.getSuppressed()) {
                AThrowables.printEnclosedStackTrace(se, s, trace, "Suppressed: ", prefix + '\t', dejaVu, detail, abbreviatedTraceElement);
            }
            Throwable ourCause = t.getCause();
            if (ourCause != null) {
                AThrowables.printEnclosedStackTrace(ourCause, s, trace, "Caused by: ", prefix, dejaVu, detail, abbreviatedTraceElement);
            }
        }
    }

    public static int commonFrames(List<StackTraceElement> trace, List<StackTraceElement> enclosingTrace) {
        int from;
        int m = from = trace.size() - 1;
        for (int n = enclosingTrace.size() - 1; m >= 0 && n >= 0 && trace.get(m).equals((Object)enclosingTrace.get(n)); --m, --n) {
        }
        return from - m;
    }

    public static void writeMessageString(Appendable to, Throwable t) throws IOException {
        to.append(t.getClass().getName());
        String message = t.getMessage();
        if (message != null) {
            to.append(':').append(message);
        }
    }
}

