/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base.avro;

import gnu.trove.map.TMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.Methods;
import org.spf4j.base.PackageInfo;
import org.spf4j.base.StackSamples;
import org.spf4j.base.avro.FileLocation;
import org.spf4j.base.avro.LogRecord;
import org.spf4j.base.avro.Method;
import org.spf4j.base.avro.RemoteException;
import org.spf4j.base.avro.StackSampleElement;
import org.spf4j.base.avro.StackTraceElement;
import org.spf4j.base.avro.Throwable;
import org.spf4j.ds.IdentityHashSet;
import org.spf4j.log.Slf4jLogRecord;

@ParametersAreNonnullByDefault
public final class Converters {
    public static final Method ROOT = new Method("JVM", "ROOT");

    private Converters() {
    }

    public static StackTraceElement convert(java.lang.StackTraceElement stackTrace) {
        String className = stackTrace.getClassName();
        String fileName = stackTrace.getFileName();
        return new StackTraceElement(new Method(className, stackTrace.getMethodName()), fileName == null ? null : new FileLocation(fileName, stackTrace.getLineNumber(), -1), PackageInfo.getPackageInfo(className));
    }

    public static List<StackTraceElement> convert(java.lang.StackTraceElement[] stackTraces) {
        int l = stackTraces.length;
        if (l == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<StackTraceElement> result = new ArrayList<StackTraceElement>(l);
        for (java.lang.StackTraceElement st : stackTraces) {
            result.add(Converters.convert(st));
        }
        return result;
    }

    public static List<Throwable> convert(java.lang.Throwable[] throwables, Set<java.lang.Throwable> seen) {
        int l = throwables.length;
        if (l == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Throwable> result = new ArrayList<Throwable>(l);
        for (java.lang.Throwable t : throwables) {
            result.add(Converters.convert(t, seen));
        }
        return result;
    }

    public static Throwable convert(java.lang.Throwable throwable) {
        return Converters.convert(throwable, new IdentityHashSet(4));
    }

    public static Throwable convert(java.lang.Throwable throwable, Set<java.lang.Throwable> seen) {
        if (seen.contains(throwable)) {
            return new Throwable(throwable.getClass().getName(), "CIRCULAR REFERENCE:" + throwable.getMessage(), Collections.EMPTY_LIST, null, Collections.EMPTY_LIST);
        }
        seen.add(throwable);
        String message = throwable.getMessage();
        if (throwable instanceof RemoteException) {
            return new Throwable(throwable.getClass().getName(), message == null ? "" : message, Converters.convert(throwable.getStackTrace()), ((RemoteException)throwable).getRemoteCause(), Converters.convert(throwable.getSuppressed(), seen));
        }
        java.lang.Throwable cause = throwable.getCause();
        return new Throwable(throwable.getClass().getName(), message == null ? "" : message, Converters.convert(throwable.getStackTrace()), cause == null ? null : Converters.convert(cause, seen), Converters.convert(throwable.getSuppressed(), seen));
    }

    public static RemoteException convert(String source, Throwable throwable) {
        return new RemoteException(source, throwable);
    }

    public static List<LogRecord> convert(String origin, String traceId, List<Slf4jLogRecord> logRecords) {
        ArrayList<LogRecord> result = new ArrayList<LogRecord>(logRecords.size());
        for (Slf4jLogRecord log : logRecords) {
            result.add(log.toLogRecord(origin, traceId));
        }
        return result;
    }

    public static int convert(Method method, StackSamples node, int parentId, int id, Consumer<StackSampleElement> handler) {
        ArrayDeque<TraversalNode> dq = new ArrayDeque<TraversalNode>();
        dq.addLast(new TraversalNode(method, node, parentId));
        int nid = id;
        while (!dq.isEmpty()) {
            TraversalNode first = (TraversalNode)dq.removeFirst();
            StackSamples n = first.getNode();
            StackSampleElement sample = new StackSampleElement(nid, first.getParentId(), n.getSampleCount(), first.getMethod());
            TMap<Method, ? extends StackSamples> subNodes = n.getSubNodes();
            int pid = nid;
            if (subNodes != null) {
                subNodes.forEachEntry((a, b) -> {
                    dq.addLast(new TraversalNode((Method)a, (StackSamples)b, pid));
                    return true;
                });
            }
            handler.accept(sample);
            ++nid;
        }
        return nid;
    }

    @Nonnull
    public static List<StackSampleElement> convert(@Nullable StackSamples stackSamples) {
        if (stackSamples != null) {
            ArrayList<StackSampleElement> samples = new ArrayList<StackSampleElement>();
            Converters.convert(Methods.ROOT, stackSamples, -1, 0, samples::add);
            return samples;
        }
        return Collections.EMPTY_LIST;
    }

    @ParametersAreNonnullByDefault
    private static final class TraversalNode {
        private final Method method;
        private final StackSamples node;
        private final int parentId;

        TraversalNode(Method method, StackSamples node, int parentId) {
            this.method = method;
            this.node = node;
            this.parentId = parentId;
        }

        public Method getMethod() {
            return this.method;
        }

        public StackSamples getNode() {
            return this.node;
        }

        public int getParentId() {
            return this.parentId;
        }

        public String toString() {
            return "TraversalNode{method=" + this.method + ", node=" + this.node + ", parentId=" + this.parentId + '}';
        }
    }
}

