/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base.avro;

import java.io.Serializable;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.avro.FileLocation;
import org.spf4j.base.avro.Method;
import org.spf4j.base.avro.StackTraceElement;
import org.spf4j.base.avro.Throwable;

@ParametersAreNonnullByDefault
public class RemoteException
extends org.spf4j.base.RemoteException {
    public RemoteException(String source, Throwable remote) {
        super(remote.getMessage(), source, remote.getClassName(), (Serializable)remote, remote.getCause() == null ? null : new RemoteException(source, remote.getCause()));
        for (Throwable suppressed : remote.getSuppressed()) {
            this.addSuppressed(new RemoteException(source, suppressed));
        }
        List stackTrace = remote.getStackTrace();
        java.lang.StackTraceElement[] jste = new java.lang.StackTraceElement[stackTrace.size()];
        int i = 0;
        for (StackTraceElement ste : stackTrace) {
            FileLocation location = ste.getLocation();
            Method method = ste.getMethod();
            String declaringClass = method.getDeclaringClass();
            if (!declaringClass.startsWith("remote.")) {
                declaringClass = "remote." + declaringClass;
            }
            jste[i] = location == null ? new java.lang.StackTraceElement(declaringClass, method.getName(), "N/A", -1) : new java.lang.StackTraceElement(declaringClass, method.getName(), location.getFileName(), location.getLineNumber());
            ++i;
        }
        this.setStackTrace(jste);
    }

    public final Throwable getRemoteCause() {
        return (Throwable)this.getRemoteDetail();
    }

    public final String getSource() {
        return this.getOrigin();
    }

    @Override
    public synchronized java.lang.Throwable fillInStackTrace() {
        return this;
    }
}

