/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.function.UnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.concurrent.UpdateResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings(value={"PREDICTABLE_RANDOM"})
public final class Atomics {
    public static final int MAX_BACKOFF_NANOS = Integer.getInteger("spf4j.atomics.maxBackoffNanos", 3);

    private Atomics() {
    }

    public static <T> UpdateResult<T> update(AtomicReference<T> ar, UnaryOperator<T> function) {
        Object newObj;
        T initial;
        do {
            if (!Objects.equals(initial = ar.get(), newObj = function.apply(initial))) continue;
            return UpdateResult.same(initial);
        } while (!ar.compareAndSet(initial, newObj));
        return UpdateResult.updated(newObj);
    }

    public static boolean maybeAccumulate(AtomicLong dval, double x, DoubleBinaryOperator accumulatorFunction, int maxBackoffNanos) {
        long next;
        long prev;
        while ((prev = dval.get()) != (next = Double.doubleToRawLongBits(accumulatorFunction.applyAsDouble(Double.longBitsToDouble(prev), x)))) {
            if (dval.compareAndSet(prev, next)) {
                return true;
            }
            LockSupport.parkNanos(Atomics.getBackoffNanos(maxBackoffNanos));
        }
        return false;
    }

    public static void accumulate(AtomicLong dval, double x, DoubleBinaryOperator accumulatorFunction, int maxBackoffNanos) {
        long prev;
        long next;
        while ((next = Double.doubleToRawLongBits(accumulatorFunction.applyAsDouble(Double.longBitsToDouble(prev = dval.get()), x))) != prev) {
            if (dval.compareAndSet(prev, next)) {
                return;
            }
            LockSupport.parkNanos(Atomics.getBackoffNanos(maxBackoffNanos));
        }
        return;
    }

    public static void accumulate(AtomicLong dval, long x, LongBinaryOperator accumulatorFunction, int maxBackoffNanos) {
        long prev;
        long next;
        while ((next = accumulatorFunction.applyAsLong(prev = dval.get(), x)) != prev) {
            if (dval.compareAndSet(prev, next)) {
                return;
            }
            LockSupport.parkNanos(Atomics.getBackoffNanos(maxBackoffNanos));
        }
        return;
    }

    private static long getBackoffNanos(int maxBackoffNanos) {
        return maxBackoffNanos > 0 ? Thread.currentThread().getId() % (long)maxBackoffNanos : 0L;
    }

    public static boolean maybeAccumulate(AtomicLong dval, DoubleUnaryOperator accumulatorFunction, int maxBackoffNanos) {
        long next;
        long prev;
        while ((prev = dval.get()) != (next = Double.doubleToRawLongBits(accumulatorFunction.applyAsDouble(Double.longBitsToDouble(prev))))) {
            if (dval.compareAndSet(prev, next)) {
                return true;
            }
            LockSupport.parkNanos(Atomics.getBackoffNanos(maxBackoffNanos));
        }
        return false;
    }

    public static boolean maybeAccumulate(AtomicLong dval, long val, LongBinaryOperator accumulatorFunction, int maxBackoffNanos) {
        long next;
        long prev;
        while ((prev = dval.get()) != (next = accumulatorFunction.applyAsLong(prev, val))) {
            if (dval.compareAndSet(prev, next)) {
                return true;
            }
            LockSupport.parkNanos(Atomics.getBackoffNanos(maxBackoffNanos));
        }
        return false;
    }
}

