/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import java.util.Arrays;
import org.spf4j.concurrent.PermitSupplier;

public final class CompoundPermitSupplier
implements PermitSupplier {
    private final PermitSupplier[] suppliers;

    public CompoundPermitSupplier(PermitSupplier ... suppliers) {
        this.suppliers = suppliers;
    }

    @Override
    public boolean tryAcquire(int nrPermits, long deadlineNanos) throws InterruptedException {
        PermitSupplier[] acquired = new PermitSupplier[this.suppliers.length];
        int i = 0;
        for (PermitSupplier sem : this.suppliers) {
            boolean tryAcquire;
            try {
                tryAcquire = sem.tryAcquire(nrPermits, deadlineNanos);
            }
            catch (InterruptedException | RuntimeException ex) {
                CompoundPermitSupplier.returnPermits(acquired, i, nrPermits);
                throw ex;
            }
            if (!tryAcquire) {
                CompoundPermitSupplier.returnPermits(acquired, i, nrPermits);
                return false;
            }
            acquired[i++] = sem;
        }
        return true;
    }

    @Override
    public PermitSupplier.Acquisition tryAcquireEx(int nrPermits, long deadlineNanos) throws InterruptedException {
        PermitSupplier[] acquired = new PermitSupplier[this.suppliers.length];
        int i = 0;
        for (PermitSupplier sem : this.suppliers) {
            PermitSupplier.Acquisition tryAcquire;
            try {
                tryAcquire = sem.tryAcquireEx(nrPermits, deadlineNanos);
            }
            catch (InterruptedException | RuntimeException ex) {
                CompoundPermitSupplier.returnPermits(acquired, i, nrPermits);
                throw ex;
            }
            if (!tryAcquire.isSuccess()) {
                CompoundPermitSupplier.returnPermits(acquired, i, nrPermits);
                return tryAcquire;
            }
            acquired[i++] = sem;
        }
        return PermitSupplier.Acquisition.SUCCESS;
    }

    private static void returnPermits(PermitSupplier[] pss, int nr, int nrPermits) {
        RuntimeException ex = null;
        for (int i = nr - 1; i >= 0; --i) {
            PermitSupplier sem = pss[i];
            try {
                sem.addPermits(nrPermits);
                continue;
            }
            catch (RuntimeException e) {
                if (ex == null) {
                    ex = e;
                    continue;
                }
                ex.addSuppressed(e);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public String toString() {
        return "CompoundPermitSupplier{suppliers=" + Arrays.toString(this.suppliers) + '}';
    }
}

