/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import java.util.Arrays;
import org.spf4j.concurrent.Semaphore;

public final class CompoundSemaphore
implements Semaphore {
    private final Semaphore[] semaphores;

    public CompoundSemaphore(Semaphore ... semaphores) {
        this.semaphores = semaphores;
    }

    @Override
    public void release(int nrPermits) {
        CompoundSemaphore.release(this.semaphores, this.semaphores.length, nrPermits);
    }

    private static void release(Semaphore[] sems, int nr, int nrPermits) {
        RuntimeException ex = null;
        for (int i = nr - 1; i >= 0; --i) {
            Semaphore sem = sems[i];
            try {
                sem.release(nrPermits);
                continue;
            }
            catch (RuntimeException e) {
                if (ex == null) {
                    ex = e;
                    continue;
                }
                ex.addSuppressed(e);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    @Override
    public boolean tryAcquire(int nrPermits, long deadlineNanos) throws InterruptedException {
        Semaphore[] acquired = new Semaphore[this.semaphores.length];
        int i = 0;
        for (Semaphore sem : this.semaphores) {
            boolean tryAcquire;
            try {
                tryAcquire = sem.tryAcquire(nrPermits, deadlineNanos);
            }
            catch (InterruptedException | RuntimeException ex) {
                CompoundSemaphore.release(acquired, i, nrPermits);
                throw ex;
            }
            if (!tryAcquire) {
                CompoundSemaphore.release(acquired, i, nrPermits);
                return false;
            }
            acquired[i++] = sem;
        }
        return true;
    }

    public Semaphore[] getSemaphores() {
        return (Semaphore[])this.semaphores.clone();
    }

    public String toString() {
        return "CompoundSemaphore{semaphores=" + Arrays.toString(this.semaphores) + '}';
    }
}

