/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ConcurrentStack<E> {
    private final AtomicReference<Node<E>> top = new AtomicReference();

    public void push(@Nonnull E item) {
        Node<E> newHead;
        Node<E> oldHead;
        while (!this.top.compareAndSet(oldHead = this.top.get(), newHead = new Node<E>(item, oldHead))) {
        }
    }

    @Nullable
    public E pop() {
        Node newHead;
        Node<E> oldHead;
        do {
            if ((oldHead = this.top.get()) != null) continue;
            return null;
        } while (!this.top.compareAndSet(oldHead, newHead = ((Node)oldHead).next));
        return (E)((Node)oldHead).item;
    }

    public String toString() {
        return "ConcurrentStack{top=" + this.top + '}';
    }

    private static class Node<E> {
        private final E item;
        private final Node<E> next;

        Node(E item, @Nullable Node<E> next) {
            this.item = item;
            this.next = next;
        }
    }
}

