/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import com.google.common.annotations.Beta;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.ExecutionContext;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.base.TimeSource;
import org.spf4j.base.Timing;
import org.spf4j.base.UncheckedTimeoutException;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.concurrent.InterruptibleCompletableFuture;

@ParametersAreNonnullByDefault
@Beta
public class ContextPropagatingCompletableFuture<T>
extends InterruptibleCompletableFuture<T> {
    private final ExecutionContext parentContext;
    private final long deadlinenanos;

    public ContextPropagatingCompletableFuture(ExecutionContext parentContext, long deadlinenanos) {
        this.parentContext = parentContext;
        this.deadlinenanos = deadlinenanos;
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return super.thenApply((Function)ExecutionContexts.propagatingFunction(fn, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return super.thenApplyAsync((Function)ExecutionContexts.propagatingFunction(fn, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return super.thenApplyAsync((Function)ExecutionContexts.propagatingFunction(fn, this.parentContext, null, this.deadlinenanos), executor);
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return super.thenAccept((Consumer)ExecutionContexts.propagatingConsumer(action, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return super.thenAcceptAsync((Consumer)ExecutionContexts.propagatingConsumer(action, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return super.thenAcceptAsync((Consumer)ExecutionContexts.propagatingConsumer(action, this.parentContext, null, this.deadlinenanos), executor);
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        return super.thenRun(ExecutionContexts.propagatingRunnable(action, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return super.thenRunAsync(ExecutionContexts.propagatingRunnable(action, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return super.thenRunAsync(ExecutionContexts.propagatingRunnable(action, this.parentContext, null, this.deadlinenanos), executor);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return super.thenCombine((CompletionStage)other, (BiFunction)ExecutionContexts.propagatingBiFunction(fn, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return super.thenCombineAsync((CompletionStage)other, (BiFunction)ExecutionContexts.propagatingBiFunction(fn, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return super.thenCombineAsync((CompletionStage)other, (BiFunction)ExecutionContexts.propagatingBiFunction(fn, this.parentContext, null, this.deadlinenanos), executor);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return super.thenAcceptBoth((CompletionStage)other, (BiConsumer)ExecutionContexts.propagatingBiConsumer(action, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return super.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)ExecutionContexts.propagatingBiConsumer(action, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return super.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)ExecutionContexts.propagatingBiConsumer(action, this.parentContext, null, this.deadlinenanos), executor);
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return super.runAfterBoth((CompletionStage)other, ExecutionContexts.propagatingRunnable(action, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return super.runAfterBothAsync((CompletionStage)other, ExecutionContexts.propagatingRunnable(action, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return super.runAfterBothAsync((CompletionStage)other, ExecutionContexts.propagatingRunnable(action, this.parentContext, null, this.deadlinenanos), executor);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return super.applyToEither((CompletionStage)other, (Function)ExecutionContexts.propagatingFunction(fn, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return super.applyToEitherAsync((CompletionStage)other, (Function)ExecutionContexts.propagatingFunction(fn, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return super.applyToEitherAsync((CompletionStage)other, (Function)ExecutionContexts.propagatingFunction(fn, this.parentContext, null, this.deadlinenanos), executor);
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return super.acceptEither((CompletionStage)other, (Consumer)ExecutionContexts.propagatingConsumer(action, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return super.acceptEitherAsync((CompletionStage)other, (Consumer)ExecutionContexts.propagatingConsumer(action, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return super.acceptEitherAsync((CompletionStage)other, (Consumer)ExecutionContexts.propagatingConsumer(action, this.parentContext, null, this.deadlinenanos), executor);
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return super.runAfterEither((CompletionStage)other, ExecutionContexts.propagatingRunnable(action, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return super.runAfterEitherAsync((CompletionStage)other, ExecutionContexts.propagatingRunnable(action, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return super.runAfterEitherAsync((CompletionStage)other, ExecutionContexts.propagatingRunnable(action, this.parentContext, null, this.deadlinenanos), executor);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return super.thenCompose((Function)ExecutionContexts.propagatingFunction(fn, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return super.thenComposeAsync((Function)ExecutionContexts.propagatingFunction(fn, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return super.thenComposeAsync((Function)ExecutionContexts.propagatingFunction(fn, this.parentContext, null, this.deadlinenanos), executor);
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return super.exceptionally((Function)ExecutionContexts.propagatingFunction(fn, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return super.whenComplete((BiConsumer)ExecutionContexts.propagatingBiConsumer(action, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return super.whenCompleteAsync((BiConsumer)ExecutionContexts.propagatingBiConsumer(action, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return super.whenCompleteAsync((BiConsumer)ExecutionContexts.propagatingBiConsumer(action, this.parentContext, null, this.deadlinenanos), executor);
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return super.handle((BiFunction)ExecutionContexts.propagatingBiFunction(fn, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return super.handleAsync((BiFunction)ExecutionContexts.propagatingBiFunction(fn, this.parentContext, null, this.deadlinenanos));
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return super.handleAsync((BiFunction)ExecutionContexts.propagatingBiFunction(fn, this.parentContext, null, this.deadlinenanos), executor);
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this;
    }

    @Override
    public String toString() {
        return "ContextPropagatingCompletableFuture{parentContext=" + this.parentContext + ", deadlinenanos=" + this.deadlinenanos + ", super=" + super.toString() + '}';
    }

    @Override
    @Nullable
    public T get() throws InterruptedException, ExecutionException {
        try {
            long timeout = this.deadlinenanos - TimeSource.nanoTime();
            if (timeout < 0L) {
                throw new UncheckedTimeoutException("deadline exceeded " + Timing.getCurrentTiming().fromNanoTimeToInstant(this.deadlinenanos));
            }
            return super.get(timeout, TimeUnit.NANOSECONDS);
        }
        catch (TimeoutException ex) {
            throw new UncheckedTimeoutException(ex);
        }
    }

    @Override
    public CompletableFuture<T> completeAsync(Supplier<? extends T> supplier) {
        try {
            return (CompletableFuture)this.getClass().getMethod("completeAsync", Supplier.class).invoke((Object)this, ExecutionContexts.propagatingSupplier(supplier, this.parentContext, null, this.deadlinenanos));
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new UnsupportedOperationException("Supported only on JDK 11", ex);
        }
    }

    @Override
    public CompletableFuture<T> completeAsync(Supplier<? extends T> supplier, Executor executor) {
        try {
            return (CompletableFuture)this.getClass().getMethod("completeAsync", Supplier.class, Executor.class).invoke((Object)this, ExecutionContexts.propagatingSupplier(supplier, this.parentContext, null, this.deadlinenanos), executor);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new UnsupportedOperationException("Supported only on JDK 11", ex);
        }
    }

    @Override
    public <U> CompletableFuture<U> newIncompleteFuture() {
        return new ContextPropagatingCompletableFuture<T>(this.parentContext, this.deadlinenanos);
    }

    public static <U> CompletableFuture<U> supplyAsync(Supplier<U> f) {
        return ContextPropagatingCompletableFuture.supplyAsync(f, DefaultExecutor.INSTANCE);
    }

    public static <U> CompletableFuture<U> supplyAsync(Supplier<U> f, Executor e) {
        ExecutionContext current = ExecutionContexts.current();
        if (current == null) {
            return CompletableFuture.supplyAsync(f, e);
        }
        return ContextPropagatingCompletableFuture.supplyAsync(f, current, e, current.getDeadlineNanos());
    }

    public static <U> CompletableFuture<U> supplyAsync(Supplier<U> f, Executor e, long deadlineNanos) {
        ExecutionContext current = ExecutionContexts.current();
        if (current == null) {
            return CompletableFuture.supplyAsync(f, e);
        }
        return ContextPropagatingCompletableFuture.supplyAsync(f, current, e, deadlineNanos);
    }

    public static <U> CompletableFuture<U> supplyAsync(Supplier<U> f, ExecutionContext current, Executor e, long deadlineNanos) {
        long currentTime;
        long ctxDeadlineNanos = current.getDeadlineNanos();
        long effectiveDeadlineNanos = ctxDeadlineNanos - (currentTime = TimeSource.nanoTime()) > deadlineNanos - currentTime ? deadlineNanos : ctxDeadlineNanos;
        ContextPropagatingCompletableFuture d = new ContextPropagatingCompletableFuture(current, effectiveDeadlineNanos);
        e.execute(() -> {
            try {
                Object r;
                try (ExecutionContext ec = ExecutionContexts.start(f.toString(), current, currentTime, effectiveDeadlineNanos);){
                    r = f.get();
                }
                d.complete(r);
            }
            catch (Throwable t) {
                d.completeExceptionally(t);
            }
        });
        return d;
    }

    public static <U> CompletableFuture<U> completedFuture(U value) {
        ExecutionContext current = ExecutionContexts.current();
        if (current == null) {
            return CompletableFuture.completedFuture(value);
        }
        return ContextPropagatingCompletableFuture.completedFuture(current, current.getDeadlineNanos(), value);
    }

    public static <U> CompletableFuture<U> completedFuture(ExecutionContext parentContext, long deadlinenanos, U value) {
        ContextPropagatingCompletableFuture<U> r = new ContextPropagatingCompletableFuture<U>(parentContext, deadlinenanos);
        if (!r.complete(value)) {
            throw new IllegalStateException("Cannot be already completed " + r);
        }
        return r;
    }
}

