/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.spf4j.base.ExecutionContext;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.base.TimeoutDeadline;
import org.spf4j.base.Wrapper;
import org.spf4j.concurrent.Futures;

public class ContextPropagatingExecutorService
implements ExecutorService,
Wrapper<ExecutorService> {
    private final ExecutorService es;

    public ContextPropagatingExecutorService(ExecutorService wrapped) {
        this.es = wrapped;
    }

    @Override
    public final void shutdown() {
        this.es.shutdown();
    }

    @Override
    public final List<Runnable> shutdownNow() {
        return this.es.shutdownNow();
    }

    @Override
    public final boolean isShutdown() {
        return this.es.isShutdown();
    }

    @Override
    public final boolean isTerminated() {
        return this.es.isTerminated();
    }

    @Override
    public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.es.awaitTermination(timeout, unit);
    }

    @Override
    public final <T> Future<T> submit(Callable<T> task) {
        return this.es.submit(ExecutionContexts.propagatingCallable(task));
    }

    @Override
    public final <T> Future<T> submit(Runnable task, T result) {
        return this.es.submit(ExecutionContexts.propagatingRunnable(task), result);
    }

    @Override
    public final Future<?> submit(Runnable task) {
        return this.es.submit(ExecutionContexts.propagatingRunnable(task));
    }

    @Override
    public final <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.es.invokeAll(ExecutionContexts.propagatingCallables(tasks));
    }

    @Override
    public final <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        TimeoutDeadline td;
        ExecutionContext current = ExecutionContexts.current();
        if (current == null) {
            return this.es.invokeAll(tasks, timeout, unit);
        }
        try {
            td = ExecutionContexts.computeTimeoutDeadline(current, unit, timeout);
        }
        catch (TimeoutException ex) {
            return Futures.timedOutFutures(tasks.size(), ex);
        }
        return this.es.invokeAll(ExecutionContexts.deadlinedPropagatingCallables(tasks, current, td.getDeadlineNanos()), td.getTimeoutNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    public final <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.es.invokeAny(ExecutionContexts.propagatingCallables(tasks));
    }

    @Override
    public final <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutionContext current = ExecutionContexts.current();
        if (current == null) {
            return this.es.invokeAny(tasks, timeout, unit);
        }
        TimeoutDeadline td = ExecutionContexts.computeTimeoutDeadline(current, unit, timeout);
        return this.es.invokeAny(ExecutionContexts.deadlinedPropagatingCallables(tasks, current, td.getDeadlineNanos()), td.getTimeoutNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    public final void execute(Runnable command) {
        this.es.execute(ExecutionContexts.propagatingRunnable(command));
    }

    public final String toString() {
        return "ContextPropagatingExecutorService{wrapped=" + this.es + '}';
    }

    @Override
    public ExecutorService getWrapped() {
        return this.es;
    }
}

