/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.concurrent.ContextPropagatingExecutorService;

public final class ContextPropagatingScheduledExecutorService
extends ContextPropagatingExecutorService
implements ScheduledExecutorService {
    private final ScheduledExecutorService ses;

    public ContextPropagatingScheduledExecutorService(ScheduledExecutorService sex) {
        super(sex);
        this.ses = sex;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.ses.schedule(ExecutionContexts.propagatingRunnable(command), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.ses.schedule(ExecutionContexts.propagatingCallable(callable), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.ses.scheduleAtFixedRate(ExecutionContexts.propagatingRunnable(command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.ses.scheduleWithFixedDelay(ExecutionContexts.propagatingRunnable(command), initialDelay, delay, unit);
    }

    @Override
    public ScheduledExecutorService getWrapped() {
        return this.ses;
    }
}

