/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class CustomThreadFactory
implements ThreadFactory {
    private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final boolean daemon;
    private final int priority;

    public CustomThreadFactory(String name, boolean daemon) {
        this(name, daemon, 5);
    }

    public CustomThreadFactory(String name, boolean daemon, int priority) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = name + POOL_NUMBER.getAndIncrement() + "-thread-";
        this.daemon = daemon;
        this.priority = priority;
    }

    @Override
    @SuppressFBWarnings(value={"MDM_THREAD_PRIORITIES"})
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        t.setDaemon(this.daemon);
        t.setPriority(this.priority);
        return t;
    }

    public String toString() {
        return "CustomThreadFactory{group=" + this.group + ", threadNumber=" + this.threadNumber + ", namePrefix=" + this.namePrefix + ", daemon=" + this.daemon + ", priority=" + this.priority + '}';
    }
}

