/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.Runtime;
import org.spf4j.concurrent.CustomThreadFactory;
import org.spf4j.concurrent.LifoThreadPoolExecutorSQP;

@SuppressFBWarnings(value={"HES_EXECUTOR_NEVER_SHUTDOWN"})
public final class DefaultExecutor {
    public static final ExecutorService INSTANCE;

    private DefaultExecutor() {
    }

    public static ExecutorService instance() {
        return INSTANCE;
    }

    static {
        String value;
        int coreThreads = Integer.getInteger("spf4j.executors.defaultExecutor.coreThreads", 0);
        int maxIdleMillis = Integer.getInteger("spf4j.executors.defaultExecutor.maxIdleMillis", 60000);
        boolean isDaemon = Boolean.getBoolean("spf4j.executors.defaultExecutor.daemon");
        String impParam = "spf4j.executors.defaultExecutor.implementation";
        switch (value = System.getProperty("spf4j.executors.defaultExecutor.implementation", "spf4j")) {
            case "spf4j": {
                LifoThreadPoolExecutorSQP lifoExec = new LifoThreadPoolExecutorSQP("defExec", coreThreads, Integer.MAX_VALUE, maxIdleMillis, 0, isDaemon);
                lifoExec.exportJmx();
                INSTANCE = lifoExec;
                break;
            }
            case "fjp": {
                INSTANCE = new ForkJoinPool(Short.MAX_VALUE);
                break;
            }
            case "legacy": {
                INSTANCE = new ThreadPoolExecutor(coreThreads, Integer.MAX_VALUE, (long)maxIdleMillis, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new CustomThreadFactory("defExec", isDaemon));
                break;
            }
            default: {
                throw new IllegalArgumentException("Ivalid setting for spf4j.executors.defaultExecutor.implementation = " + value);
            }
        }
        Runtime.queueHookAtEnd(new AbstractRunnable(true){

            @Override
            public void doRun() throws InterruptedException {
                INSTANCE.shutdown();
                INSTANCE.awaitTermination(Runtime.WAIT_FOR_SHUTDOWN_NANOS, TimeUnit.NANOSECONDS);
                List<Runnable> remaining = INSTANCE.shutdownNow();
                if (remaining.size() > 0) {
                    Runtime.error("Remaining tasks: " + remaining);
                }
            }
        });
    }
}

