/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.base.Either;
import org.spf4j.base.TimeSource;

@Deprecated
@ThreadSafe
@SuppressFBWarnings(value={"NOS_NON_OWNED_SYNCHRONIZATION"})
public class FutureBean<T>
implements Future<T> {
    private volatile Either<T, ? extends Exception> resultStore;
    private volatile boolean isCanceled;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        this.isCanceled = true;
        return true;
    }

    @Override
    public final boolean isCancelled() {
        return this.isCanceled;
    }

    @Override
    public final boolean isDone() {
        return this.isCanceled || this.resultStore != null;
    }

    public final Either<T, ? extends Exception> getResultStore() {
        return this.resultStore;
    }

    @Override
    @SuppressFBWarnings(value={"BED_BOGUS_EXCEPTION_DECLARATION", "MDM_WAIT_WITHOUT_TIMEOUT"})
    public final synchronized T get() throws InterruptedException, ExecutionException {
        while (this.resultStore == null) {
            this.wait();
        }
        return FutureBean.processResult(this.resultStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long timeoutMillis;
        long toWait = timeoutMillis = unit.toMillis(timeout);
        long startTime = TimeSource.nanoTime();
        FutureBean futureBean = this;
        synchronized (futureBean) {
            while (toWait > 0L && this.resultStore == null) {
                this.wait(toWait);
                toWait = timeoutMillis - (TimeSource.nanoTime() - startTime);
            }
            if (this.resultStore == null) {
                throw new TimeoutException();
            }
            return FutureBean.processResult(this.resultStore);
        }
    }

    @SuppressFBWarnings(value={"ITC_INHERITANCE_TYPE_CHECKING"})
    public static <T> T processResult(Either<T, ? extends Exception> result) throws ExecutionException {
        if (result.isLeft()) {
            return result.getLeft();
        }
        Exception e = result.getRight();
        if (e instanceof ExecutionException) {
            throw (ExecutionException)e;
        }
        if (e instanceof IllegalStateException) {
            throw (IllegalStateException)e;
        }
        throw new IllegalStateException(e);
    }

    public final synchronized void setResult(T result) {
        if (this.resultStore != null) {
            throw new IllegalStateException("cannot set result multiple times " + result);
        }
        this.resultStore = Either.left(result);
        this.done();
        this.notifyAll();
    }

    public final synchronized void setExceptionResult(ExecutionException result) {
        if (this.resultStore != null) {
            throw new IllegalStateException("cannot set result multiple times " + result);
        }
        this.resultStore = Either.right(result);
        this.done();
        this.notifyAll();
    }

    public final synchronized void setCancelationResult(CancellationException result) {
        if (this.resultStore != null) {
            throw new IllegalStateException("cannot set result multiple times " + result);
        }
        this.resultStore = Either.right(result);
        this.done();
        this.notifyAll();
    }

    public void done() {
    }

    public final String toString() {
        return "FutureBean{resultStore=" + this.resultStore + '}';
    }
}

